/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.collect.Statistics;
import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.LineNumber;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.generic.Type;

@OpcodeStack.CustomUserValue
public class PossiblyRedundantMethodCalls
extends BytecodeScanningDetector {
    public static final String PRMC_RISKY_FIELD_USER_KEY = "fbcontrib.PRMC.riskynames";
    public static final String PRMC_RISKY_CLASS_USER_KEY = "fbcontrib.PRMC.riskyclasses";
    public static final String PRMC_HIGH_BYTECOUNT = "fbcontrib.PRMC.highbytecount";
    public static final String PRMC_HIGH_METHODCALLS = "fbcontrib.PRMC.highmethodcalls";
    public static final String PRMC_NORMAL_BYTECOUNT = "fbcontrib.PRMC.normalbytecount";
    public static final String PRMC_NORMAL_METHODCALLS = "fbcontrib.PRMC.normalmethodcalls";
    private static Set<String> riskyMethodNameContents;
    private static int highByteCountLimit;
    private static int highMethodCallLimit;
    private static int normalByteCountLimit;
    private static int normalMethodCallLimit;
    private static Set<String> riskyClassNames;
    private final BugReporter bugReporter;
    private OpcodeStack stack = null;
    private Map<Integer, MethodCall> localMethodCalls = null;
    private Map<String, MethodCall> fieldMethodCalls = null;
    private Map<String, MethodCall> staticMethodCalls = null;
    private BitSet branchTargets = null;

    public PossiblyRedundantMethodCalls(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            this.localMethodCalls = new HashMap<Integer, MethodCall>();
            this.fieldMethodCalls = new HashMap<String, MethodCall>();
            this.staticMethodCalls = new HashMap<String, MethodCall>();
            this.branchTargets = new BitSet();
            super.visitClassContext(classContext);
            Object var3_2 = null;
            this.stack = null;
            this.localMethodCalls = null;
            this.fieldMethodCalls = null;
            this.staticMethodCalls = null;
            this.branchTargets = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.stack = null;
            this.localMethodCalls = null;
            this.fieldMethodCalls = null;
            this.staticMethodCalls = null;
            this.branchTargets = null;
            throw throwable;
        }
    }

    public void visitCode(Code obj) {
        CodeException[] codeExceptions;
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        this.localMethodCalls.clear();
        this.fieldMethodCalls.clear();
        this.staticMethodCalls.clear();
        this.branchTargets.clear();
        for (CodeException codeEx : codeExceptions = obj.getExceptionTable()) {
            this.branchTargets.set(codeEx.getHandlerPC());
        }
        super.visitCode(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sawOpcode(int seen) {
        String userValue;
        block28: {
            block30: {
                block29: {
                    userValue = null;
                    try {
                        String fieldSource;
                        MethodCall mc;
                        this.stack.precomputation((DismantleBytecode)this);
                        int pc = this.getPC();
                        if (this.branchTargets.get(pc)) {
                            this.localMethodCalls.clear();
                            this.fieldMethodCalls.clear();
                            this.branchTargets.clear(pc);
                        }
                        if (seen >= 153 && seen <= 167 || seen >= 198 && seen <= 200) {
                            this.branchTargets.set(this.getBranchTarget());
                            break block28;
                        }
                        if (seen == 170 || seen == 171) {
                            int[] offsets;
                            for (int offset : offsets = this.getSwitchOffsets()) {
                                this.branchTargets.set(offset + pc);
                            }
                            break block28;
                        }
                        if (seen == 58 || seen >= 75 && seen <= 78) {
                            this.localMethodCalls.remove(RegisterUtils.getAStoreReg((DismantleBytecode)this, seen));
                            break block28;
                        }
                        if (seen == 181) {
                            OpcodeStack.Item item;
                            String fieldSource2 = "";
                            if (this.stack.getStackDepth() > 0 && (fieldSource2 = (String)(item = this.stack.getStackItem(0)).getUserValue()) == null) {
                                fieldSource2 = "";
                            }
                            this.fieldMethodCalls.remove(fieldSource2 + ":" + this.getNameConstantOperand());
                            break block28;
                        }
                        if (seen == 180) {
                            OpcodeStack.Item item;
                            if (this.stack.getStackDepth() <= 0 || (userValue = (String)(item = this.stack.getStackItem(0)).getUserValue()) != null) break block28;
                            int reg = item.getRegisterNumber();
                            if (reg >= 0) {
                                userValue = String.valueOf(reg);
                                break block28;
                            }
                            XField xf = item.getXField();
                            if (xf != null) {
                                userValue = xf.getName();
                            }
                            break block28;
                        }
                        if (seen != 182 && seen != 185 && seen != 184) break block28;
                        String signature = this.getSigConstantOperand();
                        int parmCount = Type.getArgumentTypes((String)signature).length;
                        int neededStackSize = parmCount - (seen == 184 ? 1 : 0);
                        if (this.stack.getStackDepth() <= neededStackSize) break block28;
                        Object[] parmConstants = new Object[parmCount];
                        for (int i = 0; i < parmCount; ++i) {
                            OpcodeStack.Item parm = this.stack.getStackItem(i);
                            parmConstants[i] = parm.getConstant();
                            if (parmConstants[i] != null) continue;
                            Object var18_21 = null;
                            break block29;
                        }
                        String className = this.getClassConstantOperand();
                        int reg = -1;
                        XField field = null;
                        if (seen == 184) {
                            mc = this.staticMethodCalls.get(className);
                        } else {
                            OpcodeStack.Item obj = this.stack.getStackItem(parmCount);
                            reg = obj.getRegisterNumber();
                            field = obj.getXField();
                            if (reg >= 0) {
                                mc = this.localMethodCalls.get(reg);
                            } else {
                                if (field == null) break block30;
                                fieldSource = (String)obj.getUserValue();
                                if (fieldSource == null) {
                                    fieldSource = "";
                                }
                                mc = this.fieldMethodCalls.get(fieldSource + ":" + field.getName());
                            }
                        }
                        String methodName = this.getNameConstantOperand();
                        if (mc != null) {
                            int ln;
                            Object[] parms;
                            if (!signature.endsWith("V") && methodName.equals(mc.getName()) && signature.equals(mc.getSignature()) && !this.isRiskyName(className, methodName) && Arrays.equals(parms = mc.getParms(), parmConstants) && ((ln = this.getLineNumber(pc)) != mc.getLineNumber() || Math.abs(pc - mc.getPC()) < 10)) {
                                Statistics statistics = Statistics.getStatistics();
                                Statistics.MethodInfo mi = statistics.getMethodStatistics(this.getClassConstantOperand(), methodName, signature);
                                this.bugReporter.reportBug(new BugInstance((Detector)this, "PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS", mi.numBytes >= highByteCountLimit || mi.numMethodCalls >= highMethodCallLimit ? 1 : (mi.numBytes >= normalByteCountLimit || mi.numMethodCalls >= normalMethodCallLimit ? 2 : (mi.numBytes == 0 || mi.numMethodCalls == 0 ? 3 : 4))).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this).addString(methodName + signature));
                            }
                            if (seen == 184) {
                                this.staticMethodCalls.remove(className);
                                break block28;
                            }
                            if (reg >= 0) {
                                this.localMethodCalls.remove(reg);
                                break block28;
                            }
                            if (field != null) {
                                OpcodeStack.Item item;
                                fieldSource = "";
                                if (this.stack.getStackDepth() > 0 && (fieldSource = (String)(item = this.stack.getStackItem(0)).getUserValue()) == null) {
                                    fieldSource = "";
                                }
                                this.fieldMethodCalls.remove(fieldSource + ":" + field.getName());
                            }
                            break block28;
                        }
                        int ln = this.getLineNumber(pc);
                        if (seen == 184) {
                            this.staticMethodCalls.put(className, new MethodCall(methodName, signature, parmConstants, pc, ln));
                            break block28;
                        }
                        if (reg >= 0) {
                            this.localMethodCalls.put(reg, new MethodCall(methodName, signature, parmConstants, pc, ln));
                            break block28;
                        }
                        if (field != null) {
                            OpcodeStack.Item obj = this.stack.getStackItem(parmCount);
                            String fieldSource3 = (String)obj.getUserValue();
                            if (fieldSource3 == null) {
                                fieldSource3 = "";
                            }
                            this.fieldMethodCalls.put(fieldSource3 + ":" + field.getName(), new MethodCall(methodName, signature, parmConstants, pc, ln));
                        }
                        break block28;
                    }
                    catch (Throwable throwable) {
                        Object var18_24 = null;
                        this.stack.sawOpcode((DismantleBytecode)this, seen);
                        if (userValue == null) throw throwable;
                        if (this.stack.getStackDepth() <= 0) throw throwable;
                        OpcodeStack.Item item = this.stack.getStackItem(0);
                        item.setUserValue(userValue);
                        throw throwable;
                    }
                }
                this.stack.sawOpcode((DismantleBytecode)this, seen);
                if (userValue == null) return;
                if (this.stack.getStackDepth() <= 0) return;
                OpcodeStack.Item item = this.stack.getStackItem(0);
                item.setUserValue((Object)userValue);
                return;
            }
            Object var18_22 = null;
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            if (userValue == null) return;
            if (this.stack.getStackDepth() <= 0) return;
            OpcodeStack.Item item = this.stack.getStackItem(0);
            item.setUserValue((Object)userValue);
            return;
        }
        Object var18_23 = null;
        this.stack.sawOpcode((DismantleBytecode)this, seen);
        if (userValue == null) return;
        if (this.stack.getStackDepth() <= 0) return;
        OpcodeStack.Item item = this.stack.getStackItem(0);
        item.setUserValue(userValue);
    }

    private boolean isRiskyName(String className, String methodName) {
        if (riskyClassNames.contains(className)) {
            return true;
        }
        for (String riskyName : riskyMethodNameContents) {
            if (methodName.indexOf(riskyName) < 0) continue;
            return true;
        }
        return false;
    }

    private int getLineNumber(int pc) {
        LineNumberTable lnt = this.getMethod().getLineNumberTable();
        if (lnt == null) {
            return pc;
        }
        LineNumber[] lns = lnt.getLineNumberTable();
        if (lns == null) {
            return pc;
        }
        if (pc > lns[lns.length - 1].getStartPC()) {
            return lns[lns.length - 1].getLineNumber();
        }
        int lo = 0;
        int hi = lns.length - 2;
        int mid = 0;
        while (lo <= hi) {
            mid = (lo + hi) / 2;
            if (pc < lns[mid].getStartPC()) {
                hi = mid - 1;
                continue;
            }
            if (pc < lns[mid + 1].getStartPC()) break;
            lo = mid + 1;
        }
        return lns[mid].getLineNumber();
    }

    static {
        Integer prop;
        String[] userNames;
        riskyMethodNameContents = new HashSet<String>();
        highByteCountLimit = 200;
        highMethodCallLimit = 10;
        normalByteCountLimit = 50;
        normalMethodCallLimit = 4;
        riskyMethodNameContents.add("next");
        riskyMethodNameContents.add("add");
        riskyMethodNameContents.add("create");
        riskyMethodNameContents.add("append");
        riskyMethodNameContents.add("find");
        riskyMethodNameContents.add("put");
        riskyMethodNameContents.add("remove");
        riskyMethodNameContents.add("read");
        riskyMethodNameContents.add("write");
        riskyMethodNameContents.add("push");
        riskyMethodNameContents.add("pop");
        riskyMethodNameContents.add("scan");
        riskyMethodNameContents.add("skip");
        riskyMethodNameContents.add("clone");
        riskyMethodNameContents.add("close");
        riskyMethodNameContents.add("copy");
        riskyMethodNameContents.add("currentTimeMillis");
        riskyMethodNameContents.add("nanoTime");
        riskyMethodNameContents.add("newInstance");
        riskyMethodNameContents.add("noneOf");
        riskyMethodNameContents.add("allOf");
        riskyMethodNameContents.add("beep");
        String userNameProp = System.getProperty(PRMC_RISKY_FIELD_USER_KEY);
        if (userNameProp != null) {
            for (String name : userNames = userNameProp.split("\\s*,\\s*")) {
                riskyMethodNameContents.add(name);
            }
        }
        if ((prop = Integer.getInteger(PRMC_HIGH_BYTECOUNT)) != null) {
            highByteCountLimit = prop;
        }
        if ((prop = Integer.getInteger(PRMC_HIGH_METHODCALLS)) != null) {
            highMethodCallLimit = prop;
        }
        if ((prop = Integer.getInteger(PRMC_NORMAL_BYTECOUNT)) != null) {
            normalByteCountLimit = prop;
        }
        if ((prop = Integer.getInteger(PRMC_NORMAL_METHODCALLS)) != null) {
            normalMethodCallLimit = prop;
        }
        riskyClassNames = new HashSet<String>();
        riskyClassNames.add("java/nio/ByteBuffer");
        riskyClassNames.add("java/io/DataInputStream");
        riskyClassNames.add("java/io/ObjectInputStream");
        userNameProp = System.getProperty(PRMC_RISKY_CLASS_USER_KEY);
        if (userNameProp != null) {
            for (String name : userNames = userNameProp.split("\\s*,\\s*")) {
                riskyClassNames.add(name);
            }
        }
    }

    static class MethodCall {
        private final String methodName;
        private final String methodSignature;
        private final Object[] methodParms;
        private final int methodPC;
        private final int methodLineNumber;

        public MethodCall(String name, String signature, Object[] parms, int pc, int lineNumber) {
            this.methodName = name;
            this.methodSignature = signature;
            this.methodParms = parms;
            this.methodPC = pc;
            this.methodLineNumber = lineNumber;
        }

        public String getName() {
            return this.methodName;
        }

        public String getSignature() {
            return this.methodSignature;
        }

        public Object[] getParms() {
            return this.methodParms;
        }

        public int getPC() {
            return this.methodPC;
        }

        public int getLineNumber() {
            return this.methodLineNumber;
        }
    }
}

