/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.generic.Type;

@OpcodeStack.CustomUserValue
public class PresizeCollections
extends BytecodeScanningDetector {
    private static final Set<String> PRESIZEABLE_COLLECTIONS = new HashSet<String>();
    private BugReporter bugReporter;
    private OpcodeStack stack;
    private int allocNumber;
    private Map<Integer, Integer> allocLocation;
    private Map<Integer, List<Integer>> allocToAddPCs;
    private List<DownBranch> downBranches;

    public PresizeCollections(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            this.allocLocation = new HashMap<Integer, Integer>();
            this.allocToAddPCs = new HashMap<Integer, List<Integer>>();
            this.downBranches = new ArrayList<DownBranch>();
            super.visitClassContext(classContext);
            Object var3_2 = null;
            this.stack = null;
            this.allocLocation = null;
            this.allocToAddPCs = null;
            this.downBranches = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.stack = null;
            this.allocLocation = null;
            this.allocToAddPCs = null;
            this.downBranches = null;
            throw throwable;
        }
    }

    public void visitCode(Code obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        this.allocNumber = 0;
        this.allocLocation.clear();
        this.allocToAddPCs.clear();
        this.downBranches.clear();
        super.visitCode(obj);
        for (List<Integer> pcs : this.allocToAddPCs.values()) {
            if (pcs.size() <= 16) continue;
            this.bugReporter.reportBug(new BugInstance((Detector)this, "PSC_PRESIZE_COLLECTIONS", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this, pcs.get(0).intValue()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sawOpcode(int seen) {
        boolean sawAlloc = false;
        try {
            this.stack.precomputation((DismantleBytecode)this);
            switch (seen) {
                case 183: {
                    String clsName = this.getClassConstantOperand();
                    if (PRESIZEABLE_COLLECTIONS.contains(clsName)) {
                        String signature;
                        String methodName = this.getNameConstantOperand();
                        if (!"<init>".equals(methodName) || !"()V".equals(signature = this.getSigConstantOperand())) break;
                        sawAlloc = true;
                    }
                    break;
                }
                case 185: {
                    String methodName = this.getNameConstantOperand();
                    if ("add".equals(methodName) || "addAll".equals(methodName)) {
                        OpcodeStack.Item item;
                        Integer allocNum;
                        String signature = this.getSigConstantOperand();
                        Type[] argTypes = Type.getArgumentTypes((String)signature);
                        if (argTypes.length != 1 || this.stack.getStackDepth() <= 1 || (allocNum = (Integer)(item = this.stack.getStackItem(1)).getUserValue()) == null) break;
                        if ("addAll".equals(methodName)) {
                            this.allocToAddPCs.remove(allocNum);
                            break;
                        }
                        List<Integer> lines = this.allocToAddPCs.get(allocNum);
                        if (lines == null) {
                            lines = new ArrayList<Integer>();
                            this.allocToAddPCs.put(allocNum, lines);
                        }
                        lines.add(this.getPC());
                        break;
                    }
                    if ("put".equals(methodName) || "putAll".equals(methodName)) {
                        OpcodeStack.Item item;
                        Integer allocNum;
                        String signature = this.getSigConstantOperand();
                        Type[] argTypes = Type.getArgumentTypes((String)signature);
                        if (argTypes.length != 2 || this.stack.getStackDepth() <= 2 || (allocNum = (Integer)(item = this.stack.getStackItem(2)).getUserValue()) == null) break;
                        if ("putAll".equals(methodName)) {
                            this.allocToAddPCs.remove(allocNum);
                            break;
                        }
                        List<Integer> lines = this.allocToAddPCs.get(allocNum);
                        if (lines == null) {
                            lines = new ArrayList<Integer>();
                            this.allocToAddPCs.put(allocNum, lines);
                        }
                        lines.add(this.getPC());
                    }
                    break;
                }
                case 170: 
                case 171: {
                    int[] offsets = this.getSwitchOffsets();
                    if (offsets.length > 1) {
                        int secondCase = offsets[1] + this.getPC();
                        DownBranch db = new DownBranch(this.getPC(), secondCase);
                        this.downBranches.add(db);
                    }
                    break;
                }
                case 153: 
                case 154: 
                case 155: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 200: {
                    if (this.getBranchOffset() < 0) {
                        int target = this.getBranchTarget();
                        Iterator<Map.Entry<Integer, List<Integer>>> it = this.allocToAddPCs.entrySet().iterator();
                        block8: while (it.hasNext()) {
                            Map.Entry<Integer, List<Integer>> entry = it.next();
                            Integer allocLoc = this.allocLocation.get(entry.getKey());
                            if (allocLoc == null || allocLoc >= target) continue;
                            List<Integer> pcs = entry.getValue();
                            for (Integer pc : pcs) {
                                if (pc <= target) continue;
                                int numDownBranches = this.countDownBranches(target, pc);
                                if (numDownBranches != 1) continue block8;
                                this.bugReporter.reportBug(new BugInstance((Detector)this, "PSC_PRESIZE_COLLECTIONS", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this, pc.intValue()));
                                it.remove();
                                continue block8;
                            }
                        }
                        break;
                    } else {
                        DownBranch db = new DownBranch(this.getPC(), this.getBranchTarget());
                        this.downBranches.add(db);
                        break;
                    }
                }
            }
            Object var15_29 = null;
        }
        catch (Throwable throwable) {
            Object var15_30 = null;
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            if (!sawAlloc) throw throwable;
            if (this.stack.getStackDepth() <= 0) throw throwable;
            OpcodeStack.Item item = this.stack.getStackItem(0);
            ++this.allocNumber;
            item.setUserValue((Object)this.allocNumber);
            this.allocLocation.put(this.allocNumber, this.getPC());
            throw throwable;
        }
        this.stack.sawOpcode((DismantleBytecode)this, seen);
        if (!sawAlloc) return;
        if (this.stack.getStackDepth() <= 0) return;
        OpcodeStack.Item item = this.stack.getStackItem(0);
        ++this.allocNumber;
        item.setUserValue((Object)this.allocNumber);
        this.allocLocation.put(this.allocNumber, this.getPC());
    }

    private int countDownBranches(int loopTop, int addPC) {
        int numDownBranches = 0;
        for (DownBranch db : this.downBranches) {
            if (db.fromPC <= loopTop || db.fromPC >= addPC || db.toPC <= addPC) continue;
            ++numDownBranches;
        }
        return numDownBranches;
    }

    static {
        PRESIZEABLE_COLLECTIONS.add("java/util/ArrayBlockingQueue");
        PRESIZEABLE_COLLECTIONS.add("java/util/ArrayDeque");
        PRESIZEABLE_COLLECTIONS.add("java/util/ArrayList");
        PRESIZEABLE_COLLECTIONS.add("java/util/HashMap");
        PRESIZEABLE_COLLECTIONS.add("java/util/HashSet");
        PRESIZEABLE_COLLECTIONS.add("java/util/LinkedBlockingQueue");
        PRESIZEABLE_COLLECTIONS.add("java/util/LinkedHashMap");
        PRESIZEABLE_COLLECTIONS.add("java/util/LinkedHashSet");
        PRESIZEABLE_COLLECTIONS.add("java/util/PriorityBlockingQueue");
        PRESIZEABLE_COLLECTIONS.add("java/util/PriorityQueue");
        PRESIZEABLE_COLLECTIONS.add("java/util/Vector");
    }

    static class DownBranch {
        public int fromPC;
        public int toPC;

        public DownBranch(int from, int to) {
            this.fromPC = from;
            this.toPC = to;
        }

        public String toString() {
            return "DownBranch[From: " + this.fromPC + " To: " + this.toPC + "]";
        }
    }
}

