/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import com.mebigfatguy.fbcontrib.utils.TernaryPatcher;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

@OpcodeStack.CustomUserValue
public class ReflectionOnObjectMethods
extends BytecodeScanningDetector {
    private static final Set<String> objectSigs = new HashSet<String>();
    private final BugReporter bugReporter;
    private OpcodeStack stack;
    private Map<Integer, String[]> localClassTypes;
    private Map<String, String[]> fieldClassTypes;

    public ReflectionOnObjectMethods(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            this.localClassTypes = new HashMap<Integer, String[]>();
            this.fieldClassTypes = new HashMap<String, String[]>();
            JavaClass cls = classContext.getJavaClass();
            Method staticInit = this.findStaticInitializer(cls);
            if (staticInit != null) {
                this.setupVisitorForClass(cls);
                this.doVisitMethod(staticInit);
            }
            super.visitClassContext(classContext);
            Object var5_4 = null;
            this.stack = null;
            this.localClassTypes = null;
            this.fieldClassTypes = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.stack = null;
            this.localClassTypes = null;
            this.fieldClassTypes = null;
            throw throwable;
        }
    }

    public void visitCode(Code obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        this.localClassTypes.clear();
        super.visitCode(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sawOpcode(int seen) {
        String[] loadedTypes;
        Integer arraySize;
        block25: {
            block27: {
                block26: {
                    arraySize = null;
                    loadedTypes = null;
                    try {
                        this.stack.precomputation((DismantleBytecode)this);
                        switch (seen) {
                            case 189: {
                                if ("java/lang/Class".equals(this.getClassConstantOperand()) && this.stack.getStackDepth() >= 1) {
                                    OpcodeStack.Item item = this.stack.getStackItem(0);
                                    arraySize = (Integer)item.getConstant();
                                    break;
                                }
                                break block25;
                            }
                            case 83: {
                                if (this.stack.getStackDepth() >= 3) {
                                    OpcodeStack.Item indexItem;
                                    Integer index;
                                    OpcodeStack.Item valueItem;
                                    String type;
                                    OpcodeStack.Item arrayItem = this.stack.getStackItem(2);
                                    String[] arrayTypes = (String[])arrayItem.getUserValue();
                                    if (arrayTypes != null && (type = (String)(valueItem = this.stack.getStackItem(0)).getConstant()) != null && (index = (Integer)(indexItem = this.stack.getStackItem(1)).getConstant()) != null) {
                                        arrayTypes[index.intValue()] = type;
                                        break;
                                    }
                                }
                                break block25;
                            }
                            case 179: 
                            case 181: {
                                OpcodeStack.Item item;
                                String[] arrayTypes;
                                String name = this.getNameConstantOperand();
                                if (this.stack.getStackDepth() >= 1 && (arrayTypes = (String[])(item = this.stack.getStackItem(0)).getUserValue()) != null) {
                                    this.fieldClassTypes.put(name, arrayTypes);
                                    Object var13_28 = null;
                                    break block26;
                                } else {
                                    this.fieldClassTypes.remove(name);
                                    break;
                                }
                            }
                            case 178: 
                            case 180: {
                                String name = this.getNameConstantOperand();
                                loadedTypes = this.fieldClassTypes.get(name);
                                break;
                            }
                            case 58: 
                            case 75: 
                            case 76: 
                            case 77: 
                            case 78: {
                                OpcodeStack.Item item;
                                String[] arrayTypes;
                                Integer reg = RegisterUtils.getAStoreReg((DismantleBytecode)this, seen);
                                if (this.stack.getStackDepth() >= 1 && (arrayTypes = (String[])(item = this.stack.getStackItem(0)).getUserValue()) != null) {
                                    this.localClassTypes.put(reg, arrayTypes);
                                    break block27;
                                } else {
                                    this.localClassTypes.remove(reg);
                                    break;
                                }
                            }
                            case 25: 
                            case 42: 
                            case 43: 
                            case 44: 
                            case 45: {
                                int reg = RegisterUtils.getAStoreReg((DismantleBytecode)this, seen);
                                loadedTypes = this.localClassTypes.get(reg);
                                break;
                            }
                            case 182: {
                                OpcodeStack.Item methodItem;
                                String[] arrayTypes;
                                String method;
                                String cls = this.getClassConstantOperand();
                                if ("java/lang/Class".equals(cls)) {
                                    String reflectionSig;
                                    OpcodeStack.Item methodItem2;
                                    String methodName;
                                    OpcodeStack.Item clsArgs;
                                    String[] arrayTypes2;
                                    String sig;
                                    String method2 = this.getNameConstantOperand();
                                    if ("getMethod".equals(method2) && "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;".equals(sig = this.getSigConstantOperand()) && this.stack.getStackDepth() >= 2 && ((arrayTypes2 = (String[])(clsArgs = this.stack.getStackItem(0)).getUserValue()) != null || clsArgs.isNull()) && (methodName = (String)(methodItem2 = this.stack.getStackItem(1)).getConstant()) != null && objectSigs.contains(reflectionSig = this.buildReflectionSignature(methodName, arrayTypes2))) {
                                        loadedTypes = arrayTypes2 == null ? new String[]{} : arrayTypes2;
                                        break;
                                    }
                                    break block25;
                                }
                                if ("java/lang/reflect/Method".equals(cls) && "invoke".equals(method = this.getNameConstantOperand()) && this.stack.getStackDepth() >= 3 && (arrayTypes = (String[])(methodItem = this.stack.getStackItem(2)).getUserValue()) != null) {
                                    this.bugReporter.reportBug(new BugInstance((Detector)this, "ROOM_REFLECTION_ON_OBJECT_METHODS", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                                }
                                break block25;
                            }
                        }
                        break block25;
                    }
                    catch (Throwable throwable) {
                        Object var13_31 = null;
                        TernaryPatcher.pre(this.stack, seen);
                        this.stack.sawOpcode((DismantleBytecode)this, seen);
                        TernaryPatcher.post(this.stack, seen);
                        if (arraySize != null) {
                            if (this.stack.getStackDepth() < 1) throw throwable;
                            OpcodeStack.Item item = this.stack.getStackItem(0);
                            item.setUserValue((Object)new String[arraySize.intValue()]);
                            throw throwable;
                        }
                        if (loadedTypes == null) throw throwable;
                        if (this.stack.getStackDepth() < 1) throw throwable;
                        OpcodeStack.Item item = this.stack.getStackItem(0);
                        item.setUserValue((Object)loadedTypes);
                        throw throwable;
                    }
                }
                TernaryPatcher.pre(this.stack, seen);
                this.stack.sawOpcode((DismantleBytecode)this, seen);
                TernaryPatcher.post(this.stack, seen);
                if (arraySize != null) {
                    if (this.stack.getStackDepth() < 1) return;
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    item.setUserValue((Object)new String[arraySize.intValue()]);
                    return;
                }
                if (loadedTypes == null) return;
                if (this.stack.getStackDepth() < 1) return;
                OpcodeStack.Item item = this.stack.getStackItem(0);
                item.setUserValue((Object)loadedTypes);
                return;
            }
            Object var13_29 = null;
            TernaryPatcher.pre(this.stack, seen);
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            TernaryPatcher.post(this.stack, seen);
            if (arraySize != null) {
                if (this.stack.getStackDepth() < 1) return;
                OpcodeStack.Item item = this.stack.getStackItem(0);
                item.setUserValue((Object)new String[arraySize.intValue()]);
                return;
            }
            if (loadedTypes == null) return;
            if (this.stack.getStackDepth() < 1) return;
            OpcodeStack.Item item = this.stack.getStackItem(0);
            item.setUserValue((Object)loadedTypes);
            return;
        }
        Object var13_30 = null;
        TernaryPatcher.pre(this.stack, seen);
        this.stack.sawOpcode((DismantleBytecode)this, seen);
        TernaryPatcher.post(this.stack, seen);
        if (arraySize != null) {
            if (this.stack.getStackDepth() < 1) return;
            OpcodeStack.Item item = this.stack.getStackItem(0);
            item.setUserValue((Object)new String[arraySize.intValue()]);
            return;
        }
        if (loadedTypes == null) return;
        if (this.stack.getStackDepth() < 1) return;
        OpcodeStack.Item item = this.stack.getStackItem(0);
        item.setUserValue((Object)loadedTypes);
    }

    private String buildReflectionSignature(String methodName, String[] parmTypes) {
        StringBuilder sb = new StringBuilder(64);
        sb.append(methodName);
        sb.append("(");
        if (parmTypes != null) {
            for (String type : parmTypes) {
                sb.append("L");
                if (type == null) {
                    return "";
                }
                sb.append(type);
                if (type.length() <= 1 && "IJ".indexOf(type) >= 0) continue;
                sb.append(";");
            }
        }
        sb.append(")");
        return sb.toString();
    }

    private Method findStaticInitializer(JavaClass cls) {
        Method[] methods;
        for (Method m : methods = cls.getMethods()) {
            if (!"<clinit>".equals(m.getName())) continue;
            return m;
        }
        return null;
    }

    static {
        objectSigs.add("equals(Ljava/lang/Object;)");
        objectSigs.add("finalize()");
        objectSigs.add("getClass()");
        objectSigs.add("hashCode()");
        objectSigs.add("notify()");
        objectSigs.add("notifyAll()");
        objectSigs.add("toString()");
        objectSigs.add("wait");
        objectSigs.add("wait(J)");
        objectSigs.add("wait(JI");
    }
}

