/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import com.mebigfatguy.fbcontrib.utils.TernaryPatcher;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.Type;

@OpcodeStack.CustomUserValue
public class Section508Compliance
extends BytecodeScanningDetector {
    private static final String SAW_TEXT_LABEL = "SAW_TEXT_LABEL";
    private static final String FROM_UIMANAGER = "FROM_UIMANAGER";
    private static final String APPENDED_STRING = "APPENDED_STRING";
    private static JavaClass windowClass;
    private static JavaClass componentClass;
    private static JavaClass jcomponentClass;
    private static JavaClass accessibleClass;
    private static ClassNotFoundException clsNFException;
    private static final Map<String, Integer> displayTextMethods;
    private final BugReporter bugReporter;
    private OpcodeStack stack;
    private Set<XField> fieldLabels;
    private Map<Integer, SourceLineAnnotation> localLabels;

    public Section508Compliance(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        if (clsNFException != null) {
            bugReporter.reportMissingClass(clsNFException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            try {
                JavaClass cls;
                if (jcomponentClass != null && accessibleClass != null && (cls = classContext.getJavaClass()).instanceOf(jcomponentClass) && !cls.implementationOf(accessibleClass)) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "S508C_NON_ACCESSIBLE_JCOMPONENT", 2).addClass(cls));
                }
                this.stack = new OpcodeStack();
                this.fieldLabels = new HashSet<XField>();
                this.localLabels = new HashMap<Integer, SourceLineAnnotation>();
                super.visitClassContext(classContext);
                for (XField fa : this.fieldLabels) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "S508C_NO_SETLABELFOR", 2).addClass((PreorderVisitor)this).addField(fa));
                }
                Object var5_5 = null;
                this.stack = null;
                this.fieldLabels = null;
                this.localLabels = null;
            }
            catch (ClassNotFoundException cnfe) {
                this.bugReporter.reportMissingClass(cnfe);
                Object var5_6 = null;
                this.stack = null;
                this.fieldLabels = null;
                this.localLabels = null;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.stack = null;
            this.fieldLabels = null;
            this.localLabels = null;
            throw throwable;
        }
    }

    public void visitField(Field obj) {
        String fieldSig = obj.getSignature();
        if ("Ljavax/swing/JLabel;".equals(fieldSig)) {
            FieldAnnotation fa = FieldAnnotation.fromVisitedField((PreorderVisitor)this);
            this.fieldLabels.add(XFactory.createXField((FieldAnnotation)fa));
        }
    }

    public void visitCode(Code obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        this.localLabels.clear();
        super.visitCode(obj);
        for (SourceLineAnnotation sla : this.localLabels.values()) {
            BugInstance bug = new BugInstance((Detector)this, "S508C_NO_SETLABELFOR", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this);
            if (sla != null) {
                bug.addSourceLine(sla);
            }
            this.bugReporter.reportBug(bug);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sawOpcode(int seen) {
        boolean sawTextLabel = false;
        boolean sawUIManager = false;
        boolean sawAppend = false;
        try {
            block23: {
                try {
                    block25: {
                        block28: {
                            String methodName;
                            String className;
                            block30: {
                                block29: {
                                    block27: {
                                        String signature;
                                        block26: {
                                            OpcodeStack.Item item;
                                            block24: {
                                                OpcodeStack.Item item2;
                                                this.stack.precomputation((DismantleBytecode)this);
                                                if (seen != 58 && (seen < 75 || seen > 78)) break block24;
                                                if (this.stack.getStackDepth() > 0 && "Ljavax/swing/JLabel;".equals((item2 = this.stack.getStackItem(0)).getSignature()) && SAW_TEXT_LABEL.equals(item2.getUserValue())) {
                                                    int reg = RegisterUtils.getAStoreReg((DismantleBytecode)this, seen);
                                                    this.localLabels.put(reg, SourceLineAnnotation.fromVisitedInstruction((BytecodeScanningDetector)this));
                                                }
                                                break block25;
                                            }
                                            if (seen != 181) break block26;
                                            if (this.stack.getStackDepth() > 0 && !SAW_TEXT_LABEL.equals((item = this.stack.getStackItem(0)).getUserValue())) {
                                                FieldAnnotation fa = new FieldAnnotation(this.getDottedClassName(), this.getNameConstantOperand(), this.getSigConstantOperand(), false);
                                                this.fieldLabels.remove(XFactory.createXField((FieldAnnotation)fa));
                                            }
                                            break block25;
                                        }
                                        if (seen != 183) break block27;
                                        String className2 = this.getClassConstantOperand();
                                        String methodName2 = this.getNameConstantOperand();
                                        if ("javax/swing/JLabel".equals(className2) && "<init>".equals(methodName2) && (signature = this.getSigConstantOperand()).indexOf("Ljava/lang/String;") >= 0) {
                                            sawTextLabel = true;
                                        }
                                        break block25;
                                    }
                                    if (seen != 182) break block28;
                                    className = this.getClassConstantOperand();
                                    methodName = this.getNameConstantOperand();
                                    if (!"javax/swing/JLabel".equals(className)) break block29;
                                    if ("setLabelFor".equals(methodName) && this.stack.getStackDepth() > 1) {
                                        OpcodeStack.Item item = this.stack.getStackItem(1);
                                        XField field = item.getXField();
                                        if (field != null) {
                                            this.fieldLabels.remove(field);
                                            break block30;
                                        } else {
                                            int reg = item.getRegisterNumber();
                                            if (reg >= 0) {
                                                this.localLabels.remove(reg);
                                            }
                                        }
                                    }
                                    break block30;
                                }
                                if ("java/lang/StringBuffer".equals(className) || "java/lang/StringBuilder".equals(className)) {
                                    OpcodeStack.Item item;
                                    if ("append".equals(methodName)) {
                                        if (this.stack.getStackDepth() > 0) {
                                            String literal;
                                            OpcodeStack.Item item2 = this.stack.getStackItem(0);
                                            Object con = item2.getConstant();
                                            sawAppend = con instanceof String ? !(literal = (String)con).startsWith("<") : true;
                                        }
                                    } else if ("toString".equals(methodName) && this.stack.getStackDepth() > 0 && APPENDED_STRING.equals((item = this.stack.getStackItem(0)).getUserValue())) {
                                        sawAppend = true;
                                    }
                                }
                            }
                            this.processSetSizeOps(methodName);
                            this.processNullLayouts(className, methodName);
                            this.processSetColorOps(methodName);
                            break block25;
                        }
                        if (seen == 184 && "javax/swing/UIManager".equals(this.getClassConstantOperand())) {
                            sawUIManager = true;
                        }
                    }
                    if (seen != 182 && seen != 183 && seen != 185) break block23;
                    this.processFaultyGuiStrings();
                }
                catch (ClassNotFoundException cnfe) {
                    this.bugReporter.reportMissingClass(cnfe);
                    Object var11_23 = null;
                    TernaryPatcher.pre(this.stack, seen);
                    this.stack.sawOpcode((DismantleBytecode)this, seen);
                    TernaryPatcher.post(this.stack, seen);
                    if (sawTextLabel) {
                        if (this.stack.getStackDepth() <= 0) return;
                        OpcodeStack.Item item = this.stack.getStackItem(0);
                        item.setUserValue((Object)SAW_TEXT_LABEL);
                        return;
                    }
                    if (sawUIManager) {
                        if (this.stack.getStackDepth() <= 0) return;
                        OpcodeStack.Item item = this.stack.getStackItem(0);
                        item.setUserValue((Object)FROM_UIMANAGER);
                        return;
                    }
                    if (!sawAppend) return;
                    if (this.stack.getStackDepth() <= 0) return;
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    item.setUserValue((Object)APPENDED_STRING);
                    return;
                }
            }
            Object var11_22 = null;
            TernaryPatcher.pre(this.stack, seen);
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            TernaryPatcher.post(this.stack, seen);
            if (sawTextLabel) {
                if (this.stack.getStackDepth() <= 0) return;
                OpcodeStack.Item item = this.stack.getStackItem(0);
                item.setUserValue((Object)SAW_TEXT_LABEL);
                return;
            }
            if (sawUIManager) {
                if (this.stack.getStackDepth() <= 0) return;
                OpcodeStack.Item item = this.stack.getStackItem(0);
                item.setUserValue((Object)FROM_UIMANAGER);
                return;
            }
            if (!sawAppend) return;
            if (this.stack.getStackDepth() <= 0) return;
            OpcodeStack.Item item = this.stack.getStackItem(0);
            item.setUserValue((Object)APPENDED_STRING);
            return;
        }
        catch (Throwable throwable) {
            Object var11_24 = null;
            TernaryPatcher.pre(this.stack, seen);
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            TernaryPatcher.post(this.stack, seen);
            if (sawTextLabel) {
                if (this.stack.getStackDepth() <= 0) throw throwable;
                OpcodeStack.Item item = this.stack.getStackItem(0);
                item.setUserValue((Object)SAW_TEXT_LABEL);
                throw throwable;
            }
            if (sawUIManager) {
                if (this.stack.getStackDepth() <= 0) throw throwable;
                OpcodeStack.Item item = this.stack.getStackItem(0);
                item.setUserValue((Object)FROM_UIMANAGER);
                throw throwable;
            }
            if (!sawAppend) throw throwable;
            if (this.stack.getStackDepth() <= 0) throw throwable;
            OpcodeStack.Item item = this.stack.getStackItem(0);
            item.setUserValue((Object)APPENDED_STRING);
            throw throwable;
        }
    }

    private void processFaultyGuiStrings() {
        StringBuilder methodInfo = new StringBuilder();
        methodInfo.append(this.getClassConstantOperand());
        methodInfo.append("#");
        methodInfo.append(this.getNameConstantOperand());
        String signature = this.getSigConstantOperand();
        signature = signature.substring(0, signature.indexOf(41) + 1);
        methodInfo.append(signature);
        Integer parmIndex = displayTextMethods.get(methodInfo.toString());
        if (parmIndex != null && this.stack.getStackDepth() > parmIndex) {
            OpcodeStack.Item item = this.stack.getStackItem(parmIndex.intValue());
            if (item.getConstant() != null) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "S508C_NON_TRANSLATABLE_STRING", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            } else if (APPENDED_STRING.equals(item.getUserValue())) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "S508C_APPENDED_STRING", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            }
        }
    }

    private void processNullLayouts(String className, String methodName) {
        OpcodeStack.Item item;
        if ("java/awt/Container".equals(className) && "setLayout".equals(methodName) && this.stack.getStackDepth() > 0 && (item = this.stack.getStackItem(0)).isNull()) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "S508C_NULL_LAYOUT", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
        }
    }

    private void processSetColorOps(String methodName) throws ClassNotFoundException {
        if ("setBackground".equals(methodName) || "setForeground".equals(methodName)) {
            OpcodeStack.Item item;
            int argCount = Type.getArgumentTypes((String)this.getSigConstantOperand()).length;
            if (this.stack.getStackDepth() > argCount && !FROM_UIMANAGER.equals((item = this.stack.getStackItem(0)).getUserValue())) {
                item = this.stack.getStackItem(argCount);
                JavaClass cls = item.getJavaClass();
                if (jcomponentClass != null && cls.instanceOf(jcomponentClass) || componentClass != null && cls.instanceOf(componentClass)) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "S508C_SET_COMP_COLOR", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
            }
        }
    }

    private void processSetSizeOps(String methodName) throws ClassNotFoundException {
        if ("setSize".equals(methodName)) {
            OpcodeStack.Item item;
            JavaClass cls;
            int argCount = Type.getArgumentTypes((String)this.getSigConstantOperand()).length;
            if (windowClass != null && this.stack.getStackDepth() > argCount && (cls = (item = this.stack.getStackItem(argCount)).getJavaClass()) != null && cls.instanceOf(windowClass)) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "S508C_NO_SETSIZE", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            }
        }
    }

    static {
        try {
            windowClass = Repository.lookupClass((String)"java/awt/Window");
        }
        catch (ClassNotFoundException cnfe) {
            windowClass = null;
            clsNFException = cnfe;
        }
        try {
            componentClass = Repository.lookupClass((String)"java/awt/Component");
        }
        catch (ClassNotFoundException cnfe) {
            componentClass = null;
            clsNFException = cnfe;
        }
        try {
            jcomponentClass = Repository.lookupClass((String)"javax/swing/JComponent");
        }
        catch (ClassNotFoundException cnfe) {
            jcomponentClass = null;
            clsNFException = cnfe;
        }
        try {
            accessibleClass = Repository.lookupClass((String)"javax.accessibility.Accessible");
        }
        catch (ClassNotFoundException cnfe) {
            accessibleClass = null;
            clsNFException = cnfe;
        }
        displayTextMethods = new HashMap<String, Integer>();
        Integer zero = 0;
        Integer one = 1;
        Integer two = 2;
        displayTextMethods.put("javax/swing/JLabel#<init>(Ljava/lang/String;)", zero);
        displayTextMethods.put("javax/swing/JLabel#<init>(Ljava/lang/String;Ljavax/swing/Icon;I)", one);
        displayTextMethods.put("javax/swing/JLabel#<init>(Ljava/lang/String;I)", two);
        displayTextMethods.put("javax/swing/JButton#<init>(Ljava/lang/String;)", zero);
        displayTextMethods.put("javax/swing/JButton#<init>(Ljava/lang/String;Ljavax/swing/Icon;)", one);
        displayTextMethods.put("javax/swing/JFrame#<init>(Ljava/lang/String;)", zero);
        displayTextMethods.put("javax/swing/JFrame#<init>(Ljava/lang/String;Ljava/awt/GraphicsConfiguration;)", one);
        displayTextMethods.put("javax/swing/JDialog#<init>(Ljava/awt/Dialog;Ljava/lang/String;)", zero);
        displayTextMethods.put("javax/swing/JDialog#<init>(Ljava/awt/Dialog;Ljava/lang/String;Z)", one);
        displayTextMethods.put("javax/swing/JDialog#<init>(Ljava/awt/Dialog;Ljava/lang/String;ZLjava/awt/GraphicsConfiguration;)", two);
        displayTextMethods.put("javax/swing/JDialog#<init>(Ljava/awt/Frame;Ljava/lang/String;)", zero);
        displayTextMethods.put("javax/swing/JDialog#<init>(Ljava/awt/Frame;Ljava/lang/String;Z)", one);
        displayTextMethods.put("javax/swing/JDialog#<init>(Ljava/awt/Frame;Ljava/lang/String;ZLjava/awt/GraphicsConfiguration;)", two);
        displayTextMethods.put("java/awt/Dialog#setTitle(Ljava/lang/String;)", zero);
        displayTextMethods.put("java/awt/Frame#setTitle(Ljava/lang/String;)", zero);
        displayTextMethods.put("javax/swing/JMenu#<init>(Ljava/lang/String;)", zero);
        displayTextMethods.put("javax/swing/JMenu#<init>(Ljava/lang/String;Z)", one);
        displayTextMethods.put("javax/swing/JMenuItem#<init>(Ljava/lang/String;)", zero);
        displayTextMethods.put("javax/swing/JMenuItem#<init>(Ljava/lang/String;Ljavax/swing/Icon;)", one);
        displayTextMethods.put("javax/swing/JMenuItem#<init>(Ljava/lang/String;I)", one);
    }
}

