/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

public class SloppyClassReflection
extends BytecodeScanningDetector {
    private final BugReporter bugReporter;
    private Set<String> refClasses;
    private State state;
    private String clsName;

    public SloppyClassReflection(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            this.refClasses = new HashSet<String>();
            this.refClasses.add(classContext.getJavaClass().getClassName());
            this.state = State.COLLECT;
            super.visitClassContext(classContext);
            this.state = State.SEEN_NOTHING;
            super.visitClassContext(classContext);
            Object var3_2 = null;
            this.refClasses = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.refClasses = null;
            throw throwable;
        }
    }

    public void visitMethod(Method obj) {
        if ("<clinit>".equals(obj.getName())) {
            return;
        }
        if (this.state == State.COLLECT) {
            LocalVariable[] lvs;
            Type[] argTypes;
            for (Type t : argTypes = obj.getArgumentTypes()) {
                this.addType(t);
            }
            Type resultType = obj.getReturnType();
            this.addType(resultType);
            LocalVariableTable lvt = obj.getLocalVariableTable();
            if (lvt != null && (lvs = lvt.getLocalVariableTable()) != null) {
                for (LocalVariable lv : lvs) {
                    if (lv == null) continue;
                    Type t = Type.getType((String)lv.getSignature());
                    this.addType(t);
                }
            }
        } else {
            this.state = State.SEEN_NOTHING;
        }
        super.visitMethod(obj);
    }

    public void visitField(Field obj) {
        if (this.state == State.COLLECT) {
            Type t = obj.getType();
            this.addType(t);
        }
    }

    public void sawOpcode(int seen) {
        switch (this.state) {
            case COLLECT: {
                Type[] argTypes;
                if (seen != 184 && seen != 182 && seen != 185 && seen != 183) break;
                this.refClasses.add(this.getClassConstantOperand());
                String signature = this.getSigConstantOperand();
                for (Type t : argTypes = Type.getArgumentTypes((String)signature)) {
                    this.addType(t);
                }
                Type resultType = Type.getReturnType((String)signature);
                this.addType(resultType);
                break;
            }
            case SEEN_NOTHING: {
                Constant c;
                if (seen != 18 && seen != 19 || !((c = this.getConstantRefOperand()) instanceof ConstantString)) break;
                this.clsName = ((ConstantString)c).getBytes(this.getConstantPool());
                this.state = State.SEEN_LDC;
                break;
            }
            case SEEN_LDC: {
                if (seen == 184 && "forName".equals(this.getNameConstantOperand()) && "java/lang/Class".equals(this.getClassConstantOperand()) && this.refClasses.contains(this.clsName)) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "SCR_SLOPPY_CLASS_REFLECTION", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
                this.state = State.SEEN_NOTHING;
            }
        }
    }

    private void addType(Type t) {
        String signature = t.getSignature();
        if (signature.charAt(0) == 'L') {
            this.refClasses.add(signature.substring(1, signature.length() - 1));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        COLLECT,
        SEEN_NOTHING,
        SEEN_LDC;

    }
}

