/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.SignatureUtils;
import com.mebigfatguy.fbcontrib.utils.TernaryPatcher;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.generic.Type;

@OpcodeStack.CustomUserValue
public class StutteredMethodArguments
extends BytecodeScanningDetector {
    private static Set<String> ignorableSignatures = new HashSet<String>();
    private final BugReporter bugReporter;
    private OpcodeStack stack;
    private String processedPackageName;
    private String processedMethodName;

    public StutteredMethodArguments(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            this.processedPackageName = classContext.getJavaClass().getPackageName();
            super.visitClassContext(classContext);
            Object var3_2 = null;
            this.stack = null;
            this.processedPackageName = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.stack = null;
            this.processedPackageName = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitCode(Code obj) {
        try {
            this.stack.resetForMethodEntry((DismantleBytecode)this);
            this.processedMethodName = this.getMethod().getName();
            super.visitCode(obj);
            Object var3_2 = null;
            this.processedMethodName = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.processedMethodName = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        String fieldSource = null;
        try {
            this.stack.precomputation((DismantleBytecode)this);
            switch (seen) {
                case 182: 
                case 183: 
                case 184: 
                case 185: {
                    Type[] parms;
                    String clsName = this.getClassConstantOperand();
                    int slashPos = clsName.lastIndexOf(47);
                    String packageName = slashPos >= 0 ? clsName.substring(0, slashPos) : "";
                    if (!SignatureUtils.similarPackages(this.processedPackageName, packageName, 2)) break;
                    String methodName = this.getNameConstantOperand();
                    String signature = this.getSigConstantOperand();
                    String methodInfo = clsName + ":" + methodName + signature;
                    if (!this.processedMethodName.equals(methodName) && !ignorableSignatures.contains(methodInfo) && (parms = Type.getArgumentTypes((String)signature)).length > 1 && this.stack.getStackDepth() > parms.length && this.duplicateArguments(this.stack, parms)) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, "SMA_STUTTERED_METHOD_ARGUMENTS", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    }
                    break;
                }
                case 178: 
                case 180: {
                    XField f;
                    if (this.stack.getStackDepth() <= 0) break;
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    int reg = item.getRegisterNumber();
                    fieldSource = reg >= 0 ? String.valueOf(reg) : ((f = item.getXField()) != null ? f.getClassName() + ':' + f.getName() : "");
                }
            }
            Object var11_13 = null;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            TernaryPatcher.pre(this.stack, seen);
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            TernaryPatcher.post(this.stack, seen);
            if (fieldSource != null && this.stack.getStackDepth() > 0) {
                OpcodeStack.Item item = this.stack.getStackItem(0);
                item.setUserValue((Object)fieldSource);
            }
            throw throwable;
        }
        TernaryPatcher.pre(this.stack, seen);
        this.stack.sawOpcode((DismantleBytecode)this, seen);
        TernaryPatcher.post(this.stack, seen);
        if (fieldSource != null && this.stack.getStackDepth() > 0) {
            OpcodeStack.Item item = this.stack.getStackItem(0);
            item.setUserValue((Object)fieldSource);
        }
    }

    private boolean duplicateArguments(OpcodeStack opStack, Type[] parms) {
        HashSet<String> args = new HashSet<String>();
        for (int i = 0; i < parms.length; ++i) {
            OpcodeStack.Item item = opStack.getStackItem(i);
            String signature = item.getSignature();
            if (!signature.startsWith("L") || signature.startsWith("Ljava/lang/") || item.getConstant() != null) continue;
            String arg = null;
            int reg = item.getRegisterNumber();
            if (reg >= 0) {
                arg = String.valueOf(reg);
            } else {
                XField f = item.getXField();
                if (f != null) {
                    String fieldSource = (String)item.getUserValue();
                    if (fieldSource == null) {
                        fieldSource = "";
                    }
                    arg = fieldSource + '|' + f.getClassName() + ':' + f.getName();
                }
            }
            if (arg == null) continue;
            if (args.contains(arg = arg + "--" + parms[i].getSignature())) {
                return true;
            }
            args.add(arg);
        }
        return false;
    }

    static {
        ignorableSignatures.add("java/util/Map:put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
    }
}

