/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.TernaryPatcher;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

@OpcodeStack.CustomUserValue
public class SuspiciousCloneAlgorithm
extends BytecodeScanningDetector {
    private static JavaClass cloneableClass;
    private static Map<String, Integer> changingMethods;
    private BugReporter bugReporter;
    private OpcodeStack stack;

    public SuspiciousCloneAlgorithm(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        if (cloneableClass == null) {
            return;
        }
        try {
            block5: {
                try {
                    JavaClass cls = classContext.getJavaClass();
                    if (!cls.implementationOf(cloneableClass)) break block5;
                    this.stack = new OpcodeStack();
                    super.visitClassContext(classContext);
                }
                catch (ClassNotFoundException cnfe) {
                    this.bugReporter.reportMissingClass(cnfe);
                    Object var4_5 = null;
                    this.stack = null;
                }
            }
            Object var4_4 = null;
            this.stack = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.stack = null;
            throw throwable;
        }
    }

    public void visitCode(Code obj) {
        Method m = this.getMethod();
        if (!m.isStatic() && "clone".equals(m.getName()) && "()Ljava/lang/Object;".equals(m.getSignature())) {
            super.visitCode(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        boolean srcField = false;
        try {
            this.stack.precomputation((DismantleBytecode)this);
            switch (seen) {
                case 42: {
                    srcField = true;
                    break;
                }
                case 89: {
                    if (this.stack.getStackDepth() <= 0) break;
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    if (item.getUserValue() != null) {
                        srcField = true;
                    }
                    break;
                }
                case 180: {
                    if (this.stack.getStackDepth() <= 0) break;
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    if (item.getRegisterNumber() == 0) {
                        srcField = true;
                    }
                    break;
                }
                case 181: {
                    if (this.stack.getStackDepth() < 2) break;
                    OpcodeStack.Item item = this.stack.getStackItem(1);
                    if (item.getRegisterNumber() == 0 || item.getUserValue() != null) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, "SCA_SUSPICIOUS_CLONE_ALGORITHM", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    }
                    break;
                }
                case 182: 
                case 185: {
                    String name;
                    Integer priority;
                    OpcodeStack.Item item;
                    String sig = this.getSigConstantOperand();
                    int numArgs = Type.getArgumentTypes((String)sig).length;
                    if (this.stack.getStackDepth() <= numArgs || (item = this.stack.getStackItem(numArgs)).getRegisterNumber() != 0 && item.getUserValue() == null || (priority = changingMethods.get(name = this.getNameConstantOperand())) == null) break;
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "SCA_SUSPICIOUS_CLONE_ALGORITHM", priority.intValue()).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
            }
            Object var9_11 = null;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            TernaryPatcher.pre(this.stack, seen);
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            TernaryPatcher.post(this.stack, seen);
            if (srcField && this.stack.getStackDepth() > 0) {
                OpcodeStack.Item item = this.stack.getStackItem(0);
                item.setUserValue((Object)Boolean.TRUE);
            }
            throw throwable;
        }
        TernaryPatcher.pre(this.stack, seen);
        this.stack.sawOpcode((DismantleBytecode)this, seen);
        TernaryPatcher.post(this.stack, seen);
        if (srcField && this.stack.getStackDepth() > 0) {
            OpcodeStack.Item item = this.stack.getStackItem(0);
            item.setUserValue((Object)Boolean.TRUE);
        }
    }

    static {
        try {
            cloneableClass = Repository.lookupClass((String)"java/lang/Cloneable");
            changingMethods = new HashMap<String, Integer>();
            changingMethods.put("add", 2);
            changingMethods.put("addAll", 2);
            changingMethods.put("put", 2);
            changingMethods.put("putAll", 2);
            changingMethods.put("insert", 3);
            changingMethods.put("set", 3);
        }
        catch (ClassNotFoundException cnfe) {
            cloneableClass = null;
        }
    }
}

