/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.bcel.classfile.Code;

public class SuspiciousNullGuard
extends BytecodeScanningDetector {
    private final BugReporter bugReporter;
    private OpcodeStack stack;
    private Map<Integer, NullGuard> nullGuards;

    public SuspiciousNullGuard(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            this.nullGuards = new HashMap<Integer, NullGuard>();
            super.visitClassContext(classContext);
            Object var3_2 = null;
            this.stack = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.stack = null;
            throw throwable;
        }
    }

    public void visitCode(Code obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        this.nullGuards.clear();
        super.visitCode(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        try {
            this.stack.precomputation((DismantleBytecode)this);
            Integer pc = this.getPC();
            this.nullGuards.remove(pc);
            switch (seen) {
                case 198: {
                    if (this.stack.getStackDepth() <= 0) break;
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    int reg = item.getRegisterNumber();
                    Integer target = this.getBranchTarget();
                    if (reg >= 0) {
                        this.nullGuards.put(target, new NullGuard(reg, (int)pc, item.getSignature()));
                        break;
                    }
                    XField xf = item.getXField();
                    if (xf != null) {
                        this.nullGuards.put(target, new NullGuard(xf, (int)pc, item.getSignature()));
                    }
                    break;
                }
                case 58: 
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    NullGuard guard;
                    if (this.stack.getStackDepth() <= 0) break;
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    if (!item.isNull() && (guard = this.findNullGuardWithRegister(RegisterUtils.getAStoreReg((DismantleBytecode)this, seen))) != null) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, "SNG_SUSPICIOUS_NULL_LOCAL_GUARD", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                        this.removeNullGuard(guard);
                    }
                    break;
                }
                case 25: 
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    NullGuard guard = this.findNullGuardWithRegister(RegisterUtils.getALoadReg((DismantleBytecode)this, seen));
                    if (guard != null) {
                        this.removeNullGuard(guard);
                    }
                    break;
                }
                case 181: {
                    NullGuard guard;
                    XField xf;
                    if (this.stack.getStackDepth() <= 1) break;
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    if (!item.isNull() && (xf = this.getXFieldOperand()) != null && (guard = this.findNullGuardWithField(xf)) != null) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, "SNG_SUSPICIOUS_NULL_FIELD_GUARD", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                        this.removeNullGuard(guard);
                    }
                    break;
                }
                case 180: {
                    NullGuard guard;
                    if (this.stack.getStackDepth() <= 0) break;
                    XField xf = this.getXFieldOperand();
                    if (xf != null && (guard = this.findNullGuardWithField(xf)) != null) {
                        this.removeNullGuard(guard);
                    }
                    break;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 199: 
                case 200: {
                    this.nullGuards.clear();
                }
            }
            Object var8_15 = null;
        }
        catch (Throwable throwable) {
            Object var8_16 = null;
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            throw throwable;
        }
        this.stack.sawOpcode((DismantleBytecode)this, seen);
    }

    private NullGuard findNullGuardWithRegister(int reg) {
        for (NullGuard guard : this.nullGuards.values()) {
            if (guard.getRegister() != reg) continue;
            return guard;
        }
        return null;
    }

    private NullGuard findNullGuardWithField(XField field) {
        for (NullGuard guard : this.nullGuards.values()) {
            if (!field.equals(guard.getField())) continue;
            return guard;
        }
        return null;
    }

    private void removeNullGuard(NullGuard guard) {
        Iterator<NullGuard> it = this.nullGuards.values().iterator();
        while (it.hasNext()) {
            NullGuard potentialNG = it.next();
            if (!potentialNG.equals(guard)) continue;
            it.remove();
            break;
        }
    }

    static class NullGuard {
        int register;
        XField field;
        int location;
        String signature;

        public NullGuard(int reg, int start, String guardSignature) {
            this.register = reg;
            this.field = null;
            this.location = start;
            this.signature = guardSignature;
        }

        public NullGuard(XField xf, int start, String guardSignature) {
            this.register = -1;
            this.field = xf;
            this.location = start;
            this.signature = guardSignature;
        }

        public int getRegister() {
            return this.register;
        }

        public XField getField() {
            return this.field;
        }

        public int getLocation() {
            return this.location;
        }

        public String getSignature() {
            return this.signature;
        }
    }
}

