/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import com.mebigfatguy.fbcontrib.utils.SignatureUtils;
import com.mebigfatguy.fbcontrib.utils.TernaryPatcher;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.BitSet;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.generic.Type;

@OpcodeStack.CustomUserValue
public class SuspiciousUninitializedArray
extends BytecodeScanningDetector {
    private static final String UNINIT_ARRAY = "Unitialized Array";
    private final BugReporter bugReporter;
    private OpcodeStack stack;
    private String returnArraySig;
    private BitSet uninitializedRegs;

    public SuspiciousUninitializedArray(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            this.uninitializedRegs = new BitSet();
            super.visitClassContext(classContext);
            Object var3_2 = null;
            this.stack = null;
            this.uninitializedRegs = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.stack = null;
            this.uninitializedRegs = null;
            throw throwable;
        }
    }

    public void visitCode(Code obj) {
        String sig = this.getMethod().getSignature();
        int sigPos = sig.indexOf(")[");
        if (sigPos >= 0) {
            this.stack.resetForMethodEntry((DismantleBytecode)this);
            this.returnArraySig = sig.substring(sigPos + 1);
            this.uninitializedRegs.clear();
            super.visitCode(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        Object userValue = null;
        try {
            this.stack.precomputation((DismantleBytecode)this);
            switch (seen) {
                case 188: {
                    if (this.isTOS0()) break;
                    int typeCode = this.getIntConstant();
                    String sig = "[" + SignatureUtils.getTypeCodeSignature(typeCode);
                    if (this.returnArraySig.equals(sig)) {
                        userValue = UNINIT_ARRAY;
                    }
                    break;
                }
                case 189: {
                    if (this.isTOS0()) break;
                    String sig = "[L" + this.getClassConstantOperand() + ";";
                    if (this.returnArraySig.equals(sig)) {
                        userValue = UNINIT_ARRAY;
                    }
                    break;
                }
                case 197: {
                    if (!this.returnArraySig.equals(this.getClassConstantOperand())) break;
                    userValue = UNINIT_ARRAY;
                    break;
                }
                case 182: 
                case 183: 
                case 184: 
                case 185: {
                    String methodSig = this.getSigConstantOperand();
                    Type[] types = Type.getArgumentTypes((String)methodSig);
                    for (int t = 0; t < types.length; ++t) {
                        OpcodeStack.Item item;
                        Type type = types[t];
                        String parmSig = type.getSignature();
                        if (!this.returnArraySig.equals(parmSig) && !"Ljava/lang/Object;".equals(parmSig) && !"[Ljava/lang/Object;".equals(parmSig)) continue;
                        int parmIndex = types.length - t - 1;
                        if (this.stack.getStackDepth() <= parmIndex || (item = this.stack.getStackItem(parmIndex)).getUserValue() == null) continue;
                        userValue = item.getUserValue();
                        int reg = userValue instanceof Integer ? ((Integer)userValue).intValue() : item.getRegisterNumber();
                        item.setUserValue(null);
                        if (reg >= 0) {
                            this.uninitializedRegs.clear(reg);
                        }
                        userValue = null;
                    }
                    break;
                }
                case 50: {
                    if (this.stack.getStackDepth() < 2) break;
                    OpcodeStack.Item item = this.stack.getStackItem(1);
                    if (UNINIT_ARRAY.equals(item.getUserValue())) {
                        userValue = item.getRegisterNumber();
                    }
                    break;
                }
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: {
                    if (this.stack.getStackDepth() >= 3) {
                        OpcodeStack.Item item = this.stack.getStackItem(2);
                        userValue = item.getUserValue();
                        int reg = userValue instanceof Integer ? ((Integer)userValue).intValue() : item.getRegisterNumber();
                        item.setUserValue(null);
                        if (reg >= 0) {
                            this.uninitializedRegs.clear(reg);
                        }
                        userValue = null;
                        break;
                    }
                    this.uninitializedRegs.clear();
                    break;
                }
                case 58: 
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    int reg = RegisterUtils.getAStoreReg((DismantleBytecode)this, seen);
                    if (this.stack.getStackDepth() > 0) {
                        OpcodeStack.Item item = this.stack.getStackItem(0);
                        this.uninitializedRegs.set(reg, UNINIT_ARRAY.equals(item.getUserValue()));
                        break;
                    }
                    this.uninitializedRegs.clear(reg);
                    break;
                }
                case 25: 
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    int reg = RegisterUtils.getALoadReg((DismantleBytecode)this, seen);
                    if (this.uninitializedRegs.get(reg)) {
                        userValue = UNINIT_ARRAY;
                    }
                    break;
                }
                case 181: {
                    if (this.stack.getStackDepth() <= 0) break;
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    item.setUserValue(null);
                    int reg = item.getRegisterNumber();
                    if (reg >= 0) {
                        this.uninitializedRegs.clear(reg);
                    }
                    break;
                }
                case 176: {
                    OpcodeStack.Item item;
                    if (this.stack.getStackDepth() <= 0 || !UNINIT_ARRAY.equals((item = this.stack.getStackItem(0)).getUserValue())) break;
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "SUA_SUSPICIOUS_UNINITIALIZED_ARRAY", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
            }
            Object var12_23 = null;
        }
        catch (Throwable throwable) {
            Object var12_24 = null;
            TernaryPatcher.pre(this.stack, seen);
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            TernaryPatcher.post(this.stack, seen);
            if (this.stack.getStackDepth() > 0) {
                OpcodeStack.Item item = this.stack.getStackItem(0);
                item.setUserValue(userValue);
            }
            throw throwable;
        }
        TernaryPatcher.pre(this.stack, seen);
        this.stack.sawOpcode((DismantleBytecode)this, seen);
        TernaryPatcher.post(this.stack, seen);
        if (this.stack.getStackDepth() > 0) {
            OpcodeStack.Item item = this.stack.getStackItem(0);
            item.setUserValue(userValue);
        }
    }

    private boolean isTOS0() {
        if (this.stack.getStackDepth() > 0) {
            OpcodeStack.Item item = this.stack.getStackItem(0);
            return item.mustBeZero();
        }
        return false;
    }
}

