/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantNameAndType;

public class SyncCollectionIterators
extends BytecodeScanningDetector {
    private final BugReporter bugReporter;
    private static Set<String> synchCollectionNames = new HashSet<String>();
    private static Set<String> mapToSetMethods;
    private State state;
    private Set<String> memberCollections;
    private Set<Integer> localCollections;
    private List<Object> monitorObjects;
    private OpcodeStack stack;
    private Object collectionInfo = null;

    public SyncCollectionIterators(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            this.memberCollections = new HashSet<String>();
            this.localCollections = new HashSet<Integer>();
            this.monitorObjects = new ArrayList<Object>();
            this.stack = new OpcodeStack();
            super.visitClassContext(classContext);
            Object var3_2 = null;
            this.memberCollections = null;
            this.localCollections = null;
            this.monitorObjects = null;
            this.stack = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.memberCollections = null;
            this.localCollections = null;
            this.monitorObjects = null;
            this.stack = null;
            throw throwable;
        }
    }

    public void visitCode(Code obj) {
        if (obj.getCode() != null) {
            this.state = State.SEEN_NOTHING;
            this.localCollections.clear();
            this.monitorObjects.clear();
            this.stack.resetForMethodEntry((DismantleBytecode)this);
            super.visitCode(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        try {
            this.stack.precomputation((DismantleBytecode)this);
            switch (this.state) {
                case SEEN_NOTHING: {
                    if (seen == 184 && "java/util/Collections".equals(this.getClassConstantOperand())) {
                        if (!synchCollectionNames.contains(this.getNameConstantOperand())) break;
                        this.state = State.SEEN_SYNC;
                        break;
                    }
                    if (seen == 25) {
                        int reg = this.getRegisterOperand();
                        if (!this.localCollections.contains(reg)) break;
                        this.collectionInfo = reg;
                        this.state = State.SEEN_LOAD;
                        break;
                    }
                    if (seen >= 42 && seen <= 45) {
                        int reg = seen - 42;
                        if (!this.localCollections.contains(reg)) break;
                        this.collectionInfo = reg;
                        this.state = State.SEEN_LOAD;
                        break;
                    }
                    if (seen != 180) break;
                    ConstantFieldref ref = (ConstantFieldref)this.getConstantRefOperand();
                    ConstantNameAndType nandt = (ConstantNameAndType)this.getConstantPool().getConstant(ref.getNameAndTypeIndex());
                    String fieldName = nandt.getName(this.getConstantPool());
                    if (!this.memberCollections.contains(fieldName)) break;
                    this.collectionInfo = fieldName;
                    this.state = State.SEEN_LOAD;
                    break;
                }
                case SEEN_SYNC: {
                    ConstantNameAndType nandt;
                    if (seen == 58) {
                        int reg = this.getRegisterOperand();
                        this.localCollections.add(reg);
                    } else if (seen >= 75 && seen <= 78) {
                        int reg = seen - 75;
                        this.localCollections.add(reg);
                    } else if (seen == 181) {
                        ConstantFieldref ref = (ConstantFieldref)this.getConstantRefOperand();
                        nandt = (ConstantNameAndType)this.getConstantPool().getConstant(ref.getNameAndTypeIndex());
                        this.memberCollections.add(nandt.getName(this.getConstantPool()));
                    }
                    this.state = State.SEEN_NOTHING;
                    break;
                }
                case SEEN_LOAD: {
                    if (seen == 185) {
                        String calledClass = this.getClassConstantOperand();
                        if ("java/lang/Map".equals(calledClass)) {
                            if (mapToSetMethods.contains(this.getNameConstantOperand())) {
                                this.state = State.SEEN_LOAD;
                                break;
                            }
                            this.state = State.SEEN_NOTHING;
                            break;
                        }
                        if (calledClass.startsWith("java/util/")) {
                            if (!"iterator".equals(this.getNameConstantOperand())) break;
                            if (this.monitorObjects.isEmpty()) {
                                this.bugReporter.reportBug(new BugInstance((Detector)this, "SCI_SYNCHRONIZED_COLLECTION_ITERATORS", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                                this.state = State.SEEN_NOTHING;
                                break;
                            }
                            Object syncObj = this.monitorObjects.get(this.monitorObjects.size() - 1);
                            if (!this.syncIsMap(syncObj, this.collectionInfo)) {
                                this.bugReporter.reportBug(new BugInstance((Detector)this, "SCI_SYNCHRONIZED_COLLECTION_ITERATORS", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                            }
                            this.state = State.SEEN_NOTHING;
                            break;
                        }
                        this.state = State.SEEN_NOTHING;
                        break;
                    }
                    this.state = State.SEEN_NOTHING;
                }
            }
            if (seen == 194) {
                if (this.stack.getStackDepth() > 0) {
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    int reg = item.getRegisterNumber();
                    if (reg >= 0) {
                        this.monitorObjects.add(reg);
                    } else {
                        XField field = item.getXField();
                        if (field != null) {
                            this.monitorObjects.add(field.getName());
                        }
                    }
                }
            } else if (seen == 195 && this.monitorObjects.size() > 0) {
                this.monitorObjects.remove(this.monitorObjects.size() - 1);
            }
            Object var6_13 = null;
        }
        catch (Throwable throwable) {
            Object var6_14 = null;
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            throw throwable;
        }
        this.stack.sawOpcode((DismantleBytecode)this, seen);
    }

    private boolean syncIsMap(Object syncObject, Object colInfo) {
        if (syncObject != null && colInfo != null && syncObject.getClass().equals(colInfo.getClass())) {
            return syncObject.equals(colInfo);
        }
        return true;
    }

    static {
        synchCollectionNames.add("synchronizedSet");
        synchCollectionNames.add("synchronizedMap");
        synchCollectionNames.add("synchronizedList");
        synchCollectionNames.add("synchronizedSortedSet");
        synchCollectionNames.add("synchronizedSortedMap");
        mapToSetMethods = new HashSet<String>();
        mapToSetMethods.add("keySet");
        mapToSetMethods.add("entrySet");
        mapToSetMethods.add("values");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        SEEN_NOTHING,
        SEEN_SYNC,
        SEEN_LOAD;

    }
}

