/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import com.mebigfatguy.fbcontrib.utils.TernaryPatcher;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.generic.Type;

@OpcodeStack.CustomUserValue
public class WriteOnlyCollection
extends BytecodeScanningDetector {
    private static Set<String> collectionClasses = new HashSet<String>();
    private static Set<String> nonInformationalMethods;
    private final BugReporter bugReporter;
    private OpcodeStack stack;
    private String clsSignature;
    private Map<Integer, Integer> localWOCollections;
    private Map<String, String> fieldWOCollections;

    public WriteOnlyCollection(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            this.clsSignature = "L" + classContext.getJavaClass().getClassName().replaceAll("\\.", "/") + ";";
            this.stack = new OpcodeStack();
            this.localWOCollections = new HashMap<Integer, Integer>();
            this.fieldWOCollections = new HashMap<String, String>();
            super.visitClassContext(classContext);
            if (this.fieldWOCollections.size() > 0) {
                String clsName = classContext.getJavaClass().getClassName();
                for (Map.Entry<String, String> entry : this.fieldWOCollections.entrySet()) {
                    String fieldName = entry.getKey();
                    String signature = entry.getValue();
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "WOC_WRITE_ONLY_COLLECTION_FIELD", 2).addClass((PreorderVisitor)this).addField(clsName, fieldName, signature, false));
                }
            }
            Object var8_7 = null;
            this.stack = null;
            this.localWOCollections = null;
            this.fieldWOCollections = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.stack = null;
            this.localWOCollections = null;
            this.fieldWOCollections = null;
            throw throwable;
        }
    }

    public void visitField(Field obj) {
        String type;
        String sig;
        if (obj.isPrivate() && !obj.isSynthetic() && (sig = obj.getSignature()).startsWith("L") && collectionClasses.contains(type = sig.substring(1, sig.length() - 1).replace('/', '.'))) {
            this.fieldWOCollections.put(obj.getName(), obj.getSignature());
        }
    }

    public void visitCode(Code obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        this.localWOCollections.clear();
        super.visitCode(obj);
        for (Integer pc : this.localWOCollections.values()) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "WOC_WRITE_ONLY_COLLECTION_LOCAL", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this, pc.intValue()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        Object userObject = null;
        this.stack.precomputation((DismantleBytecode)this);
        try {
            switch (seen) {
                case 183: {
                    String clsName;
                    String methodName = this.getNameConstantOperand();
                    if ("<init>".equals(methodName) && collectionClasses.contains(clsName = this.getClassConstantOperand().replace('/', '.'))) {
                        userObject = Boolean.TRUE;
                    }
                    this.processMethodParms();
                    break;
                }
                case 182: 
                case 185: {
                    OpcodeStack.Item item;
                    Object uo;
                    String sig = this.getSigConstantOperand();
                    int numParms = Type.getArgumentTypes((String)sig).length;
                    if (this.stack.getStackDepth() > numParms && (uo = (item = this.stack.getStackItem(numParms)).getUserValue()) != null) {
                        Type t;
                        String name = this.getNameConstantOperand();
                        if (!nonInformationalMethods.contains(name)) {
                            this.clearUserValue(item);
                        } else if (!"clone".equals(name) && (t = Type.getReturnType((String)sig)) != Type.VOID && !this.nextOpIsPop()) {
                            this.clearUserValue(item);
                        }
                    }
                    this.processMethodParms();
                    break;
                }
                case 184: {
                    this.processMethodParms();
                    break;
                }
                case 176: {
                    if (this.stack.getStackDepth() <= 0) break;
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    this.clearUserValue(item);
                    break;
                }
                case 58: 
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    if (this.stack.getStackDepth() <= 0) break;
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    Object uo = item.getUserValue();
                    if (uo != null) {
                        if (uo instanceof Boolean) {
                            int reg = RegisterUtils.getAStoreReg((DismantleBytecode)this, seen);
                            this.localWOCollections.put(reg, this.getPC());
                            break;
                        }
                        this.clearUserValue(item);
                    }
                    break;
                }
                case 25: 
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    int reg = RegisterUtils.getALoadReg((DismantleBytecode)this, seen);
                    if (!this.localWOCollections.containsKey(reg)) break;
                    userObject = reg;
                    break;
                }
                case 83: {
                    if (this.stack.getStackDepth() < 3) break;
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    this.clearUserValue(item);
                    break;
                }
                case 181: {
                    if (this.stack.getStackDepth() <= 1) break;
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    Object uo = item.getUserValue();
                    if (!(uo instanceof Boolean)) {
                        this.clearUserValue(item);
                    }
                    break;
                }
                case 180: {
                    String fieldName;
                    XField field;
                    if (this.stack.getStackDepth() <= 0) break;
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    String sig = item.getSignature();
                    if ((item.getRegisterNumber() == 0 || sig != null && sig.equals(this.clsSignature)) && (field = this.getXFieldOperand()) != null && this.fieldWOCollections.containsKey(fieldName = field.getName())) {
                        userObject = fieldName;
                    }
                    break;
                }
                case 179: {
                    if (this.stack.getStackDepth() <= 0) break;
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    Object uo = item.getUserValue();
                    if (!(uo instanceof Boolean)) {
                        this.clearUserValue(item);
                    }
                    break;
                }
                case 178: {
                    XField field = this.getXFieldOperand();
                    if (field == null) break;
                    String fieldName = field.getName();
                    if (this.fieldWOCollections.containsKey(fieldName)) {
                        userObject = fieldName;
                    }
                    break;
                }
                case 167: 
                case 198: 
                case 199: {
                    OpcodeStack.Item item;
                    Object uo;
                    if (this.stack.getStackDepth() <= 0 || (uo = (item = this.stack.getStackItem(0)).getUserValue()) instanceof Boolean) break;
                    this.clearUserValue(item);
                }
            }
            Object var11_29 = null;
        }
        catch (Throwable throwable) {
            Object var11_30 = null;
            TernaryPatcher.pre(this.stack, seen);
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            TernaryPatcher.post(this.stack, seen);
            if (userObject != null && this.stack.getStackDepth() > 0) {
                OpcodeStack.Item item = this.stack.getStackItem(0);
                item.setUserValue(userObject);
            }
            throw throwable;
        }
        TernaryPatcher.pre(this.stack, seen);
        this.stack.sawOpcode((DismantleBytecode)this, seen);
        TernaryPatcher.post(this.stack, seen);
        if (userObject != null && this.stack.getStackDepth() > 0) {
            OpcodeStack.Item item = this.stack.getStackItem(0);
            item.setUserValue(userObject);
        }
    }

    private boolean nextOpIsPop() {
        int nextPC = this.getNextPC();
        return this.getCode().getCode()[nextPC] == 87;
    }

    private void clearUserValue(OpcodeStack.Item item) {
        Object uo = item.getUserValue();
        if (uo instanceof Integer) {
            this.localWOCollections.remove(uo);
        } else if (uo instanceof String) {
            this.fieldWOCollections.remove(uo);
        }
        item.setUserValue(null);
    }

    private void processMethodParms() {
        String sig = this.getSigConstantOperand();
        int numParms = Type.getArgumentTypes((String)sig).length;
        if (this.stack.getStackDepth() >= numParms) {
            for (int i = 0; i < numParms; ++i) {
                this.clearUserValue(this.stack.getStackItem(i));
            }
        }
    }

    static {
        collectionClasses.add(Set.class.getName());
        collectionClasses.add(Map.class.getName());
        collectionClasses.add(List.class.getName());
        collectionClasses.add(SortedSet.class.getName());
        collectionClasses.add(SortedMap.class.getName());
        collectionClasses.add(Collection.class.getName());
        collectionClasses.add(EnumSet.class.getName());
        collectionClasses.add(EnumMap.class.getName());
        collectionClasses.add(HashSet.class.getName());
        collectionClasses.add(IdentityHashMap.class.getName());
        collectionClasses.add(TreeSet.class.getName());
        collectionClasses.add(LinkedHashSet.class.getName());
        collectionClasses.add(HashMap.class.getName());
        collectionClasses.add(TreeMap.class.getName());
        collectionClasses.add(Hashtable.class.getName());
        collectionClasses.add(LinkedHashMap.class.getName());
        collectionClasses.add(Vector.class.getName());
        collectionClasses.add(ArrayList.class.getName());
        collectionClasses.add(LinkedList.class.getName());
        collectionClasses.add("java.util.Deque");
        collectionClasses.add("java.util.Queue");
        collectionClasses.add("java.util.ArrayDeque");
        collectionClasses.add("java.util.LinkedBlockingDeque");
        collectionClasses.add("java.util.NavigableMap");
        collectionClasses.add("java.util.concurrent.ConcurrentMap");
        collectionClasses.add("java.util.concurrent.ConcurrentNavigableMap");
        collectionClasses.add("java.util.concurrent.ConcurrentSkipListMap");
        collectionClasses.add("java.util.concurrent.ConcurrentHashMap");
        collectionClasses.add("java.util.concurrent.ConcurrentSkipListSet");
        collectionClasses.add("java.util.concurrent.CopyOnWriteArrayList");
        nonInformationalMethods = new HashSet<String>();
        nonInformationalMethods.add("add");
        nonInformationalMethods.add("addAll");
        nonInformationalMethods.add("addElement");
        nonInformationalMethods.add("addFirst");
        nonInformationalMethods.add("addLast");
        nonInformationalMethods.add("clear");
        nonInformationalMethods.add("clone");
        nonInformationalMethods.add("ensureCapacity");
        nonInformationalMethods.add("insertElementAt");
        nonInformationalMethods.add("push");
        nonInformationalMethods.add("put");
        nonInformationalMethods.add("putAll");
        nonInformationalMethods.add("remove");
        nonInformationalMethods.add("removeAll");
        nonInformationalMethods.add("removeElement");
        nonInformationalMethods.add("removeElementAt");
        nonInformationalMethods.add("removeRange");
        nonInformationalMethods.add("set");
        nonInformationalMethods.add("setElementAt");
        nonInformationalMethods.add("setSize");
        nonInformationalMethods.add("trimToSize");
    }
}

