/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.utils;

import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.LineNumber;
import org.apache.bcel.classfile.LineNumberTable;

public class AttributesUtils {
    private AttributesUtils() {
    }

    public static boolean isValidLineNumber(Code obj, int pc) {
        LineNumberTable lnt = obj.getLineNumberTable();
        if (lnt == null) {
            return true;
        }
        LineNumber[] lineNumbers = lnt.getLineNumberTable();
        if (lineNumbers == null) {
            return true;
        }
        int lo = 0;
        int hi = lineNumbers.length - 1;
        int mid = 0;
        int linePC = 0;
        while (lo <= hi && (linePC = lineNumbers[mid = (lo + hi) / 2].getStartPC()) != pc) {
            if (linePC < pc) {
                lo = mid + 1;
                continue;
            }
            hi = mid - 1;
        }
        int lineNo = lineNumbers[mid].getLineNumber();
        for (int i = 0; i < lineNumbers.length; ++i) {
            if (mid == i || lineNumbers[i].getLineNumber() != lineNo) continue;
            return false;
        }
        return true;
    }
}

