package com.netapp.oci.profiler;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;

import org.slf4j.LoggerFactory;

/**
 * Base implementation to provide common implementation of <code>ProfileService</code> methods.
 *
 * @author Shan Ponnusamy
 */
public abstract class BaseProfilerService implements ProfilerService {

    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(BaseProfilerService.class);

    private ProfilerDataStore dataStore;

    @Override
    public void log(Map<String, Object> data) throws ProfilerServiceException {
        try {
            dataStore.store(data);
        } catch (IOException e) {
            throw new ProfilerServiceException(e);
        }
    }

    @Override
    public void log(String item, Object value) throws ProfilerServiceException {
        try {
            dataStore.store(item, value);
        } catch (IOException e) {
            throw new ProfilerServiceException(e);
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @SuppressWarnings("unused")
    public ProfilerDataStore getDataStore() throws ProfilerServiceException {
        return dataStore;
    }

    public void setDataStore(ProfilerDataStore dataStore) {
        this.dataStore = dataStore;
    }

    @Override
    public void stop() {
        try {
            dataStore.close();
        } catch (Exception e) {
            logger.error("",e);
        }
    }

    /**
     * Get the next suitable profiling start time.
     *
     * Right now, it provides the next minute as the suitable profiling start time.
     *
     * @return next suitable profiling start time
     */
    protected Date getProfilingStartTime() {
        Date current = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(current);
        cal.add(Calendar.MINUTE, 1);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);
        return new Date(cal.getTimeInMillis());
    }
}
