/*
 * Copyright (c) 2012 NetApp
 * All rights reserved
 */

package com.netapp.oci.profiler;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

/**
 * @author Al Velella
 *         Date: 12/19/12
 *         Time: 4:10 PM
 */
public class DiskPartitionSizeProfiler implements Profiler {
    private String profileItemName;
    private String pathname;

    public DiskPartitionSizeProfiler(String profileItemName, String pathname) {
        this.profileItemName = profileItemName;
        this.pathname = pathname;
    }

    @Override
    public Map<String, Object> sample() {
        Map<String, Object> profileData = new HashMap<String, Object>();
        File partition = new File(pathname);
        profileData.put(profileItemName, partition.getTotalSpace() - partition.getFreeSpace());
        return profileData;
    }
}
