package com.netapp.oci.profiler;

import org.slf4j.Logger;

/**
 * Factory object to get <code>ProfilerService</code>
 *
 * @author Shan Ponnusamy
 */
public class ProfilerServiceFactory {

    private static final ProfilerService instance;
    private static final org.slf4j.Logger logger;

    /**
     * Try to load the class specified by the system property.  If the system property does not exist or if unable to
     * load the class, default to "no op" profiler service.
     */
    static {
        String className = System.getProperty("profiler.class");
        logger =org.slf4j.LoggerFactory.getLogger(ProfilerServiceFactory.class);
        ProfilerService profilerService;
        if (className != null) {
            try {
                profilerService = (ProfilerService) Class.forName(className).newInstance();
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
                profilerService = new NoOpProfilerService();
            }
        } else {
            profilerService = new NoOpProfilerService();
        }
        instance = profilerService;
    }

    private ProfilerServiceFactory() {}  // to prevent instantiation.

    public static ProfilerService getInstance() {
        return instance;
    }
}
