package com.netapp.oci.profiler;

import org.slf4j.Logger;

import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;

/**
 * When the timer goes off, this task gets profile data from each of the given <code>Profiler</code>s and submits that
 * data to the given <code>ProfilerService</code>
 *
 * @author Shan Ponnusamy
 */
public class ProfilerTimerTask extends TimerTask {

    private static final Logger log =org.slf4j.LoggerFactory.getLogger(ProfilerTimerTask.class);

    private Profiler[] profilers;
    private ProfilerService profilerService;

    public ProfilerTimerTask(ProfilerService profilerService, Profiler[] profilers) {
        this.profilerService = profilerService;
        this.profilers = profilers;
    }

    @Override
    public void run() {
        try {
            Map<String, Object> profileData = new HashMap<String, Object>();
            profileData.put(ProfilerService.TIME, System.currentTimeMillis());
            for (Profiler profiler : profilers) {
                profileData.putAll(profiler.sample());
            }
             profilerService.log(profileData);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }
}
