
package com.netapp.collectors.vmware;

import com.netapp.collectors.vmware.exceptions.InvalidPropertyException;
import com.netapp.collectors.vmware.logger.LogsManager;
import com.netapp.collectors.vmware.util.ContextUtil;
import com.netapp.collectors.vmware.util.SpecBuilderUtil;
//import com.onaro.sanscreen.acquisition.framework.mgmt.LogsManager;
import com.vmware.vim25.*;
import org.slf4j.Logger;
import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * Helper class to retrieve data from vim25 api.
 *
 * @author bsachin
 */
public class VMWare25Dao implements IVMWare25Dao {
    private static final Logger logger = LogsManager.getLogger(VMWare25Dao.class);

    /**
     * The method basically returns two maps identified by the constants in VMWareConsts. This is used for fetching the counter data and understanding the counter data
     * {@inheritDoc}
     */
    public Map<String, Map<?, ?>> retrieveAvailablePerfMetricMaps(IVMWareContext context) {
        Map<String, Map<?, ?>> availablePerMetricMap = new HashMap<>();
        Map<String, Integer> metricsCounterToIdMap = new HashMap<>();
        Map<Integer, PerfCounterInfo> metricsIdToCounterInfoMap = new HashMap<Integer, PerfCounterInfo>();
        ManagedObjectReference perfManager = (ManagedObjectReference) context.getPerformanceManager();
        List<PropertySpec> perfPropSpec = SpecBuilderUtil.buildPerfCounterSpec(perfManager);
        RetrieveResult perfResult = retrieveManagedObjectsAndProperties(perfManager, perfPropSpec, false, context);
        List<ObjectContent> objectContents = perfResult.getObjects();
        if(CollectionUtils.isNotEmpty(objectContents) && objectContents.size() ==1) {
            ArrayOfPerfCounterInfo perfCounterInfoArray = (ArrayOfPerfCounterInfo) objectContents.get(0).getPropSet().get(0).getVal();
            List<PerfCounterInfo> perfCounterInfoList = perfCounterInfoArray.getPerfCounterInfo();
            for (int i = 0; i < perfCounterInfoList.size(); i++) {
                String key = perfCounterInfoList.get(i).getGroupInfo().getKey() +
                        "." + perfCounterInfoList.get(i).getNameInfo().getKey() +
                        "." + perfCounterInfoList.get(i).getRollupType().value();
                Integer value = new Integer(perfCounterInfoList.get(i).getKey());
                metricsCounterToIdMap.put(key, value);
                metricsIdToCounterInfoMap.put(value, perfCounterInfoList.get(i));
                logger.debug("Available perf counters: " + key + " - " + metricsIdToCounterInfoMap.get(value));
            }
            availablePerMetricMap.put(VMWareConsts.METRICS_COUNTER_MAP, metricsCounterToIdMap);
            availablePerMetricMap.put(VMWareConsts.COUNTER_INFO_MAP, metricsIdToCounterInfoMap);
        } else {
           logger.error("Perf counter details are not available from vCenter {}", context.getVcURL()); //TODO get the vcenter details here and log it
        }
        return availablePerMetricMap;
    }

    public RetrieveResult retrieveManagedObjectsAndProperties(ManagedObjectReference managedObjectReference, List<PropertySpec> propertySpec, boolean b, IVMWareContext context) {
        return retrieveManagedObjectsAndProperties(managedObjectReference, propertySpec, SpecBuilderUtil.buildFullTraversal(), false, context, null, null );
    }


    /**
     * Method to retrieve properties from VMWare Vcenter, it just takes teh root folder and propertyspec and traversal spec
     * @param mor
     * @param pSpec
     * @param tSpec
     * @param skipRoot
     * @param context
     * @param maxRecords
     * @param nextToken
     * @return
     */
    public static RetrieveResult retrieveManagedObjectsAndProperties(ManagedObjectReference mor, List<PropertySpec> pSpec, List<SelectionSpec> tSpec, boolean skipRoot, IVMWareContext context, Integer maxRecords, String nextToken) {
        List<ObjectSpec> obSpecList = new ArrayList<>();
        ObjectSpec objectSpec = new ObjectSpec();
        objectSpec.setObj(mor);
        objectSpec.setSkip(skipRoot);
        objectSpec.getSelectSet().addAll(tSpec);
        obSpecList.add(objectSpec);
        return retrieveManagedObjectsAndProperties(obSpecList, pSpec, skipRoot, context, maxRecords, nextToken);

    }
    private static RetrieveResult retrieveManagedObjectsAndProperties(List<ObjectSpec> obSpec,
                                                                      List<PropertySpec> pSpec, boolean skipRoot, IVMWareContext context, Integer maxRecords, String nextToken) {
        PropertyFilterSpec fSpec = new PropertyFilterSpec();
        fSpec.getObjectSet().addAll(obSpec);
        fSpec.getPropSet().addAll(pSpec);
        List<PropertyFilterSpec> fSpecList = new ArrayList<PropertyFilterSpec>();
        fSpecList.add(fSpec);
        RetrieveOptions retrieveOptions = new RetrieveOptions();
        if (maxRecords != null) {
            retrieveOptions.setMaxObjects(maxRecords);
        }
        try {
            if (nextToken == null) {
                return ContextUtil.getVimPortService(context).retrievePropertiesEx(
                        (ManagedObjectReference) context.getPropertyCollector(), fSpecList, retrieveOptions);
            } else {
                return ContextUtil.getVimPortService(context).continueRetrievePropertiesEx((ManagedObjectReference) context.getPropertyCollector(), nextToken);
            }

        /* TODO : Revisit these exception handling} catch (RemoteException e) {
            if ((e.getMessage() != null) && (e.getMessage().contains("(0)null"))) {
                // This is a known issue with axis, 'caused by: (0)null' occurs when a network error occurs in
                // the axis code. The error message description is 'null' because the exception didn't assign a message
                // to it.
                throw new DeviceCommException(CommunicationStateReason.CONNECTION_REFUSED, e, MSG_NETWORK_ERROR);
            } else if (e.getCause() instanceof SocketException) {
                throw new DeviceCommException(CommunicationStateReason.CONNECTION_REFUSED, e, e.getCause().getMessage());
            } else if (e.getCause() instanceof SocketTimeoutException) {
                throw new DeviceCommException(CommunicationStateReason.TIMEOUT, e, e.getCause().getMessage());
            } else {
                String exceptionMessage = e.getCause().getMessage();
                if(exceptionMessage != null && exceptionMessage.contains(OBJECT_NOT_CREATED_ERROR)){
                    // there was a problem querying the vmware device for a given object because it either no longer exists or is not done being created.
                    throw new VMWareServiceException(MSG_OBJECT_DELETED_OR_NOT_FULLY_CREATED, e);
                }else{
                    String msg = MessageFormat.format(MSG_ERROR_RETRIEVING_MANAGED_OBJECTS_PROPS,e.getMessage());
                    throw new RuntimeException(msg,e);
                }
            }*/
        } catch (InvalidPropertyFaultMsg invalidPropertyFaultMsg) {
            throw new InvalidPropertyException(invalidPropertyFaultMsg.getMessage());
        } catch (RuntimeFaultFaultMsg runtimeFaultFaultMsg) {
            throw new RuntimeException(runtimeFaultFaultMsg.getMessage());
        }
    }
}
