/*
 * Copyright (c) 2008 Akorri Networks, Inc. All Rights Reserved. This software is provided
 * under license and is not sold by Akorri Networks. This software may be used only in accordance
 * with the terms of an express written license agreement with Akorri Networks, and cannot be used,
 * copied, modified, or in any way distributed without the express permission of Akorri Networks.
 *
 */

package com.netapp.collectors.vmware;

import java.util.LinkedHashMap;

/**
 * Collection domain object for VMWare Clusters.
 * 
 * @author slaplante
 */
public class VMWareCluster extends VMWareComputeResource{



    /** true if drs is enabled. */
    private boolean drsEnabled = false;
    
    private String virtualCenterVersion = ""; 
    
    /**
     * Constructor.
     * 
     * @param managedObject managed object of this cluster
     */
    public VMWareCluster(Object managedObject){
        super(managedObject);
    }
    
    /**
     * Sets if drs is enabled for this cluster.
     * 
     * @return drsEnabled true if drs is enabled for this cluster
     */
    public boolean isDrsEnabled() {
        return drsEnabled;
    }

    /**
     * Gets if drs is enabled for this cluster.
     * 
     * @param drsEnabled true if drs is enabled for this cluster
     */
    public void setDrsEnabled(boolean drsEnabled) {
        this.drsEnabled = drsEnabled;
    }

    /**
     *  Gets the version of the virtual center
     * @return
     */
	public String getVirtualCenterVersion() {
		return virtualCenterVersion;
	}

	/**
	 *  Sets the version of the virtual center
	 * @param virtualCenterVersion
	 */
	public void setVirtualCenterVersion(String virtualCenterVersion) {
		this.virtualCenterVersion = virtualCenterVersion;
	}
    
    
}
