/*
 * Copyright (c) 2008 Akorri Networks, Inc. All Rights Reserved. This software is provided
 * under license and is not sold by Akorri Networks. This software may be used only in accordance
 * with the terms of an express written license agreement with Akorri Networks, and cannot be used,
 * copied, modified, or in any way distributed without the express permission of Akorri Networks.
 *
 */

package com.netapp.collectors.vmware;

import java.util.LinkedHashMap;

/**
 * Collection domain object for Virtual Center.
 * 
 * @author slaplante
 */
public class VMWareVirtualCenter {
    
    /** Clusters collected with this virtual center. */
    private LinkedHashMap<Object, VMWareCluster> clusters = new LinkedHashMap<Object, VMWareCluster>();
    
    /** Compute Resources collected with this virtual center. */
    private LinkedHashMap<Object, VMWareComputeResource> computeResources = new LinkedHashMap<Object, VMWareComputeResource>();
    
    /**
     * Gets a list of all clusters collected by this virtual center.
     * 
     * @return clusters list of all clusters collected by this virtual center
     */
    public LinkedHashMap<Object, VMWareCluster> getAllClusters(){
        return this.clusters;
    }
    
    /**
     * Sets a list of all clusters collected by this virtual center.
     * 
     * @param clusters list of all clusters collected by this virtual center
     */
    public void setAllClusters(LinkedHashMap<Object, VMWareCluster> clusters){
        this.clusters = clusters;
    }
    
    /**
     * Gets a cluster collected by this virtual center.
     * 
     * @param key managed object of this host
     * @return cluster cluster object collected by this virtual center
     */
    public VMWareCluster getCluster(Object key){
        return this.clusters.get(key);
    }
    
    /**
     * Sets a cluster collected by this virtual center.
     * 
     * @param key managed object of the cluster
     * @param cluster cluster object collected by this virtual center
     */
    public void putCluster(Object key, VMWareCluster cluster){
        this.clusters.put(key, cluster);
    }
    
    /**
     * Gets a list of all Compute Resources collected by this virtual center.
     * 
     * @return clusters list of all Compute Resources collected by this virtual center
     */
    public LinkedHashMap<Object, VMWareComputeResource> getAllComputeResources(){
        return this.computeResources;
    }
    
    /**
     * Sets a list of all Compute Resources collected by this virtual center.
     * 
     * @param computeResources list of all Compute Resources collected by this virtual center
     */
    public void setAllComputeResources(LinkedHashMap<Object, VMWareComputeResource> computeResources){
        this.computeResources = computeResources;
    }
    
    /**
     * Gets a Compute Resources collected by this virtual center.
     * 
     * @param key managed object of this host
     * @return ComputeResources Compute Resources object collected by this virtual center
     */
    public VMWareComputeResource getComputeResource(Object key){
        return this.computeResources.get(key);
    }
    
    /**
     * Sets a Compute Resource collected by this virtual center.
     * 
     * @param key managed object of the cluster
     * @param computeResources ComputeResource Compute Resource object collected by this virtual center
     */
    public void putComputeResource(Object key, VMWareComputeResource computeResources){
        this.computeResources.put(key, computeResources);
    }    
    
}
