package com.netapp.collectors.vmware.exceptions;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * Enum class that used for creating enum types.
 *
 */

public abstract class Enum implements Serializable {
    /**
     * a map of all the enum as named strings.
     */
    protected static Map nameMap = new HashMap(15);

    /**
     * a map of all the enum values.
     */
    protected static Map valueMap = new HashMap(15);

    /**
     * @return int
     */
    protected int value;

    /**
     *
     */
    protected transient String name;

    /**
     * Constructor.
     * @param name the string name
     * @param value the int value for this String
     */

    protected Enum(String name, int value) {
        this.value = value;
        this.name = name;
        add();
    }

    /**
     * put the enums in the nameMap and valueMap.
     */
    protected void add() {
        nameMap.put(this.name, this);
        valueMap.put(new Integer(this.value), this);
    }

    /**
     * Get an Enum from the name map.
     * @param name The name to use to get the Enum
     * @return the Enum corresponding to the name
     */
    public static Enum get(String name) {
        return (Enum) nameMap.get(name);
    }
    /**
     * get an Enum from the valueMap.
     * @param value The int to use to get the Enum
     * @return The Enum from the valueMap
     */
    public static Enum get(int value) {
        return (Enum) valueMap.get(new Integer(value));
    }

    /**
     *
     * @return the int value
     */
    public int getValue() {
        return value;
    }

    /**
     * get the name.
     * @return The name
     */
    public String getName() {
        return name;
    }

    /**
     * readResolve is overridden to return the same Enum and not construct a different instance.
     * @return this instance
     * @throws ObjectStreamException exception thrown
     */
    protected Object readResolve() throws ObjectStreamException {
        return get(this.value);
    }

}
