package com.netapp.collectors.vmware.exceptions;

/**
 * Exception which is thrown in case of wrong configuration done for fetching vmware data
 *
 * @author bsachin
 */
public class VMWareConfigurationException extends RuntimeException{

    private static final long serialVersionUID = 1L;

    /**
     * Default constructor.
     */
    public VMWareConfigurationException(){
        super();
    }

    /**
     * Constructor with a message string as the parameter.
     *
     * @param exceptionMessage The message to be displayed to the user.
     */
    public VMWareConfigurationException(String exceptionMessage){
        super(exceptionMessage);
    }

    /**
     * Constructor.
     *
     * @param msg The custom message that should be added to this exception.
     * @param exception The exception that the Configuration exception wraps.
     */
    public VMWareConfigurationException(String msg, Exception exception){
        super(msg,exception);
    }

}
