package com.netapp.collectors.vmware.exceptions;

/**
 * Exception which is thrown by any VMWareService.
 *
 * @author slaplante
 */
public class VMWareServiceException extends RuntimeException{

    private static final long serialVersionUID = 1L;

    /**
     * Default constructor.
     */
    public VMWareServiceException(){
        super();
    }

    /**
     * Constructor with a message string as the parameter.
     *
     * @param exceptionMessage The message to be displayed to the user.
     */
    public VMWareServiceException(String exceptionMessage){
        super(exceptionMessage);
    }

    /**
     * Constructor.
     *
     * @param msg The custom message that should be added to this exception.
     * @param exception The exception that the Configuration exception wraps.
     */
    public VMWareServiceException(String msg, Exception exception){
        super(msg,exception);
    }

}
