package com.netapp.collectors.vmware.util;

import com.netapp.collectors.vmware.IVMWareContext;
import com.netapp.collectors.vmware.ServiceConnection25;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ServiceContent;
import com.vmware.vim25.VimPortType;

public class ContextUtil {

    public static VimPortType getVimPortService(final IVMWareContext vmWareContext) {
        return ((ServiceConnection25)vmWareContext.getConnection()).getService();
    }
    public static ManagedObjectReference getRootFolder(final IVMWareContext vmWareContext) {
        return (((ServiceConnection25)vmWareContext.getConnection()).getRootFolder());
    }
    public static ManagedObjectReference getViewManagerReference(final IVMWareContext vmWareContext) {
        return ((ServiceContent) vmWareContext.getServiceContent()).getViewManager();
    }
}
