package com.netapp.collectors.vmware.util;

import java.util.Arrays;
import java.util.List;

public class PropertyFileUtil {
    //TODO externalize this to be picked from a file
    public static List<String> returnPropertiesForVm() {

        return Arrays.asList("name",
                "overallStatus",
                "config.uuid",
                "config.template",
                "guest.ipAddress",
                "guest.guestState",
                "guest.guestFamily",
                "guest.guestFullName",
                "guest.hostName",
                "runtime.powerState",
                "runtime.connectionState",
                "config.cpuAllocation.limit",
                "config.cpuAllocation.reservation",
                "config.memoryAllocation.limit",
                "config.memoryAllocation.reservation",
                "config.hardware.memoryMB",
                "config.hardware.numCPU",
                "config.hardware.device",
                "layoutEx");
    }

    public static List<String> returnPropertiesForHosts() {

        return Arrays.asList("name",
                "hardware.systemInfo.uuid",
                "runtime.connectionState",
                "runtime.inMaintenanceMode",
                "runtime.powerState",
                "hardware.cpuInfo.hz",
                "hardware.cpuInfo.numCpuCores",
                "hardware.cpuInfo.numCpuThreads",
                "systemResources.config.cpuAllocation.limit",
                "systemResources.config.memoryAllocation.limit",
                "hardware.memorySize",
                "summary.config.product.version",
                "datastore",
                "vm"
                );
    }

    public static List<String> returnPropertiesForDataStore() {
        return Arrays.asList(
                "summary.accessible",
                "summary.capacity",
                "summary.freeSpace",
                "summary.multipleHostAccess",
                "name",
                "summary.type",
                "summary.url",
                "info",
                "host"
        );
    }

    public static List<String> returnPerfCountersForVMVirtualDisks() {
        return Arrays.asList("virtualDisk.numberReadAveraged.average",
                "virtualDisk.numberWriteAveraged.average" ,
                "virtualDisk.read.average",
                "virtualDisk.write.average",
                "virtualDisk.totalReadLatency.average",
                "virtualDisk.totalWriteLatency.average");
    }


    public static List<String> returnPerfCountersForHost() {
        return Arrays.asList("sys.uptime.latest",
                "cpu.usage.average" ,
                "mem.usage.average",
                "net.usage.average");
    }
    public static List<String> returnPerfCountersForHostDatastore() {
        return Arrays.asList("datastore.numberReadAveraged.average",
                "datastore.read.average" ,
                "datastore.totalReadLatency.average",
                "datastore.numberWriteAveraged.average",
                "datastore.write.average",
                "datastore.totalWriteLatency.average");
    }
    public static List<String> returnPerfCountersForVMDatastore() {
        return Arrays.asList("datastore.numberReadAveraged.average",
                "datastore.read.average" ,
                "datastore.totalReadLatency.average",
                "datastore.numberWriteAveraged.average",
                "datastore.write.average",
                "datastore.totalWriteLatency.average");
    }
    public static String returnMaxQuerySettings(){
        return "config.vpxd.stats.maxQueryMetrics";
    }
}
