package com.netapp.collectors.vmware.util;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;


public class TimeUtil {

    public static XMLGregorianCalendar toXMLGregorianCalendar(Calendar c)
            throws DatatypeConfigurationException {
        //Time needs to be converted in the following format
        //'%Y-%m-%dT%H:%M:%SZ'
        return toXMLGregorianCalendar(c.getTimeInMillis());
    }

    public static Calendar fromXMLGregorianCalendar(XMLGregorianCalendar xc) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(xc.toGregorianCalendar().getTimeInMillis());
        return c;
    }
    public static XMLGregorianCalendar toXMLGregorianCalendar(long epoch) throws DatatypeConfigurationException {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTimeInMillis(epoch);
        XMLGregorianCalendar xc = DatatypeFactory.newInstance().newXMLGregorianCalendar(gc);
        return xc;
    }
}
