package com.netapp.collectors.vmware.util.certificates;

import java.util.Objects;
import java.util.StringJoiner;

public class TrustStoreKey {
    private String host;
    private int port;

    public TrustStoreKey(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public String getHost() {
        return host;
    }

    public int getPort() {
        return port;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        TrustStoreKey that = (TrustStoreKey) o;
        return Objects.equals(host, that.host) &&
                Objects.equals(port, that.port);
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", TrustStoreKey.class.getSimpleName() + "[", "]")
                .add("host='" + host + "'")
                .add("port=" + port)
                .toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(host, port);
    }


}
