package com.onaro.commons.exception;

/**
 * Exception that happens when netapp interfaces fail to return result to the caller.
 * Can not have nested exceptions since client code base might not have libraries that contain nested exception.
 *
 * @author Anton Sergeev
 */
public class NetappInterfaceException extends NestedStackTraceException {
    private static final long serialVersionUID = 1L;

    public NetappInterfaceException(String message) {
        super(message);
    }

    public NetappInterfaceException(String message, Throwable ex) {
        super(message, ex);
    }
}

