package com.onaro.commons.types;

import java.util.*;
import java.io.IOException;
import java.io.Serializable;
import java.io.OptionalDataException;
import java.lang.reflect.Modifier;
import java.lang.reflect.Field;

/**
 * Abstract class for representing types that are managed by the system's dictionary. Provides translation services from
 * strings or id's to the types.
 * <p>
 * Note that the dictionary also provide aa case insensitive translation. As a result, value names of some type must be
 * case-insensitive different from each other. Using two connection types named "Inter" and "inteR" is invalid.
 */
/*
TODO : After converting all the AbstractType sub-classes to Enum, please delete this class
 */
@Deprecated
public abstract class AbstractType implements Serializable, Comparable<Object> {
    private static final long serialVersionUID = 1L;

    /**
	 * these memebers are used for fast equels.
	 */
	private final String className;

    private final int hashCode;

    /**
	 * Identifies this type in the system's dictionary.
	 */
	private final int typeId;

    /**
	 * The name of this value.
	 */
	private final String name;

    /**
	 * Maps a separate translation dictionary for each type. Indexed by the class of a type and contains
	 * <code>Map</code> objects. Each dictionary is indexed by the name of the AbstractType, both as defined in the
	 * constructor and in lower case, so that every value appears in the map either 1 or 2 times (depend if name of
	 * AbstractType is already lower case or not)
	 */
	private final static Map<Class<? extends AbstractType>,Map<String,AbstractType>> typeNameDictionarys = new HashMap<Class<? extends AbstractType>,Map<String,AbstractType>>();
    /**
	 * Maps a separate translation dictionary for each type. Indexed by the class of a type and contains
	 * <code>Map</code> objects. Each dictionary is indexed by the Id (<code>Integer</code>) of the AbstractType,
	 * so that every value appears in the map once.
	 */
	private final static Map<Class<? extends AbstractType>,Map<Integer,AbstractType>> typeIdDictionarys = new HashMap<Class<? extends AbstractType>,Map<Integer,AbstractType>>();

    /**
	 * Constructs a type object, initialize its data members and register it with the dictionary to allow translation by
	 * its id or name.
	 * 
	 * @param type
	 *            identifies the type
	 * @param typeId
	 *            the id of this type object
	 * @param name
	 *            the name of this type object
	 */
	@SuppressWarnings("unchecked")
	protected AbstractType(Class<? extends AbstractType> type, int typeId, String name) {
		this.typeId = typeId;
		this.name = name;

		// Register in the dictionary.
		Map<String,AbstractType> typeNameDic = (Map<String,AbstractType>) getTypeNameDictionary(type);
		if (typeNameDic == null) {
			typeNameDic = new HashMap<String,AbstractType>();
			typeNameDictionarys.put(type, typeNameDic);
		}

		assert !typeNameDic.containsKey(name) : "Type '" + name + "' already mapped to '" + typeNameDic.get(name)
				+ '\'';
		assert name != null : "name cannot be null";

		typeNameDic.put(name, this);
		typeNameDic.put(name.toLowerCase(), this);

		Map<Integer,AbstractType> typeIdDic = (Map<Integer,AbstractType>) getTypeIdDictionary(type);
		if (typeIdDic == null) {
			typeIdDic = new HashMap<Integer,AbstractType>();
			typeIdDictionarys.put(type, typeIdDic);
		}
		Integer typeIdInteger = new Integer(typeId);
		assert !typeIdDic.containsKey(typeIdInteger) : "ID '" + typeIdInteger + "' already mapped to '"
				+ typeIdDic.get(typeIdInteger) + '\'';
		typeIdDic.put(typeIdInteger, this);

		className = type.getName();
        this.hashCode = typeId + 29 * className.hashCode();
	}

	/**
	 * Gets the id of this type.
	 * 
	 * @return the id of this type
	 */
	public final int getTypeId() {
		return typeId;
	}

	/**
	 * Gets the name of this type.
	 * 
	 * @return the name of this type
	 */
	public final String getName() {
		return name;
	}

	/**
	 * Gets the type object with the specified id.
	 * 
	 * @param type
	 *            identifies the type
	 * @param typeId
	 *            the type's id
	 * @return the requested type object or null if it doesn't exist
	 */
	public static <T extends AbstractType> T getById(Class<T> type, int typeId) {
		return type.cast(get(type, new Integer(typeId)));
	}

	/**
	 * Gets the type object with the specified name.
	 * 
	 * @param type
	 *            identifies the type
	 * @param name
	 *            the type's name
	 * @return the requested type object or null if it doesn't exist
	 */
	public static <T extends AbstractType> T getByName(Class<T> type, String name) {
		return type.cast(get(type, name));
	}

	/**
	 * Gets the type object with the specified name ignoring its case.
	 * 
	 * @param type
	 *            identifies the type
	 * @param name
	 *            the type's name
	 * @return the requested type object or null if it doesn't exist
	 */
	protected static <T extends AbstractType> T getByNameIgnoreCase(Class<T> type, String name) {
		return get(type, name.toLowerCase());
	}

	/**
	 * Gets a list of all the type object for a given type.
	 * 
	 * @param type
	 *            identifies the type
	 * @return a list of {@link AbstractType} objects
	 */
	public static <T extends AbstractType> Collection<T> getAll(Class<T> type) {
		Map<Integer,T> typeIdDic = getTypeIdDictionary(type);
		assert typeIdDic != null : "Type '" + type + "' not found";
		return typeIdDic.values();
	}

	@Override
	public String toString() {
		return name;
	}

	@Override
	public int hashCode() {
		return hashCode;
	}

	@Override
	public boolean equals(Object obj) {
		try {
			AbstractType abstractType = (AbstractType) obj;
			if (abstractType == null || abstractType.typeId != typeId) return false;
			return abstractType.className.compareTo(className) == 0;
		}
		catch (ClassCastException e) {
			return false;
		}
	}

	public int compareTo(Object o) {
		if (o == null) return 1;
		return getTypeId() - ((AbstractType) o).getTypeId();
	}

	private static <T extends AbstractType> AbstractType get(Class<T> type, Integer key) {
		Map<Integer,T> typeIdDic = getTypeIdDictionary(type);
		if (typeIdDic == null) return null;
		return typeIdDic.get(key);
	}

	private static <T extends AbstractType> T get(Class<T> type, String key) {
		Map<String,T> typeNameDic = getTypeNameDictionary(type);
		if (typeNameDic == null) return null;
		return typeNameDic.get(key);
	}

	@SuppressWarnings("unchecked")
	private static <T extends AbstractType> Map<Integer,T> getTypeIdDictionary(Class<T> type) {
		return (Map<Integer,T>) typeIdDictionarys.get(type);
	}

	@SuppressWarnings("unchecked")
	private static <T extends AbstractType> Map<String,T> getTypeNameDictionary(Class<T> type) {
		return (Map<String,T>) typeNameDictionarys.get(type);
	}

	private transient String _fieldName;

	private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {

		Class<?> clazz = getClass();
		Field[] f = clazz.getDeclaredFields();

		for (Field element : f) {
			try {
				int mod = element.getModifiers();

				if (Modifier.isStatic(mod) && Modifier.isFinal(mod) && Modifier.isPublic(mod)) {

					if (this.equals(element.get(null))) {
						String fName = element.getName();
						out.writeObject(fName);
					}
				}
			}
			catch (IllegalAccessException ex) {
				IOException ioe = new java.io.IOException();
				ioe.initCause(ex);
				throw ioe;
			}
		}
	}

	private void readObject(java.io.ObjectInputStream in) throws java.io.IOException {
		try {
			_fieldName = (String) in.readObject();
		}
		catch (ClassNotFoundException ex) {
			IOException ioe = new java.io.IOException("Failed read object Class: " + getClass().getName());
			ioe.initCause(ex);
			throw ioe;
		}
		catch (OptionalDataException ex) {
			IOException ioe = new java.io.IOException("Failed read object Class: " + getClass().getName());
			ioe.initCause(ex);
			throw ioe;
		}
	}

	public Object readResolve() throws java.io.ObjectStreamException {
		try {
			Class<?> clazz = getClass();
			Field f = clazz.getField(_fieldName);
			return f.get(null);
		}
		catch (Exception ex) {
			java.io.InvalidObjectException ioe = new java.io.InvalidObjectException("Failed to resolve object Class: "
					+ getClass().getName());

			ioe.initCause(ex);

			throw ioe;
		}
	}

	public boolean equalsName(String type) {
		return getName().equalsIgnoreCase(type);
	}
}
