package com.onaro.commons.util;

import java.net.HttpURLConnection;
import java.util.List;

import org.apache.commons.lang3.StringUtils;

/**
 * Utility class to maintain all the HTTP URL Connection related processes.
 */
public class HttpURLConnectionUtils {

    public static final String SESSION_STRING = "JSESSIONID=";

    /**
     * Method to fetch jSession-id
     * @param urlConnection
     * @return JsessionId
     */
    public static String getJsesionIdCookie(HttpURLConnection urlConnection) {

        List<String> setCookieFields = urlConnection.getHeaderFields().get("Set-Cookie");

        if (setCookieFields != null) {
            for(String cookie : setCookieFields) {
                if(cookie.contains(SESSION_STRING)) {
                    return SESSION_STRING + StringUtils.substringBetween(cookie, SESSION_STRING, ";");
                }
            }
        }
        return null;
    }
}
