package com.onaro.commons.util;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target({ElementType.METHOD, ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
public @interface Message
{
	/**
	 * Same as the key field.
	 */
	String value() default ""; //$NON-NLS-1$
	
	/**
	 * Same as the value field.
	 */
	String key() default ""; //$NON-NLS-1$
	
	/**
	 * Flag indicating this message refers to a MessageFormat string.
	 */
	boolean format() default false;
}
