package com.onaro.commons.util;

import java.io.Serializable;

public class Pair<X,Y> implements Serializable {

    private static final long serialVersionUID = 1L;

    public X x;
    public Y y;

    public Pair(X x, Y y) {
        this.x = x;
        this.y = y;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        final Pair pair = (Pair) o;

        if (x != null ? !x.equals(pair.x) : pair.x != null) return false;
        if (y != null ? !y.equals(pair.y) : pair.y != null) return false;

        return true;
    }

    public int hashCode() {
        int result;
        result = (x != null ? x.hashCode() : 0);
        result = 29 * result + (y != null ? y.hashCode() : 0);
        return result;
    }


    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(x).append(',').append(y);
        return buffer.toString();
    }
}
