package com.onaro.commons.util;

import java.util.*;

public abstract class TreeMapOfCollections<K, V, C extends Collection<V>> extends TreeMap<K, C> {
    private static final long serialVersionUID = 1L;
    private boolean returnEmptyCollectionWhenNull;

    protected TreeMapOfCollections(boolean returnEmptyCollectionWhenNull) {
        this.returnEmptyCollectionWhenNull = returnEmptyCollectionWhenNull;
    }


    public boolean contains(K key, V value) {
        Collection<V> collection = get(key);
        return collection != null && collection.contains(value);
    }

    public boolean add(K key, V value) {
        C collection = super.get(key);
        if (collection == null) {
            collection = newCollection();
            put(key, collection);
        }

        return collection.add(value);
    }

    public void add(TreeMapOfCollections<K, V, C> other) {
        for (Map.Entry<K, C> entry : other.entrySet()) {
            add(entry.getKey(), entry.getValue());
        }
    }
    
    public boolean add(K key, Collection<V> values) {
        C collection = super.get(key);
        if (collection == null) {
            collection = newCollection();
            put(key, collection);
        }

        return collection.addAll(values);
    }


    public C get(Object key) {
        C rv = super.get(key);
        return rv == null && returnEmptyCollectionWhenNull ? emptyCollection() : rv;
    }


    public Set<V> getValuesSet() {
        HashSet<V> set = new HashSet<V>();
        for (Collection<V> values : values()) {
            set.addAll(values);
        }
        return set;
    }

    protected abstract C newCollection();

    protected abstract C emptyCollection();

    //        if (useSets) {
    //            return comparator != null ? new TreeSet<V>(comparator) : new HashSet<V>();
    //        } else {
    //            return new ArrayList<V>();
    //        }
    //    }

    public boolean remove(Object key, Object value) {
        boolean changed = false;
        Collection<V> collection = super.get(key);
        if (collection != null) {
            changed = collection.remove(value);
            if (collection.isEmpty()) {
                remove(key);
            }
        }

        return changed;
    }
}