package com.onaro.commons.util;

public class Triplet<X,Y,Z> {
    public X x;
    public Y y;
    public Z z;

    public Triplet(X x, Y y, Z z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        final Triplet triplet = (Triplet) o;

        if (x != null ? !x.equals(triplet.x) : triplet.x != null) return false;
        if (y != null ? !y.equals(triplet.y) : triplet.y != null) return false;
        if (z != null ? !z.equals(triplet.z) : triplet.z != null) return false;

        return true;
    }

    public int hashCode() {
        int result;
        result = (x != null ? x.hashCode() : 0);
        result = 29 * result + (y != null ? y.hashCode() : 0);
        result = 29 * result + (z != null ? z.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(x).append(',').append(y).append(',').append(z);
        return buffer.toString();
    }
}
