package com.onaro.commons.util;

public class ValueConstants {
    public static final double NOT_AVAILABLE_DOUBLE = Double.NaN;
    public static final Double NOT_AVAILABLE_DOUBLE_OBJECT = Double.valueOf (NOT_AVAILABLE_DOUBLE);
    public static final float NOT_AVAILABLE_FLOAT = Float.NaN;
    public static final Float NOT_AVAILABLE_FLOAT_OBJECT = Float.valueOf (NOT_AVAILABLE_FLOAT);
    public static final long NOT_AVAILABLE_LONG = Long.MIN_VALUE;
    public static final Long NOT_AVAILABLE_LONG_OBJECT = Long.valueOf (NOT_AVAILABLE_LONG);
    public static final int NOT_AVAILABLE_INT = Integer.MIN_VALUE;
    public static final Integer NOT_AVAILABLE_INTEGER_OBJECT = Integer.valueOf (NOT_AVAILABLE_INT);
    public static final short NOT_AVAILABLE_SHORT = Short.MIN_VALUE;
    public static final Short NOT_AVAILABLE_SHORT_OBJECT = Short.valueOf (NOT_AVAILABLE_SHORT);
    public static final byte NOT_AVAILABLE_BYTE = Byte.MIN_VALUE;
    public static final Byte NOT_AVAILABLE_BYTE_OBJECT = Byte.valueOf (NOT_AVAILABLE_BYTE);
    public static final String NOT_AVAILABLE_STRING = "N/A";

    /**
     * Determine if a value represents data that is not available.
     * @param value a {@link Number}
     * @return {@code true} if the value represents data not available; {@code false} otherwise
     */
    public static boolean isNotAvailableValue (Number value) {
        return value instanceof Double && ((Double)value).isNaN()
	        || value instanceof Float && ((Float)value).isNaN()
	        || value instanceof Long && value.longValue() == Long.MIN_VALUE
	        || value instanceof Integer && value.intValue() == Integer.MIN_VALUE
	        || value instanceof Short && value.shortValue() == Short.MIN_VALUE
	        || value instanceof Byte && value.byteValue() == Byte.MIN_VALUE;
    }

    /**
     * Determine if a value represents data that is not available.
     * @param value a {@link String}
     * @return {@code true} if the value represents data not available; {@code false} otherwise
     */
    public static boolean isNotAvailableValue (String value) {
        return NOT_AVAILABLE_STRING.equals(value);
    }

    /**
     * Determine if a value represents data that is not available.
     * @param value an {@link Object}
     * @return {@code true} if the object represents data not available; {@code false} otherwise
     */
    public static boolean isNotAvailableValue (Object value) {
        return value instanceof Number && isNotAvailableValue ((Number)value)
            || NOT_AVAILABLE_STRING.equals(value);
    }
}
