/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.compress.taskdefs;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.ant.compress.resources.TarFileSet;
import org.apache.ant.compress.taskdefs.ArchiveBase;
import org.apache.ant.compress.util.TarStreamFactory;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.tools.ant.types.ArchiveFileSet;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Resource;

public class Tar
extends ArchiveBase {
    private Format format = Format.USTAR;

    public Tar() {
        this.setFactory(new TarStreamFactory(){

            public ArchiveOutputStream getArchiveStream(OutputStream stream, String encoding) throws IOException {
                TarArchiveOutputStream o = (TarArchiveOutputStream)super.getArchiveStream(stream, encoding);
                if (Tar.this.format.equals((Object)Format.OLDGNU)) {
                    o.setLongFileMode(2);
                } else if (Tar.this.format.equals((Object)Format.GNU)) {
                    o.setLongFileMode(2);
                    o.setBigNumberMode(1);
                } else if (Tar.this.format.equals((Object)Format.STAR)) {
                    o.setLongFileMode(3);
                    o.setBigNumberMode(1);
                } else if (Tar.this.format.equals((Object)Format.PAX)) {
                    o.setLongFileMode(3);
                    o.setBigNumberMode(2);
                    o.setAddPaxHeadersForNonAsciiNames(true);
                }
                return o;
            }
        });
        this.setEntryBuilder(new ArchiveBase.EntryBuilder(){

            public ArchiveEntry buildEntry(ArchiveBase.ResourceWithFlags r) {
                boolean isDir = r.getResource().isDirectory();
                String name = r.getName();
                if (isDir && !name.endsWith("/")) {
                    name = name + "/";
                } else if (!isDir && name.endsWith("/")) {
                    name = name.substring(0, name.length() - 1);
                }
                TarArchiveEntry ent = new TarArchiveEntry(name, Tar.this.getPreserveLeadingSlashes());
                ent.setModTime(Tar.this.round(r.getResource().getLastModified(), 1000L));
                ent.setSize(isDir ? 0L : r.getResource().getSize());
                if (!isDir && r.getCollectionFlags().hasModeBeenSet()) {
                    ent.setMode(r.getCollectionFlags().getMode());
                } else if (isDir && r.getCollectionFlags().hasDirModeBeenSet()) {
                    ent.setMode(r.getCollectionFlags().getDirMode());
                } else if (r.getResourceFlags().hasModeBeenSet()) {
                    ent.setMode(r.getResourceFlags().getMode());
                } else {
                    ent.setMode(isDir ? 16877 : 33188);
                }
                if (r.getResourceFlags().hasUserIdBeenSet()) {
                    ent.setUserId(r.getResourceFlags().getUserId());
                } else if (r.getCollectionFlags().hasUserIdBeenSet()) {
                    ent.setUserId(r.getCollectionFlags().getUserId());
                }
                if (r.getResourceFlags().hasGroupIdBeenSet()) {
                    ent.setGroupId(r.getResourceFlags().getGroupId());
                } else if (r.getCollectionFlags().hasGroupIdBeenSet()) {
                    ent.setGroupId(r.getCollectionFlags().getGroupId());
                }
                if (r.getResourceFlags().hasUserNameBeenSet()) {
                    ent.setUserName(r.getResourceFlags().getUserName());
                } else if (r.getCollectionFlags().hasUserNameBeenSet()) {
                    ent.setUserName(r.getCollectionFlags().getUserName());
                }
                if (r.getResourceFlags().hasGroupNameBeenSet()) {
                    ent.setGroupName(r.getResourceFlags().getGroupName());
                } else if (r.getCollectionFlags().hasGroupNameBeenSet()) {
                    ent.setGroupName(r.getCollectionFlags().getGroupName());
                }
                return ent;
            }
        });
        this.setFileSetBuilder(new ArchiveBase.FileSetBuilder(){

            public ArchiveFileSet buildFileSet(Resource dest) {
                TarFileSet afs = new TarFileSet();
                afs.setSrcResource(dest);
                return afs;
            }
        });
    }

    public void setFormat(Format f) {
        this.format = f;
    }

    public static final class Format
    extends EnumeratedAttribute {
        private static final String USTAR_NAME = "ustar";
        private static final String OLDGNU_NAME = "oldgnu";
        private static final String GNU_NAME = "gnu";
        private static final String STAR_NAME = "star";
        private static final String PAX_NAME = "pax";
        public static final Format USTAR = new Format("ustar");
        public static final Format OLDGNU = new Format("oldgnu");
        public static final Format GNU = new Format("gnu");
        public static final Format STAR = new Format("star");
        public static final Format PAX = new Format("pax");

        public Format(String v) {
            this.setValue(v);
        }

        public Format() {
            this.setValue(USTAR_NAME);
        }

        public String[] getValues() {
            return new String[]{USTAR_NAME, OLDGNU_NAME, GNU_NAME, STAR_NAME, PAX_NAME};
        }

        public boolean equals(Object other) {
            return other instanceof Format && ((Format)((Object)other)).getValue().equals(this.getValue());
        }
    }
}

