/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.sdk.impl.logging;

import com.blackducksoftware.sdk.impl.logging.LoggingMessageSecure;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.StaxOutInterceptor;
import org.apache.cxf.io.CacheAndWriteOutputStream;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.io.CachedOutputStreamCallback;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

public abstract class AbstractPayloadFilteredLoggingOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    private int limit = 102400;
    private PrintWriter writer;

    public AbstractPayloadFilteredLoggingOutInterceptor(String string) {
        super(string);
        this.addBefore(StaxOutInterceptor.class.getName());
    }

    public AbstractPayloadFilteredLoggingOutInterceptor() {
        this("pre-stream");
    }

    public AbstractPayloadFilteredLoggingOutInterceptor(int n) {
        this();
        this.limit = n;
    }

    public AbstractPayloadFilteredLoggingOutInterceptor(PrintWriter printWriter) {
        this();
        this.writer = printWriter;
    }

    public void setLimit(int n) {
        this.limit = n;
    }

    public int getLimit() {
        return this.limit;
    }

    public void handleMessage(Message message) throws Fault {
        OutputStream outputStream = (OutputStream)message.getContent(OutputStream.class);
        if (outputStream == null) {
            return;
        }
        if (this.getLogger().isLoggable(Level.INFO) || this.writer != null) {
            CacheAndWriteOutputStream cacheAndWriteOutputStream = new CacheAndWriteOutputStream(outputStream);
            message.setContent(OutputStream.class, (Object)cacheAndWriteOutputStream);
            cacheAndWriteOutputStream.registerCallback((CachedOutputStreamCallback)new LoggingCallback(message, outputStream));
        }
    }

    protected String transform(String string) {
        return string;
    }

    abstract Logger getLogger();

    abstract LoggingMessageSecure createNewLoggingMessage(String var1);

    class LoggingCallback
    implements CachedOutputStreamCallback {
        private final Message message;
        private final OutputStream origStream;

        public LoggingCallback(Message message, OutputStream outputStream) {
            this.message = message;
            this.origStream = outputStream;
        }

        public void onFlush(CachedOutputStream cachedOutputStream) {
        }

        public void onClose(CachedOutputStream cachedOutputStream) {
            Object object;
            String string;
            String string2;
            String string3 = (String)this.message.getExchange().get((Object)LoggingMessageSecure.ID_KEY);
            if (string3 == null) {
                string3 = LoggingMessageSecure.nextId();
                this.message.getExchange().put((Object)LoggingMessageSecure.ID_KEY, (Object)string3);
            }
            LoggingMessageSecure loggingMessageSecure = AbstractPayloadFilteredLoggingOutInterceptor.this.createNewLoggingMessage(string3);
            String string4 = (String)this.message.get((Object)Message.ENCODING);
            if (string4 != null) {
                loggingMessageSecure.getEncoding().append(string4);
            }
            if ((string2 = (String)this.message.get((Object)Message.ENDPOINT_ADDRESS)) != null) {
                loggingMessageSecure.getAddress().append(string2);
            }
            if ((string = (String)this.message.get((Object)"Content-Type")) != null) {
                loggingMessageSecure.getContentType().append(string);
            }
            if ((object = this.message.get((Object)Message.PROTOCOL_HEADERS)) != null) {
                loggingMessageSecure.getHeader().append(object);
            }
            if (cachedOutputStream.getTempFile() == null) {
                if (cachedOutputStream.size() > AbstractPayloadFilteredLoggingOutInterceptor.this.limit) {
                    loggingMessageSecure.getMessage().append("(message truncated to " + AbstractPayloadFilteredLoggingOutInterceptor.this.limit + " bytes)\n");
                }
            } else {
                loggingMessageSecure.getMessage().append("Outbound Message (saved to tmp file):\n");
                loggingMessageSecure.getMessage().append("Filename: " + cachedOutputStream.getTempFile().getAbsolutePath() + "\n");
                if (cachedOutputStream.size() > AbstractPayloadFilteredLoggingOutInterceptor.this.limit) {
                    loggingMessageSecure.getMessage().append("(message truncated to " + AbstractPayloadFilteredLoggingOutInterceptor.this.limit + " bytes)\n");
                }
            }
            try {
                cachedOutputStream.writeCacheTo(loggingMessageSecure.getPayload(), AbstractPayloadFilteredLoggingOutInterceptor.this.limit);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (AbstractPayloadFilteredLoggingOutInterceptor.this.writer != null) {
                AbstractPayloadFilteredLoggingOutInterceptor.this.writer.println(AbstractPayloadFilteredLoggingOutInterceptor.this.transform(loggingMessageSecure.toString()));
            } else if (AbstractPayloadFilteredLoggingOutInterceptor.this.getLogger().isLoggable(Level.INFO)) {
                AbstractPayloadFilteredLoggingOutInterceptor.this.getLogger().info(AbstractPayloadFilteredLoggingOutInterceptor.this.transform(loggingMessageSecure.toString()));
            }
            try {
                cachedOutputStream.lockOutputStream();
                cachedOutputStream.resetOut(null, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.message.setContent(OutputStream.class, (Object)this.origStream);
        }
    }
}

