/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.compress.compress.archivers.tar;

import java.io.File;
import java.util.Date;
import java.util.Locale;
import org.vafer.jdeb.shaded.compress.compress.archivers.ArchiveEntry;
import org.vafer.jdeb.shaded.compress.compress.archivers.tar.TarConstants;
import org.vafer.jdeb.shaded.compress.compress.archivers.tar.TarUtils;

public class TarArchiveEntry
implements TarConstants,
ArchiveEntry {
    private String name = "";
    private int mode;
    private int userId;
    private int groupId;
    private long size;
    private long modTime;
    private byte linkFlag;
    private String linkName = "";
    private String magic = "ustar\u0000";
    private String version = "00";
    private String userName;
    private String groupName;
    private int devMajor;
    private int devMinor;
    private File file;
    public static final int MAX_NAMELEN = 31;
    public static final int DEFAULT_DIR_MODE = 16877;
    public static final int DEFAULT_FILE_MODE = 33188;
    public static final int MILLIS_PER_SECOND = 1000;

    private TarArchiveEntry() {
        String user = System.getProperty("user.name", "");
        if (user.length() > 31) {
            user = user.substring(0, 31);
        }
        this.userId = 0;
        this.groupId = 0;
        this.userName = user;
        this.groupName = "";
        this.file = null;
    }

    public TarArchiveEntry(String name) {
        this();
        name = TarArchiveEntry.normalizeFileName(name);
        boolean isDir = name.endsWith("/");
        this.devMajor = 0;
        this.devMinor = 0;
        this.name = name;
        this.mode = isDir ? 16877 : 33188;
        this.linkFlag = (byte)(isDir ? 53 : 48);
        this.userId = 0;
        this.groupId = 0;
        this.size = 0L;
        this.modTime = new Date().getTime() / 1000L;
        this.linkName = "";
        this.userName = "";
        this.groupName = "";
        this.devMajor = 0;
        this.devMinor = 0;
    }

    public TarArchiveEntry(String name, byte linkFlag) {
        this(name);
        this.linkFlag = linkFlag;
    }

    public TarArchiveEntry(File file) {
        this(file, TarArchiveEntry.normalizeFileName(file.getPath()));
    }

    public TarArchiveEntry(File file, String fileName) {
        this();
        this.file = file;
        this.linkName = "";
        if (file.isDirectory()) {
            this.mode = 16877;
            this.linkFlag = (byte)53;
            int nameLength = fileName.length();
            this.name = nameLength == 0 || fileName.charAt(nameLength - 1) != '/' ? fileName + "/" : fileName;
            this.size = 0L;
        } else {
            this.mode = 33188;
            this.linkFlag = (byte)48;
            this.size = file.length();
            this.name = fileName;
        }
        this.modTime = file.lastModified() / 1000L;
        this.devMajor = 0;
        this.devMinor = 0;
    }

    public TarArchiveEntry(byte[] headerBuf) {
        this();
        this.parseTarHeader(headerBuf);
    }

    public boolean equals(TarArchiveEntry it) {
        return this.getName().equals(it.getName());
    }

    public boolean equals(Object it) {
        if (it == null || this.getClass() != it.getClass()) {
            return false;
        }
        return this.equals((TarArchiveEntry)it);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean isDescendent(TarArchiveEntry desc) {
        return desc.getName().startsWith(this.getName());
    }

    public String getName() {
        return this.name.toString();
    }

    public void setName(String name) {
        this.name = TarArchiveEntry.normalizeFileName(name);
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public String getLinkName() {
        return this.linkName.toString();
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public void setGroupId(int groupId) {
        this.groupId = groupId;
    }

    public String getUserName() {
        return this.userName.toString();
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getGroupName() {
        return this.groupName.toString();
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public void setIds(int userId, int groupId) {
        this.setUserId(userId);
        this.setGroupId(groupId);
    }

    public void setNames(String userName, String groupName) {
        this.setUserName(userName);
        this.setGroupName(groupName);
    }

    public void setModTime(long time) {
        this.modTime = time / 1000L;
    }

    public void setModTime(Date time) {
        this.modTime = time.getTime() / 1000L;
    }

    public Date getModTime() {
        return new Date(this.modTime * 1000L);
    }

    public File getFile() {
        return this.file;
    }

    public int getMode() {
        return this.mode;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        if (size > 0x1FFFFFFFFL || size < 0L) {
            throw new IllegalArgumentException("Size is out of range: " + size);
        }
        this.size = size;
    }

    public boolean isGNULongNameEntry() {
        return this.linkFlag == 76 && this.name.toString().equals("././@LongLink");
    }

    public boolean isDirectory() {
        if (this.file != null) {
            return this.file.isDirectory();
        }
        if (this.linkFlag == 53) {
            return true;
        }
        return this.getName().endsWith("/");
    }

    public TarArchiveEntry[] getDirectoryEntries() {
        if (this.file == null || !this.file.isDirectory()) {
            return new TarArchiveEntry[0];
        }
        String[] list = this.file.list();
        TarArchiveEntry[] result = new TarArchiveEntry[list.length];
        for (int i = 0; i < list.length; ++i) {
            result[i] = new TarArchiveEntry(new File(this.file, list[i]));
        }
        return result;
    }

    public void writeEntryHeader(byte[] outbuf) {
        int offset = 0;
        offset = TarUtils.formatNameBytes(this.name, outbuf, offset, 100);
        offset = TarUtils.formatOctalBytes(this.mode, outbuf, offset, 8);
        offset = TarUtils.formatOctalBytes(this.userId, outbuf, offset, 8);
        offset = TarUtils.formatOctalBytes(this.groupId, outbuf, offset, 8);
        offset = TarUtils.formatLongOctalBytes(this.size, outbuf, offset, 12);
        int csOffset = offset = TarUtils.formatLongOctalBytes(this.modTime, outbuf, offset, 12);
        for (int c = 0; c < 8; ++c) {
            outbuf[offset++] = 32;
        }
        outbuf[offset++] = this.linkFlag;
        offset = TarUtils.formatNameBytes(this.linkName, outbuf, offset, 100);
        offset = TarUtils.formatNameBytes(this.magic, outbuf, offset, 6);
        offset = TarUtils.formatNameBytes(this.version, outbuf, offset, 2);
        offset = TarUtils.formatNameBytes(this.userName, outbuf, offset, 32);
        offset = TarUtils.formatNameBytes(this.groupName, outbuf, offset, 32);
        offset = TarUtils.formatOctalBytes(this.devMajor, outbuf, offset, 8);
        offset = TarUtils.formatOctalBytes(this.devMinor, outbuf, offset, 8);
        while (offset < outbuf.length) {
            outbuf[offset++] = 0;
        }
        long chk = TarUtils.computeCheckSum(outbuf);
        TarUtils.formatCheckSumOctalBytes(chk, outbuf, csOffset, 8);
    }

    public void parseTarHeader(byte[] header) {
        int offset = 0;
        this.name = TarUtils.parseName(header, offset, 100);
        this.mode = (int)TarUtils.parseOctal(header, offset += 100, 8);
        this.userId = (int)TarUtils.parseOctal(header, offset += 8, 8);
        this.groupId = (int)TarUtils.parseOctal(header, offset += 8, 8);
        this.size = TarUtils.parseOctal(header, offset += 8, 12);
        this.modTime = TarUtils.parseOctal(header, offset += 12, 12);
        offset += 12;
        offset += 8;
        this.linkFlag = header[offset++];
        this.linkName = TarUtils.parseName(header, offset, 100);
        this.magic = TarUtils.parseName(header, offset += 100, 6);
        this.version = TarUtils.parseName(header, offset += 6, 2);
        this.userName = TarUtils.parseName(header, offset += 2, 32);
        this.groupName = TarUtils.parseName(header, offset += 32, 32);
        this.devMajor = (int)TarUtils.parseOctal(header, offset += 32, 8);
        this.devMinor = (int)TarUtils.parseOctal(header, offset += 8, 8);
    }

    private static String normalizeFileName(String fileName) {
        String osname = System.getProperty("os.name").toLowerCase(Locale.US);
        if (osname != null) {
            int colon;
            if (osname.startsWith("windows")) {
                if (fileName.length() > 2) {
                    char ch1 = fileName.charAt(0);
                    char ch2 = fileName.charAt(1);
                    if (ch2 == ':' && (ch1 >= 'a' && ch1 <= 'z' || ch1 >= 'A' && ch1 <= 'Z')) {
                        fileName = fileName.substring(2);
                    }
                }
            } else if (osname.indexOf("netware") > -1 && (colon = fileName.indexOf(58)) != -1) {
                fileName = fileName.substring(colon + 1);
            }
        }
        fileName = fileName.replace(File.separatorChar, '/');
        while (fileName.startsWith("/")) {
            fileName = fileName.substring(1);
        }
        return fileName;
    }
}

