/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.axx.findbugs.xss;

import com.netapp.axx.findbugs.xss.UnsafeStringDetectionUtils;
import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.bcel.classfile.Code;

public class GwtUnsafeHtml
extends OpcodeStackDetector {
    private static final String XSS_UNSAFE_HTML__SET_HTML = "XSS_UNSAFE_HTML__SET_HTML";
    private static final String XSS_UNSAFE_HTML__CONSTRUCTOR = "XSS_UNSAFE_HTML__CONSTRUCTOR";
    private static final String XSS_UNSAFE_HTML__SET_INNER_HTML = "XSS_UNSAFE_HTML__SET_INNER_HTML";
    private static final String XSS_UNSAFE_HTML__CONSTANT = "XSS_UNSAFE_HTML__CONSTANT";
    private static final String XSS_UNSAFE_HTML__GXT_CONSTRUCTOR = "XSS_UNSAFE_HTML__GXT_CONSTRUCTOR";
    private static final String XSS_UNSAFE_HTML__GXT_METHOD = "XSS_UNSAFE_HTML__GXT_METHOD";
    private static final String XSS_UNSAFE_HTML__CELL_RENDERER = "XSS_UNSAFE_HTML__CELL_RENDERER";
    private static final String HAS_HTML = "com/google/gwt/user/client/ui/HasHTML";
    private static final String HAS_SAFE_HTML = "com/google/gwt/safehtml/client/HasSafeHtml";
    private static final String HAS_DIRECTIONAL_HTML = "com/google/gwt/user/client/ui/HasDirectionalHtml";
    private static final String HAS_DIRECTIONAL_SAFE_HTML = "com/google/gwt/user/client/ui/HasDirectionalSafeHtml";
    private static final MethodDescriptor SET_HTML = new MethodDescriptor("com/google/gwt/safehtml/client/HasSafeHtml", "setHTML", "(Lcom/google/gwt/safehtml/shared/SafeHtml;)V", false);
    private static final MethodDescriptor SET_HTML_DIRECTIONAL = new MethodDescriptor("com/google/gwt/user/client/ui/HasDirectionalSafeHtml", "setHTML", "(Lcom/google/gwt/safehtml/shared/SafeHtml;Lcom/google/gwt/i18n/client/HasDirection$Direction;)V", false);
    @SuppressFBWarnings(value={"DMC_DUBIOUS_MAP_COLLECTION"})
    private static final Map<MethodDescriptor, Set<Integer>> GXT_METHODS_WITH_HTML;
    @SuppressFBWarnings(value={"DMC_DUBIOUS_MAP_COLLECTION"})
    private static final Map<MethodDescriptor, Set<Integer>> GXT_CONSTRUCTORS_WITH_HTML;
    private static final Pattern STRING_CLASS_PATTERN;
    private static final String BOOLEAN_BYTECODE_IDENTIFIER = "Z";
    private static final Integer BOOLEAN_BYTECODE_FALSE_VALUE;
    private BugAccumulator bugAccumulator;

    public GwtUnsafeHtml(BugReporter bugReporter) {
        this.bugAccumulator = new BugAccumulator(bugReporter);
    }

    public void visit(Code obj) {
        super.visit(obj);
        this.bugAccumulator.reportAccumulatedBugs();
    }

    @SuppressFBWarnings(value={"BL_BURYING_LOGIC"})
    public void sawOpcode(int seen) {
        Set<Integer> indicesOfHtmlArguments = null;
        if (this.isSetHtmlMethodCall(seen)) {
            this.handleSetHtmlMethodCall();
        } else {
            indicesOfHtmlArguments = this.getIndicesOfHtmlArgumentsForGxtMethodCall(seen);
            if (indicesOfHtmlArguments != null) {
                this.handleGxtMethodWithHtmlCall(indicesOfHtmlArguments);
            } else {
                indicesOfHtmlArguments = this.getIndicesOfHtmlArgumentsForGxtConstructorCall(seen);
                if (indicesOfHtmlArguments != null) {
                    this.handleGxtConstructorWithHtmlCall(indicesOfHtmlArguments);
                } else if (this.isConstructorWithStringAndSafeHtmlAlternativeCall(seen)) {
                    this.handleConstructorWithStringAndSafeHtmlAlternativeCall();
                } else if (this.isSetInnerHtmlMethodCall(seen)) {
                    this.handleSetInnerHtmlMethodCall();
                } else if (this.isFromSafeConstantMethodCall(seen)) {
                    this.handleFromSafeConstantMethodCall();
                } else if (this.isAppendHtmlConstantMethodCall(seen)) {
                    this.handleAppendHtmlConstantMethodCall();
                } else if (this.isReturnFromCellRendererRender(seen)) {
                    this.handleReturnFromCellRendererRender();
                }
            }
        }
    }

    private void handleSetHtmlMethodCall() {
        if (this.suggestSafeHtmlAlternative(XSS_UNSAFE_HTML__SET_HTML) == SafeAlternativeSuggestion.NOT_FOUND) {
            MethodAnnotation safeMethodAnnotation;
            XClass xClassOperand = this.getXClassOperand();
            if (xClassOperand == null) {
                return;
            }
            if (UnsafeStringDetectionUtils.isAssignableTo(xClassOperand, HAS_HTML) && "(Ljava/lang/String;)V".equals(this.getSigConstantOperand())) {
                safeMethodAnnotation = MethodAnnotation.fromMethodDescriptor((MethodDescriptor)SET_HTML);
            } else if (UnsafeStringDetectionUtils.isAssignableTo(xClassOperand, HAS_DIRECTIONAL_HTML) && "(Ljava/lang/String;Lcom/google/gwt/i18n/client/HasDirection$Direction;)V".equals(this.getSigConstantOperand())) {
                safeMethodAnnotation = MethodAnnotation.fromMethodDescriptor((MethodDescriptor)SET_HTML_DIRECTIONAL);
            } else {
                return;
            }
            safeMethodAnnotation.setDescription("METHOD_SAFE_TARGET");
            this.bugAccumulator.accumulateBug(new BugInstance((Detector)this, XSS_UNSAFE_HTML__SET_HTML, 1).addClassAndMethod((PreorderVisitor)this).addCalledMethod((DismantleBytecode)this).add((BugAnnotation)safeMethodAnnotation), (BytecodeScanningDetector)this);
        }
    }

    private void handleConstructorWithStringAndSafeHtmlAlternativeCall() {
        this.suggestSafeHtmlAlternative(XSS_UNSAFE_HTML__CONSTRUCTOR);
    }

    private void handleGxtConstructorWithHtmlCall(Set<Integer> indicesOfHtmlArguments) {
        for (Integer indexOfHtmlArgument : indicesOfHtmlArguments) {
            SignatureParser signatureParser = new SignatureParser(this.getMethodDescriptorOperand().getSignature());
            if (UnsafeStringDetectionUtils.isSafeStringInHtmlContext(this.stack.getStackItem(signatureParser.getSlotsFromTopOfStackForParameter(indexOfHtmlArgument.intValue())))) continue;
            this.bugAccumulator.accumulateBug(new BugInstance((Detector)this, XSS_UNSAFE_HTML__GXT_CONSTRUCTOR, 1).addClassAndMethod((PreorderVisitor)this).addCalledMethod((DismantleBytecode)this), (BytecodeScanningDetector)this);
        }
    }

    private SafeAlternativeSuggestion suggestSafeHtmlAlternative(String bugType) {
        XClass xClassOperand = this.getXClassOperand();
        if (xClassOperand == null) {
            return SafeAlternativeSuggestion.NOT_NEEDED;
        }
        String signature = this.getSigConstantOperand();
        if (this.isAnonymousInnerClass(this.getClassConstantOperand()) && "<init>".equals(this.getNameConstantOperand()) && signature.startsWith("(L" + this.getOuterClassNameFromAnonymousInnerClass(this.getClassConstantOperand()))) {
            signature = this.removeOuterClassParameter(signature);
        }
        SignatureParser parser = new SignatureParser(signature);
        Matcher stringMatcher = STRING_CLASS_PATTERN.matcher(signature);
        boolean foundUnsafeStringWithNoSafeAlternative = false;
        int parameterIndex = 0;
        Iterator iter = parser.parameterSignatureIterator();
        while (iter.hasNext()) {
            String parameter = (String)iter.next();
            if (parameter.contains("java/lang/String")) {
                stringMatcher.find();
                if (!UnsafeStringDetectionUtils.isSafeStringInHtmlContext(this.stack.getStackItem(parser.getSlotsFromTopOfStackForParameter(parameterIndex)))) {
                    MethodDescriptor potentialSafeMethod;
                    if ("<init>".equals(this.getNameConstantOperand())) {
                        MethodDescriptor potentialSafeConstructor;
                        MethodDescriptor constructorWithAsHTMLParam = new MethodDescriptor(this.getClassConstantOperand(), this.getNameConstantOperand(), new StringBuilder(signature).insert(stringMatcher.end() + 1, BOOLEAN_BYTECODE_IDENTIFIER).toString(), false);
                        if (this.hasMethod(xClassOperand, constructorWithAsHTMLParam)) {
                            return SafeAlternativeSuggestion.NOT_NEEDED;
                        }
                        if (parser.getNumParameters() > parameterIndex + 1 && BOOLEAN_BYTECODE_IDENTIFIER.equals(parser.getParameter(parameterIndex + 1)) && !BOOLEAN_BYTECODE_FALSE_VALUE.equals(this.stack.getStackItem(parser.getSlotsFromTopOfStackForParameter(parameterIndex + 1)).getConstant()) && this.accumulateBugIfSafeMethodFound(xClassOperand, potentialSafeConstructor = new MethodDescriptor(this.getClassConstantOperand(), this.getNameConstantOperand(), new StringBuilder(signature).replace(stringMatcher.start(), stringMatcher.end() + 2, "com/google/gwt/safehtml/shared/SafeHtml;").toString(), false), bugType)) {
                            return SafeAlternativeSuggestion.FOUND;
                        }
                    }
                    if (this.accumulateBugIfSafeMethodFound(xClassOperand, potentialSafeMethod = new MethodDescriptor(this.getClassConstantOperand(), this.getNameConstantOperand(), new StringBuilder(signature).replace(stringMatcher.start(), stringMatcher.end(), "com/google/gwt/safehtml/shared/SafeHtml").toString(), false), bugType)) {
                        return SafeAlternativeSuggestion.FOUND;
                    }
                    foundUnsafeStringWithNoSafeAlternative = true;
                }
            }
            ++parameterIndex;
        }
        return foundUnsafeStringWithNoSafeAlternative ? SafeAlternativeSuggestion.NOT_FOUND : SafeAlternativeSuggestion.NOT_NEEDED;
    }

    @SuppressFBWarnings(value={"BL_BURYING_LOGIC"})
    private boolean accumulateBugIfSafeMethodFound(XClass xClassOperand, MethodDescriptor potentialSafeMethod, String bugType) {
        if (this.hasMethod(xClassOperand, potentialSafeMethod)) {
            MethodAnnotation safeMethodAnnotation = MethodAnnotation.fromMethodDescriptor((MethodDescriptor)potentialSafeMethod);
            safeMethodAnnotation.setDescription("METHOD_SAFE_TARGET");
            this.bugAccumulator.accumulateBug(new BugInstance((Detector)this, bugType, 1).addClassAndMethod((PreorderVisitor)this).addCalledMethod((DismantleBytecode)this).add((BugAnnotation)safeMethodAnnotation), (BytecodeScanningDetector)this);
            return true;
        }
        return false;
    }

    private void handleSetInnerHtmlMethodCall() {
        if (!UnsafeStringDetectionUtils.isSafeStringInHtmlContext(this.stack.getStackItem(0))) {
            this.bugAccumulator.accumulateBug(new BugInstance((Detector)this, XSS_UNSAFE_HTML__SET_INNER_HTML, 1).addClassAndMethod((PreorderVisitor)this).addCalledMethod((DismantleBytecode)this), (BytecodeScanningDetector)this);
        }
    }

    private void handleFromSafeConstantMethodCall() {
        if (!UnsafeStringDetectionUtils.isSafeStringInHtmlContext(this.stack.getStackItem(0))) {
            this.bugAccumulator.accumulateBug(new BugInstance((Detector)this, XSS_UNSAFE_HTML__CONSTANT, 1).addClassAndMethod((PreorderVisitor)this).addCalledMethod((DismantleBytecode)this), (BytecodeScanningDetector)this);
        }
    }

    private void handleAppendHtmlConstantMethodCall() {
        if (!UnsafeStringDetectionUtils.isSafeStringInHtmlContext(this.stack.getStackItem(0))) {
            this.bugAccumulator.accumulateBug(new BugInstance((Detector)this, XSS_UNSAFE_HTML__CONSTANT, 1).addClassAndMethod((PreorderVisitor)this).addCalledMethod((DismantleBytecode)this), (BytecodeScanningDetector)this);
        }
    }

    private void handleGxtMethodWithHtmlCall(Set<Integer> indicesOfHtmlArgumentsForGxtMethodCall) {
        SignatureParser signatureParser = new SignatureParser(this.getMethodDescriptorOperand().getSignature());
        for (Integer indexOfHtmlArgumentForGxtMethodCall : indicesOfHtmlArgumentsForGxtMethodCall) {
            boolean stringIsSanitized;
            if (UnsafeStringDetectionUtils.isSafeStringInHtmlContext(this.stack.getStackItem(signatureParser.getSlotsFromTopOfStackForParameter(indexOfHtmlArgumentForGxtMethodCall.intValue()))) || (stringIsSanitized = signatureParser.getNumParameters() > indexOfHtmlArgumentForGxtMethodCall + 1 && BOOLEAN_BYTECODE_IDENTIFIER.equals(signatureParser.getParameter(indexOfHtmlArgumentForGxtMethodCall + 1)) && BOOLEAN_BYTECODE_FALSE_VALUE.equals(this.stack.getStackItem(signatureParser.getSlotsFromTopOfStackForParameter(indexOfHtmlArgumentForGxtMethodCall + 1)).getConstant()))) continue;
            this.bugAccumulator.accumulateBug(new BugInstance((Detector)this, XSS_UNSAFE_HTML__GXT_METHOD, 1).addClassAndMethod((PreorderVisitor)this).addCalledMethod((DismantleBytecode)this), (BytecodeScanningDetector)this);
        }
    }

    private void handleReturnFromCellRendererRender() {
        if (!UnsafeStringDetectionUtils.isSafeStringInHtmlContext(this.stack.getStackItem(0))) {
            this.bugAccumulator.accumulateBug(new BugInstance((Detector)this, XSS_UNSAFE_HTML__CELL_RENDERER, 1).addClassAndMethod((PreorderVisitor)this), (BytecodeScanningDetector)this);
        }
    }

    private boolean hasMethod(XClass xClass, MethodDescriptor method) {
        return UnsafeStringDetectionUtils.findMethod(xClass, method) != null;
    }

    private boolean isSetHtmlMethodCall(int seen) {
        return (seen == 182 || seen == 185) && "setHTML".equals(this.getNameConstantOperand()) && this.getSigConstantOperand().contains("Ljava/lang/String;");
    }

    private boolean isConstructorWithStringAndSafeHtmlAlternativeCall(int seen) {
        XClass xClassOperand = this.getXClassOperand();
        if (xClassOperand == null) {
            return false;
        }
        return seen == 183 && "<init>".equals(this.getNameConstantOperand()) && this.getSigConstantOperand().contains("Ljava/lang/String;") && UnsafeStringDetectionUtils.isAssignableTo(xClassOperand, HAS_SAFE_HTML) && (!this.isAnonymousInnerClass(this.getClassName()) || !"<init>".equals(this.getMethodName()));
    }

    private boolean isAnonymousInnerClass(String className) {
        return className.matches(".*\\$\\d+");
    }

    private String getOuterClassNameFromAnonymousInnerClass(String anonymousInnerClassName) {
        return anonymousInnerClassName.replaceFirst("\\$\\d+", "");
    }

    private String removeOuterClassParameter(String signature) {
        return signature.replaceFirst("L" + this.getOuterClassNameFromAnonymousInnerClass(this.getClassConstantOperand()) + ";", "");
    }

    private boolean isSetInnerHtmlMethodCall(int seen) {
        return seen == 182 && "setInnerHTML".equals(this.getNameConstantOperand()) && "(Ljava/lang/String;)V".equals(this.getSigConstantOperand());
    }

    private boolean isFromSafeConstantMethodCall(int seen) {
        return seen == 184 && "fromSafeConstant".equals(this.getNameConstantOperand()) && "(Ljava/lang/String;)Lcom/google/gwt/safehtml/shared/SafeHtml;".equals(this.getSigConstantOperand());
    }

    private boolean isAppendHtmlConstantMethodCall(int seen) {
        return seen == 182 && "appendHtmlConstant".equals(this.getNameConstantOperand()) && "(Ljava/lang/String;)Lcom/google/gwt/safehtml/shared/SafeHtmlBuilder;".equals(this.getSigConstantOperand());
    }

    private boolean isReturnFromCellRendererRender(int seen) {
        if (seen == 176 && "render".equals(this.getMethodName())) {
            SignatureParser signatureParser = new SignatureParser(this.getMethodDescriptor().getSignature());
            if (UnsafeStringDetectionUtils.isAssignableTo(this.getXClass(), "com/extjs/gxt/ui/client/widget/grid/GridCellRenderer") && signatureParser.getNumParameters() == 7 && this.getMethodDescriptor().getSignature().matches("\\(L.*;Ljava/lang/String;Lcom/extjs/gxt/ui/client/widget/grid/ColumnData;IILcom/extjs/gxt/ui/client/store/ListStore;Lcom/extjs/gxt/ui/client/widget/grid/Grid;\\)Ljava/lang/Object;")) {
                return true;
            }
            if (UnsafeStringDetectionUtils.isAssignableTo(this.getXClass(), "com/netapp/nwf/client/userinterface/item/ItemModelRenderer") && signatureParser.getNumParameters() == 1 && "Ljava/lang/Object;".equals(signatureParser.getReturnTypeSignature())) {
                return true;
            }
        }
        return false;
    }

    private Set<Integer> getIndicesOfHtmlArgumentsForGxtMethodCall(int seen) {
        if (seen != 182 && seen != 184) {
            return null;
        }
        XClass xClassOperand = this.getXClassOperand();
        if (xClassOperand == null) {
            return null;
        }
        for (Map.Entry<MethodDescriptor, Set<Integer>> gxtMethodWithHtml : GXT_METHODS_WITH_HTML.entrySet()) {
            if (!this.getNameConstantOperand().equals(gxtMethodWithHtml.getKey().getName()) || !this.getSigConstantOperand().equals(gxtMethodWithHtml.getKey().getSignature()) || !UnsafeStringDetectionUtils.isAssignableTo(xClassOperand, gxtMethodWithHtml.getKey().getSlashedClassName())) continue;
            return gxtMethodWithHtml.getValue();
        }
        return null;
    }

    private Set<Integer> getIndicesOfHtmlArgumentsForGxtConstructorCall(int seen) {
        if (seen != 183) {
            return null;
        }
        for (Map.Entry<MethodDescriptor, Set<Integer>> gxtConstructorWithHtml : GXT_CONSTRUCTORS_WITH_HTML.entrySet()) {
            if (!this.getNameConstantOperand().equals(gxtConstructorWithHtml.getKey().getName()) || this.isAnonymousInnerClass(this.getClassName()) && "<init>".equals(this.getMethodName())) continue;
            if (this.getClassConstantOperand().equals(gxtConstructorWithHtml.getKey().getSlashedClassName()) && this.getSigConstantOperand().equals(gxtConstructorWithHtml.getKey().getSignature())) {
                return gxtConstructorWithHtml.getValue();
            }
            XClass xClassOperand = this.getXClassOperand();
            if (xClassOperand == null || !this.isAnonymousInnerClass(this.getClassConstantOperand()) || !UnsafeStringDetectionUtils.isAssignableTo(xClassOperand, gxtConstructorWithHtml.getKey().getSlashedClassName()) || !this.removeOuterClassParameter(this.getSigConstantOperand()).equals(gxtConstructorWithHtml.getKey().getSignature())) continue;
            HashSet<Integer> indexesPlusOne = new HashSet<Integer>();
            for (Integer index : gxtConstructorWithHtml.getValue()) {
                indexesPlusOne.add(index + 1);
            }
            return indexesPlusOne;
        }
        return null;
    }

    private static void put(Map<MethodDescriptor, Set<Integer>> map, String className, String methodName, String signature, Integer ... parameterIndexesContainingHtml) {
        map.put(new MethodDescriptor(className, methodName, signature, false), new HashSet<Integer>(Arrays.asList(parameterIndexesContainingHtml)));
    }

    static {
        HashMap<MethodDescriptor, Set<Integer>> unsafeGxtMethods = new HashMap<MethodDescriptor, Set<Integer>>();
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/desktop/client/Shortcut", "setText", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/desktop/client/StartMenu", "setHeading", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/desktop/client/TaskBar", "setStartButtonText", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/core/El", "setInnerHtml", "(Ljava/lang/String;)Lcom/extjs/gxt/ui/client/core/El;", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/core/El", "update", "(Ljava/lang/String;)Lcom/extjs/gxt/ui/client/core/El;", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/core/El", "mask", "(Ljava/lang/String;)Lcom/extjs/gxt/ui/client/core/El;", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/core/El", "mask", "(Ljava/lang/String;Ljava/lang/String;)Lcom/extjs/gxt/ui/client/core/El;", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/dnd/StatusProxy", "update", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/js/JsUtil", "eval", "(Ljava/lang/String;)Lcom/google/gwt/core/client/JavaScriptObject;", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/widget/AriaSupport", "setDescription", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/widget/Component", "mask", "(Ljava/lang/String;Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/widget/Component", "setToolTip", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/widget/ContentPanel", "setHeading", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/widget/DatePicker$DatePickerMessages", "setMonthYearText", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/widget/DatePicker$DatePickerMessages", "setNextText", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/widget/DatePicker$DatePickerMessages", "setPrevText", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/widget/DatePicker$DatePickerMessages", "setTodayTip", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/widget/Header", "setText", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/widget/Html", "setHtml", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/widget/LayoutContainer", "addText", "(Ljava/lang/String;)Lcom/extjs/gxt/ui/client/widget/Html;", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/widget/ListView", "setLoadingText", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/widget/MessageBox", "setTitle", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/widget/MessageBox", "setMessage", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/widget/MessageBox", "alert", "(Ljava/lang/String;Ljava/lang/String;Lcom/extjs/gxt/ui/client/event/Listener;)Lcom/extjs/gxt/ui/client/widget/MessageBox;", 0, 1);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/widget/MessageBox", "confirm", "(Ljava/lang/String;Ljava/lang/String;Lcom/extjs/gxt/ui/client/event/Listener;)Lcom/extjs/gxt/ui/client/widget/MessageBox;", 0, 1);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/widget/MessageBox", "info", "(Ljava/lang/String;Ljava/lang/String;Lcom/extjs/gxt/ui/client/event/Listener;)Lcom/extjs/gxt/ui/client/widget/MessageBox;", 0, 1);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/widget/MessageBox", "progress", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Lcom/extjs/gxt/ui/client/widget/MessageBox;", 0, 1);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/widget/MessageBox", "prompt", "(Ljava/lang/String;Ljava/lang/String;ZLcom/extjs/gxt/ui/client/event/Listener;)Lcom/extjs/gxt/ui/client/widget/MessageBox;", 0, 1);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/widget/MessageBox", "prompt", "(Ljava/lang/String;Ljava/lang/String;Z)Lcom/extjs/gxt/ui/client/widget/MessageBox;", 0, 1);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/widget/MessageBox", "prompt", "(Ljava/lang/String;Ljava/lang/String;Lcom/extjs/gxt/ui/client/event/Listener;)Lcom/extjs/gxt/ui/client/widget/MessageBox;", 0, 1);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/widget/MessageBox", "prompt", "(Ljava/lang/String;Ljava/lang/String;)Lcom/extjs/gxt/ui/client/widget/MessageBox;", 0, 1);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/widget/MessageBox", "wait", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Lcom/extjs/gxt/ui/client/widget/MessageBox;", 0, 1);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/widget/Slider", "setMessage", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/widget/Status", "setText", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/widget/Status", "clearStatus", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/widget/Status", "setBusy", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/widget/Status", "setStatus", "(Ljava/lang/String;Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/widget/Text", "setText", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/widget/Window", "setHeading", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/widget/button/Button", "setText", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/widget/flash/FlashComponent", "setSwfId", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/widget/form/CheckBox", "setBoxLabel", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/widget/form/Field", "setFieldLabel", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/widget/form/Field", "setLabelSeparator", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/widget/form/LabelField", "setText", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/widget/form/LabelField", "setValue", "(Ljava/lang/Object,)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/widget/grid/GridView", "setEmptyText", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/widget/grid/ColumnHeader$Group", "setText", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/widget/grid/ColumnHeader$Head", "setHeader", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/widget/grid/HeaderGroupConfig", "setHtml", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/widget/menu/HeaderMenuItem", "setText", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/widget/menu/MenuBarItem", "setText", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/widget/menu/MenuItem", "setText", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/widget/tips/ToolTipConfig", "setText", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/widget/tips/ToolTipConfig", "setTitle", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/widget/toolbar/LabelToolItem", "setLabel", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/widget/toolbar/PagingToolBar$PagingToolBarMessages", "setFirstText", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/widget/toolbar/PagingToolBar$PagingToolBarMessages", "setLastText", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/widget/toolbar/PagingToolBar$PagingToolBarMessages", "setNextText", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/widget/toolbar/PagingToolBar$PagingToolBarMessages", "setPrevText", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/extjs/gxt/ui/client/widget/toolbar/PagingToolBar$PagingToolBarMessages", "setRefreshText", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/sencha/gxt/core/client/dom/CompositeElement", "setInnerHtml", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/sencha/gxt/core/client/dom/XDOM", "create", "(Ljava/lang/String;)Lcom/sencha/gxt/core/client/dom/XElement", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/sencha/gxt/core/client/dom/XElement", "createChild", "(Ljava/lang/String;)Lcom/sencha/gxt/core/client/dom/XElement", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/sencha/gxt/widget/core/client/button/ButtonGroup/ButtonGroupAppearance", "updateText", "(Lcom/sencha/gxt/core/client/dom/XElement;Ljava/lang/String;)V", 1);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/sencha/gxt/widget/core/client/button/ButtonGroup", "setHeadingText", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/sencha/gxt/cell/core/client/form/CheckBoxCell/CheckBoxAppearance", "setBoxLabel", "(Ljava/lang/String;Lcom/sencha/gxt/core/client/dom/XElement;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/sencha/gxt/cell/core/client/form/CheckBoxCell", "setBoxLabel", "(Lcom/sencha/gxt/core/client/dom/XElement;Ljava/lang/String;)V", 1);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/sencha/gxt/widget/core/client/form/CheckBox", "setBoxLabel", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/sencha/gxt/widget/core/client/form/FieldLabel/FieldLabelOptions", "setLabelSeparator", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/sencha/gxt/theme/base/client/statusproxy/StatusProxyBaseAppearance", "update", "(Lcom/google/gwt/dom/client/Element;Ljava/lang/String;)V", 1);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/sencha/gxt/dnd/core/client/StatusProxy", "update", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/sencha/gxt/dnd/core/client/DragSource", "setStatusText", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/sencha/gxt/theme/base/client/tips/TipDefaultAppearance", "updateContent", "(Lcom/sencha/gxt/core/client/dom/XElement;Ljava/lang/String;Ljava/lang/String;)V", 1, 2);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/sencha/gxt/widget/core/client/tips/ToolTipConfig", "setTitleHtml", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/sencha/gxt/widget/core/client/tips/ToolTipConfig", "setBodyHtml", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/sencha/gxt/theme/base/client/widget/DatePickerBaseAppearance", "onMonthButtonTextChange", "(Lcom/sencha/gxt/core/client/dom/XElement;Ljava/lang/String;)V", 1);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/sencha/gxt/theme/base/client/widget/DatePickerBaseAppearance", "onTextChange", "(Lcom/google/gwt/dom/client/Element;Ljava/lang/String;)V", 1);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/sencha/gxt/theme/base/client/widget/DatePickerBaseAppearance", "onUpdateDayOfWeeks", "(Lcom/sencha/gxt/core/client/dom/XElement;Ljava/util/List;)V", 1);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/sencha/gxt/widget/core/client/Header", "setText", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/sencha/gxt/widget/core/client/ListView", "setLoadingText", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/sencha/gxt/widget/core/client/grid/GridView/GridAppearance", "renderEmptyContent", "(Ljava/lang/String;)Lcom/google/gwt/safehtml/shared/SafeHtml;", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/sencha/gxt/widget/core/client/grid/GridView", "setEmptyText", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/sencha/gxt/widget/core/client/box/MessageBox", "setMessage", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/sencha/gxt/widget/core/client/form/FieldSet", "setHeadingHtml", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/sencha/gxt/widget/core/client/grid/ColumnHeader/Group", "setText", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/sencha/gxt/widget/core/client/toolbar/LabelToolItem", "setLabel", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/sencha/gxt/core/client/dom/DomHelper", "append", "(Lcom/google/gwt/dom/client/Element;Ljava/lang/String;)Lcom/google/gwt/dom/client/Element;", 1);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/sencha/gxt/core/client/dom/DomHelper", "insertAfter", "(Lcom/google/gwt/dom/client/Element;Ljava/lang/String;)Lcom/google/gwt/dom/client/Element;", 1);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/sencha/gxt/core/client/dom/DomHelper", "insertBefore", "(Lcom/google/gwt/dom/client/Element;Ljava/lang/String;)Lcom/google/gwt/dom/client/Element;", 1);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/sencha/gxt/core/client/dom/DomHelper", "insertFirst", "(Lcom/google/gwt/dom/client/Element;Ljava/lang/String;)Lcom/google/gwt/dom/client/Element;", 1);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/sencha/gxt/core/client/dom/DomHelper", "insertHtml", "(Ljava/lang/String;Lcom/google/gwt/dom/client/Element;Ljava/lang/String;)Lcom/google/gwt/dom/client/Element;", 2);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/sencha/gxt/core/client/dom/DomHelper", "overwrite", "(Lcom/google/gwt/dom/client/Element;Ljava/lang/String;)Lcom/google/gwt/dom/client/Element;", 1);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/sencha/gxt/core/client/dom/XElement", "insertFirst", "(Ljava/lang/String;)Lcom/sencha/gxt/core/client/dom/XElement;", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/sencha/gxt/core/client/dom/XElement", "insertHtml", "(Ljava/lang/String;Ljava/lang/String;)Lcom/sencha/gxt/core/client/dom/XElement;", 1);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/sencha/gxt/widget/core/client/ContentPanel", "setHeadingHtml", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtMethods, "com/sencha/gxt/theme/base/client/menu/MenuItemBaseAppearance", "setText", "(Lcom/sencha/gxt/core/client/dom/XElement;Ljava/lang/String;Z)V", 1);
        GXT_METHODS_WITH_HTML = Collections.unmodifiableMap(unsafeGxtMethods);
        HashMap<MethodDescriptor, Set<Integer>> unsafeGxtConstructors = new HashMap<MethodDescriptor, Set<Integer>>();
        GwtUnsafeHtml.put(unsafeGxtConstructors, "com/extjs/gxt/desktop/client/Shortcut", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", 1);
        GwtUnsafeHtml.put(unsafeGxtConstructors, "com/extjs/gxt/ui/client/widget/Html", "<init>", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtConstructors, "com/extjs/gxt/ui/client/widget/InfoConfig", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtConstructors, "com/extjs/gxt/ui/client/widget/InfoConfig", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcom/extjs/gxt/ui/client/util/Params;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtConstructors, "com/extjs/gxt/ui/client/widget/Label", "<init>", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtConstructors, "com/extjs/gxt/ui/client/widget/Text", "<init>", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtConstructors, "com/extjs/gxt/ui/client/widget/button/Button", "<init>", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtConstructors, "com/extjs/gxt/ui/client/widget/button/Button", "<init>", "(Ljava/lang/String;Lcom/extjs/gxt/ui/client/event/SelectionListener;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtConstructors, "com/extjs/gxt/ui/client/widget/button/Button", "<init>", "(Ljava/lang/String;Lcom/google/gwt/user/client/ui/AbstractImagePrototype;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtConstructors, "com/extjs/gxt/ui/client/widget/button/Button", "<init>", "(Ljava/lang/String;Lcom/google/gwt/user/client/ui/AbstractImagePrototype;Lcom/extjs/gxt/ui/client/event/SelectionListener;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtConstructors, "com/extjs/gxt/ui/client/widget/form/LabelField", "<init>", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtConstructors, "com/extjs/gxt/ui/client/widget/grid/ColumnConfig", "<init>", "(Ljava/lang/String;Ljava/lang/String;I)V", 1);
        GwtUnsafeHtml.put(unsafeGxtConstructors, "com/extjs/gxt/ui/client/widget/grid/HeaderGroupConfig", "<init>", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtConstructors, "com/extjs/gxt/ui/client/widget/grid/HeaderGroupConfig", "<init>", "(Ljava/lang/String;II)V", 0);
        GwtUnsafeHtml.put(unsafeGxtConstructors, "com/extjs/gxt/ui/client/widget/menu/CheckMenuItem", "<init>", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtConstructors, "com/extjs/gxt/ui/client/widget/menu/HeaderMenuItem", "<init>", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtConstructors, "com/extjs/gxt/ui/client/widget/menu/MenuItem", "<init>", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtConstructors, "com/extjs/gxt/ui/client/widget/menu/MenuItem", "<init>", "(Ljava/lang/String;Lcom/extjs/gxt/ui/client/event/SelectionListener;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtConstructors, "com/extjs/gxt/ui/client/widget/menu/MenuItem", "<init>", "(Ljava/lang/String;Lcom/google/gwt/user/client/ui/AbstractImagePrototype;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtConstructors, "com/extjs/gxt/ui/client/widget/menu/MenuItem", "<init>", "(Ljava/lang/String;Lcom/google/gwt/user/client/ui/AbstractImagePrototype;Lcom/extjs/gxt/ui/client/event/SelectionListener;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtConstructors, "com/extjs/gxt/ui/client/widget/menu/MenuBarItem", "<init>", "(Ljava/lang/String;Lcom/extjs/gxt/ui/client/widget/menu/Menu;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtConstructors, "com/extjs/gxt/ui/client/widget/tips/ToolTipConfig", "<init>", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtConstructors, "com/extjs/gxt/ui/client/widget/tips/ToolTipConfig", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", 0, 1);
        GwtUnsafeHtml.put(unsafeGxtConstructors, "com/extjs/gxt/ui/client/widget/toolbar/LabelToolItem", "<init>", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtConstructors, "com/sencha/gxt/widget/core/client/box/MessageBox", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcom/sencha/gxt/widget/core/client/Window$WindowAppearance;Lcom/sencha/gxt/widget/core/client/box/MessageBox$MessageBoxAppearance;)V", 0, 1);
        GwtUnsafeHtml.put(unsafeGxtConstructors, "com/sencha/gxt/widget/core/client/box/MessageBox", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", 0, 1);
        GwtUnsafeHtml.put(unsafeGxtConstructors, "com/sencha/gxt/widget/core/client/box/MessageBox", "<init>", "(Ljava/lang/String;)V", 0);
        GwtUnsafeHtml.put(unsafeGxtConstructors, "com/sencha/gxt/widget/core/client/box/AlertMessageBox", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", 0, 1);
        GwtUnsafeHtml.put(unsafeGxtConstructors, "com/sencha/gxt/widget/core/client/box/ConfirmMessageBox", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", 0, 1);
        GwtUnsafeHtml.put(unsafeGxtConstructors, "com/sencha/gxt/widget/core/client/container/HtmlLayoutContainer", "<init>", "(Ljava/lang/String;)V", 0);
        GXT_CONSTRUCTORS_WITH_HTML = Collections.unmodifiableMap(unsafeGxtConstructors);
        STRING_CLASS_PATTERN = Pattern.compile("java/lang/String");
        BOOLEAN_BYTECODE_FALSE_VALUE = 0;
    }

    private static enum SafeAlternativeSuggestion {
        FOUND,
        NOT_FOUND,
        NOT_NEEDED;

    }
}

