/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.axx.findbugs.xss;

import com.netapp.axx.findbugs.xss.UnsafeStringDetectionUtils;
import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.classfile.Code;

public class GwtUnsafeUri
extends OpcodeStackDetector {
    private static final String XSS_UNSAFE_URI = "XSS_UNSAFE_URI";
    private static final String XSS_UNSAFE_URI__CONSTANT = "XSS_UNSAFE_URI__CONSTANT";
    private static final Set<String> METHODS_TAKING_SINGLE_ARGUMENT_URI = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("setHref", "setSrc")));
    private BugAccumulator bugAccumulator;

    public GwtUnsafeUri(BugReporter bugReporter) {
        this.bugAccumulator = new BugAccumulator(bugReporter);
    }

    public void visit(Code obj) {
        super.visit(obj);
        this.bugAccumulator.reportAccumulatedBugs();
    }

    public void sawOpcode(int seen) {
        String bugType = null;
        if (this.isCallToMethodTakingSingleArgumentUri(seen) || this.isCallToAddSourceMethodWithOneArgs(seen)) {
            if (!UnsafeStringDetectionUtils.isSafeStringInUriContext(this.stack.getStackItem(0))) {
                bugType = XSS_UNSAFE_URI;
            }
        } else if (this.isCallToAddSourceMethodWithTwoArgs(seen)) {
            if (!UnsafeStringDetectionUtils.isSafeStringInUriContext(this.stack.getStackItem(1))) {
                bugType = XSS_UNSAFE_URI;
            }
        } else if (this.isCallToFromSafeConstant(seen) && !UnsafeStringDetectionUtils.isSafeStringInUriContext(this.stack.getStackItem(0))) {
            bugType = XSS_UNSAFE_URI__CONSTANT;
        }
        if (bugType != null) {
            this.bugAccumulator.accumulateBug(new BugInstance((Detector)this, XSS_UNSAFE_URI, 1).addClassAndMethod((PreorderVisitor)this).addCalledMethod((DismantleBytecode)this), (BytecodeScanningDetector)this);
        }
    }

    public boolean isCallToMethodTakingSingleArgumentUri(int seen) {
        XClass xClassOperand = this.getXClassOperand();
        return seen == 182 && xClassOperand != null && "(Ljava/lang/String;)V".equals(this.getSigConstantOperand()) && METHODS_TAKING_SINGLE_ARGUMENT_URI.contains(this.getNameConstantOperand()) && (UnsafeStringDetectionUtils.isAssignableTo(xClassOperand, "com/google/gwt/dom/client/Element") || UnsafeStringDetectionUtils.isAssignableTo(xClassOperand, "com/google/gwt/user/client/ui/UIObject"));
    }

    public boolean isCallToAddSourceMethodWithOneArgs(int seen) {
        XClass xClassOperand = this.getXClassOperand();
        return seen == 182 && xClassOperand != null && "(Ljava/lang/String;)Lcom/google/gwt/dom/client/SourceElement;".equals(this.getSigConstantOperand()) && "addSource".equals(this.getNameConstantOperand()) && UnsafeStringDetectionUtils.isAssignableTo(xClassOperand, "com/google/gwt/media/client/MediaBase");
    }

    public boolean isCallToAddSourceMethodWithTwoArgs(int seen) {
        XClass xClassOperand = this.getXClassOperand();
        return seen == 182 && xClassOperand != null && "(Ljava/lang/String;Ljava/lang/String;)Lcom/google/gwt/dom/client/SourceElement;".equals(this.getSigConstantOperand()) && "addSource".equals(this.getNameConstantOperand()) && UnsafeStringDetectionUtils.isAssignableTo(xClassOperand, "com/google/gwt/media/client/MediaBase");
    }

    private boolean isCallToFromSafeConstant(int seen) {
        return seen == 184 && "fromSafeConstant".equals(this.getNameConstantOperand()) && "com/google/gwt/safehtml/shared/UriUtils".equals(this.getClassConstantOperand()) && "(Ljava/lang/String;)Lcom/google/gwt/safehtml/shared/SafeUri;".equals(this.getSigConstantOperand());
    }
}

