/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.axx.findbugs.xss;

import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.classfile.UncheckedAnalysisException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.bcel.classfile.JavaClass;

public class UnsafeStringDetectionUtils {
    public static final String SAFE_HTML = "com/google/gwt/safehtml/shared/SafeHtml";
    public static final String SAFE_HTML_UTILS = "com/google/gwt/safehtml/shared/SafeHtmlUtils";
    public static final String NWF_SAFE_HTML_UTILS = "com/netapp/nwf/shared/safehtml/NwfSafeHtmlUtils";
    public static final String NWF_HTML_SANITIZER = "com/netapp/nwf/shared/safehtml/NwfHtmlSanitizer";
    public static final String SAFE_URI = "com/google/gwt/safehtml/shared/SafeUri";
    public static final String URI_UTILS = "com/google/gwt/safehtml/shared/UriUtils";
    private static final Pattern SAFE_CONSTANT_METHOD_SIGNATURE_PATTERN = Pattern.compile("\\([^L]*\\)Ljava/lang/String;");
    private static final Set<MethodDescriptor> METHODS_RETURNING_SAFE_HTML_STRINGS = Collections.unmodifiableSet(new HashSet<MethodDescriptor>(Arrays.asList(new MethodDescriptor("com/google/gwt/safehtml/shared/SafeHtmlUtils", "htmlEscape", "(Ljava/lang/String;)Ljava/lang/String;", true), new MethodDescriptor("com/google/gwt/safehtml/shared/SafeHtmlUtils", "htmlEscapeAllowEntities", "(Ljava/lang/String;)Ljava/lang/String;", true), new MethodDescriptor("com/netapp/nwf/shared/safehtml/NwfSafeHtmlUtils", "htmlEscape", "(Ljava/lang/String;)Ljava/lang/String;", true), new MethodDescriptor("com/netapp/nwf/shared/safehtml/NwfSafeHtmlUtils", "htmlEscapeAllowEntities", "(Ljava/lang/String;)Ljava/lang/String;", true), new MethodDescriptor("com/netapp/nwf/shared/safehtml/NwfHtmlSanitizer", "sanitizeString", "(Ljava/lang/String;)Ljava/lang/String;", true), new MethodDescriptor("com/google/gwt/safehtml/shared/SafeHtml", "asString", "()Ljava/lang/String;", false))));
    private static final Set<MethodDescriptor> METHODS_RETURNING_SAFE_URI_STRINGS = Collections.unmodifiableSet(new HashSet<MethodDescriptor>(Arrays.asList(new MethodDescriptor("com/google/gwt/safehtml/shared/UriUtils", "sanitizeUri", "(Ljava/lang/String;)Ljava/lang/String;", true), new MethodDescriptor("com/google/gwt/safehtml/shared/SafeUri", "asString", "()Ljava/lang/String;", false))));

    private UnsafeStringDetectionUtils() {
    }

    public static boolean isAssignableTo(XClass xClass, String interfaceName) {
        if ("java/lang/Object".equals(xClass.getClassDescriptor().getClassName())) {
            return false;
        }
        if (interfaceName.equals(xClass.getClassDescriptor().getClassName())) {
            return true;
        }
        try {
            for (ClassDescriptor interfaceDescriptor : xClass.getInterfaceDescriptorList()) {
                if (!UnsafeStringDetectionUtils.isAssignableTo(interfaceDescriptor.getXClass(), interfaceName)) continue;
                return true;
            }
            ClassDescriptor superclassDescriptor = xClass.getSuperclassDescriptor();
            if (superclassDescriptor == null) {
                throw new UncheckedAnalysisException("Unable to get superclass descriptor of " + xClass);
            }
            return UnsafeStringDetectionUtils.isAssignableTo(superclassDescriptor.getXClass(), interfaceName);
        }
        catch (CheckedAnalysisException e) {
            throw new UncheckedAnalysisException("Unable to get superclass descriptor of " + xClass, (Throwable)e);
        }
    }

    public static boolean isAssignableTo(JavaClass javaClass, String interfaceName) {
        if (javaClass == null || "java.lang.Object".equals(javaClass.getClassName())) {
            return false;
        }
        if (interfaceName.replace('/', '.').equals(javaClass.getClassName())) {
            return true;
        }
        try {
            for (JavaClass javaInterface : javaClass.getInterfaces()) {
                if (!UnsafeStringDetectionUtils.isAssignableTo(javaInterface, interfaceName)) continue;
                return true;
            }
        }
        catch (ClassNotFoundException e) {
            throw new UncheckedAnalysisException("Unable to get interface of " + javaClass, (Throwable)e);
        }
        try {
            return UnsafeStringDetectionUtils.isAssignableTo(javaClass.getSuperClass(), interfaceName);
        }
        catch (ClassNotFoundException e) {
            throw new UncheckedAnalysisException("Unable to get superclass of " + javaClass, (Throwable)e);
        }
    }

    public static MethodDescriptor findMethod(XClass xClass, MethodDescriptor method) {
        if ("java/lang/Object".equals(xClass.getClassDescriptor().getClassName())) {
            return null;
        }
        XMethod matchingMethod = xClass.findMatchingMethod(method);
        if (matchingMethod != null) {
            return matchingMethod.getMethodDescriptor();
        }
        try {
            ClassDescriptor superclassDescriptor = xClass.getSuperclassDescriptor();
            if (superclassDescriptor == null) {
                throw new UncheckedAnalysisException("Unable to get superclass descriptor of " + xClass);
            }
            return UnsafeStringDetectionUtils.findMethod(superclassDescriptor.getXClass(), method);
        }
        catch (CheckedAnalysisException e) {
            throw new UncheckedAnalysisException("Unable to get superclass descriptor of " + xClass, (Throwable)e);
        }
    }

    public static boolean isSafeStringInHtmlContext(OpcodeStack.Item stackItem) {
        if (UnsafeStringDetectionUtils.isSafeStringInAnyContext(stackItem)) {
            return true;
        }
        XMethod returnValueOf = stackItem.getReturnValueOf();
        return returnValueOf != null && METHODS_RETURNING_SAFE_HTML_STRINGS.contains(returnValueOf.getMethodDescriptor());
    }

    public static boolean isSafeStringInUriContext(OpcodeStack.Item stackItem) {
        if (UnsafeStringDetectionUtils.isSafeStringInAnyContext(stackItem)) {
            return true;
        }
        XMethod returnValueOf = stackItem.getReturnValueOf();
        return returnValueOf != null && METHODS_RETURNING_SAFE_URI_STRINGS.contains(returnValueOf.getMethodDescriptor());
    }

    private static boolean isSafeStringInAnyContext(OpcodeStack.Item stackItem) {
        try {
            if (UnsafeStringDetectionUtils.isAssignableTo(stackItem.getJavaClass(), "java/util/List")) {
                return false;
            }
        }
        catch (ClassNotFoundException e1) {
            throw new UncheckedAnalysisException("Could not load class for item " + stackItem.getSignature(), (Throwable)e1);
        }
        if (!"Ljava/lang/String;".equals(stackItem.getSignature())) {
            return true;
        }
        if (stackItem.getConstant() != null) {
            return true;
        }
        XMethod returnValueOf = stackItem.getReturnValueOf();
        if (returnValueOf != null) {
            try {
                if (SAFE_CONSTANT_METHOD_SIGNATURE_PATTERN.matcher(returnValueOf.getMethodDescriptor().getSignature()).matches() && (UnsafeStringDetectionUtils.isAssignableTo(returnValueOf.getMethodDescriptor().getClassDescriptor().getXClass(), "com/google/gwt/i18n/client/Messages") || UnsafeStringDetectionUtils.isAssignableTo(returnValueOf.getMethodDescriptor().getClassDescriptor().getXClass(), "com/google/gwt/i18n/client/Constants"))) {
                    return true;
                }
            }
            catch (CheckedAnalysisException checkedAnalysisException) {
                // empty catch block
            }
        }
        return false;
    }
}

