/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.collectors.vmware;

import com.netapp.collectors.vmware.IVMWareContext;
import com.netapp.collectors.vmware.ServiceConnection25;
import com.netapp.collectors.vmware.logger.LogsManager;
import com.netapp.collectors.vmware.util.TimeUtil;
import com.vmware.vim25.ServiceContent;
import java.util.concurrent.TimeUnit;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.XMLGregorianCalendar;
import org.slf4j.Logger;

public class VMWare25Context
implements IVMWareContext {
    private static final Logger logger = LogsManager.getLogger(VMWare25Context.class);
    private String vimPackage;
    private boolean isEmbeddedEsx;
    private boolean isEsx;
    private ServiceConnection25 serviceConnection;
    private ServiceContent serviceContent;
    private Integer vcInstanceId;
    private XMLGregorianCalendar currentTime = null;
    private XMLGregorianCalendar sampleStartTime = null;
    private XMLGregorianCalendar sampleEndTime = null;
    private long accessHandleId;
    private long startTime;
    private long endTime;
    private String vcUrl;
    private String vCenterHostNameOrIp;

    public VMWare25Context(ServiceConnection25 serviceConnection, ServiceContent serviceContent, String vimPackage, boolean isEmbeddedEsx, boolean isEsx, long accessHandleId, XMLGregorianCalendar now) {
        this.serviceConnection = serviceConnection;
        this.serviceContent = serviceContent;
        this.vimPackage = vimPackage;
        this.isEmbeddedEsx = isEmbeddedEsx;
        this.isEsx = isEsx;
        this.accessHandleId = accessHandleId;
        this.currentTime = now;
        this.initializeStartAndEndTime();
    }

    public VMWare25Context(ServiceConnection25 serviceConnection, ServiceContent serviceContent, long accessHandleId) {
        this.serviceConnection = serviceConnection;
        this.serviceContent = serviceContent;
        this.accessHandleId = accessHandleId;
    }

    public VMWare25Context(ServiceConnection25 serviceConnection, ServiceContent serviceContent, String vimPackage, boolean isEmbeddedEsx, boolean isEsx, Integer vcInstanceId, long accessHandleId, XMLGregorianCalendar now, String url, String vCenterHostNameOrIp) {
        this.serviceConnection = serviceConnection;
        this.serviceContent = serviceContent;
        this.vimPackage = vimPackage;
        this.isEmbeddedEsx = isEmbeddedEsx;
        this.isEsx = isEsx;
        this.vcInstanceId = vcInstanceId;
        this.accessHandleId = accessHandleId;
        this.currentTime = now;
        this.vcUrl = url;
        this.vCenterHostNameOrIp = vCenterHostNameOrIp;
        this.initializeStartAndEndTime();
    }

    private void initializeStartAndEndTime() {
        if (this.currentTime == null) {
            logger.error("Vcenter server time is unavailable, unable to intialize the start and end time");
            return;
        }
        long epoch = this.currentTime.toGregorianCalendar().getTimeInMillis();
        long serverModFive = epoch - epoch % TimeUnit.SECONDS.toMillis(300L);
        long sampleEndTimeEpoch = serverModFive - TimeUnit.SECONDS.toMillis(300L);
        long sampleStartTimeEpoch = serverModFive - TimeUnit.SECONDS.toMillis(600L);
        try {
            this.sampleStartTime = TimeUtil.toXMLGregorianCalendar(sampleStartTimeEpoch);
            this.sampleEndTime = TimeUtil.toXMLGregorianCalendar(sampleEndTimeEpoch);
        }
        catch (DatatypeConfigurationException e) {
            logger.error("Error while initializing the start and end time for collection of samples");
        }
    }

    public VMWare25Context(ServiceConnection25 serviceConnection, ServiceContent serviceContent, Integer vcInstanceId, long accessHandleId, XMLGregorianCalendar now) {
        this.serviceConnection = serviceConnection;
        this.serviceContent = serviceContent;
        this.vcInstanceId = vcInstanceId;
        this.accessHandleId = accessHandleId;
        this.currentTime = now;
    }

    @Override
    public long getAccessHandleId() {
        return this.accessHandleId;
    }

    @Override
    public XMLGregorianCalendar getCurrentTime() {
        return this.currentTime;
    }

    @Override
    public Object getConnection() {
        return this.serviceConnection;
    }

    @Override
    public String getVcURL() {
        return this.vcUrl;
    }

    @Override
    public String getvCenterHostNameOrIP() {
        return this.vCenterHostNameOrIp;
    }

    @Override
    public boolean isEmbeddedEsx() {
        return this.isEmbeddedEsx;
    }

    @Override
    public boolean isEsx() {
        return this.isEsx;
    }

    @Override
    public Object getPerformanceManager() {
        return this.serviceContent.getPerfManager();
    }

    @Override
    public Object getOptionManager() {
        return this.serviceContent.getSetting();
    }

    @Override
    public Object getPropertyCollector() {
        return this.serviceConnection.getPropCol();
    }

    @Override
    public Object getServiceContent() {
        return this.serviceContent;
    }

    @Override
    public String getVimPackage() {
        return this.vimPackage;
    }

    @Override
    public Integer getVcInstanceId() {
        return this.vcInstanceId;
    }

    @Override
    public void destroy() {
        try {
            if (this.serviceConnection != null) {
                this.serviceConnection.disconnect();
            }
        }
        catch (Exception e) {
            if (this.serviceConnection != null) {
                logger.warn("An exception occurred attempting to disconnect.", (Throwable)e);
            }
            logger.warn("An exception occurred attempting to disconnect.", (Throwable)e);
        }
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    @Override
    public long getEndTime() {
        return this.endTime;
    }

    @Override
    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    @Override
    public XMLGregorianCalendar getSampleStartTime() {
        return this.sampleStartTime;
    }

    @Override
    public XMLGregorianCalendar getSampleEndTime() {
        return this.sampleEndTime;
    }
}

