/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.collectors.vmware;

import com.netapp.collectors.vmware.VMWareDatastore;
import com.netapp.collectors.vmware.VMWareLUN;
import com.netapp.collectors.vmware.VMWarePhysicalNic;
import com.netapp.collectors.vmware.VMWareResourcePool;
import com.netapp.collectors.vmware.VMWareVirtualMachine;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class VMWareHost {
    private String name;
    private Object managedObject;
    private ArrayList<String> consoleVNicIpAddress = new ArrayList();
    private ArrayList<String> vnicIPAddress = new ArrayList();
    private String productName;
    private String uuid;
    private String powerState;
    private String connectionState;
    private Boolean maintenanceMode;
    private LinkedHashMap<Object, VMWareVirtualMachine> virtualMachines = new LinkedHashMap();
    private LinkedHashMap<Object, VMWareDatastore> dataStores = new LinkedHashMap();
    private LinkedHashMap<String, VMWarePhysicalNic> physicalNics = new LinkedHashMap();
    private VMWareResourcePool rootResourcePool;
    private Map<String, Integer> availablePerfCounters;
    private HashMap<String, VMWareLUN> lunStats;
    private HashMap<String, VMWarePhysicalNic> physicalNicStats = new HashMap();
    private int samplePeriod;
    private String hostName;
    private Object[] scsiLUNArray = new Object[0];
    private Object[] hostFileSystemMountInfo = new Object[0];
    private Object[] hostBusAdapter = new Object[0];
    private int numSamples;
    private long memorySize;
    private long systemUpTime;
    private float memoryUsageAvg;
    private long memorySwapOutAvg;
    private long memorySwapInAvg;
    private float cpuUsageAvg;
    private float cpuUsageMhzAvg;
    private float memoryConsumedAvg;
    private float memoryOverheadAvg;
    private float memoryBalloon;
    private float memoryBalloonTarget;
    private float avgNetworkUsage;
    private int numValidCpuUsageSamples;
    private long cpuHz;
    private int numberOfCpuCores;
    private int numberOfCpuThreads;
    private String productFullName;
    private String esxVersion;
    private String esxBuild;
    private Long effectiveCpu;
    private Long effectiveMemory;
    private Object storageSystemMor;

    public String toString() {
        Object s = "\nVMWareHost:\n";
        s = (String)s + "    Name                : " + this.name + "\n";
        s = (String)s + "    MO                  : " + this.managedObject + "\n";
        s = (String)s + "    Num of console IPs  : " + this.consoleVNicIpAddress.size() + "\n";
        s = (String)s + "    Num of IPs          : " + this.vnicIPAddress.size() + "\n";
        s = (String)s + "    Product Name        : " + this.productName + "\n";
        s = (String)s + "    UUID                : " + this.uuid + "\n";
        s = (String)s + "    Power State         : " + this.powerState + "\n";
        s = (String)s + "    Connection State    : " + this.connectionState + "\n";
        s = (String)s + "    Maintenance Mode    : " + this.maintenanceMode + "\n";
        s = (String)s + "    Num of VMs          : " + this.virtualMachines.size() + "\n";
        s = (String)s + "    Num of DataStores   : " + this.dataStores.size() + "\n";
        s = (String)s + "    Num of Physical NICs: " + this.physicalNics.size() + "\n";
        s = (String)s + "    Root Resource Pool  : " + this.rootResourcePool + "\n";
        s = this.availablePerfCounters != null ? (String)s + "    Size of Avail Cntrs : " + this.availablePerfCounters.size() + "\n" : (String)s + "    Size of Avail Cntrs : null\n";
        s = this.lunStats != null ? (String)s + "    Size of LUN Stats   : " + this.lunStats.size() + "\n" : (String)s + "    Size of LUN Stats   : null";
        s = (String)s + "    Num of PNIC Stats    : " + this.physicalNicStats.size() + "\n";
        s = (String)s + "    Sample Period        : " + this.samplePeriod + "\n";
        s = (String)s + "    Host Name            : " + this.hostName + "\n";
        s = (String)s + "    Num SCSCI LUN Arrays : " + this.scsiLUNArray.length + "\n";
        s = (String)s + "    Num Host File Mnts   : " + this.hostFileSystemMountInfo.length + "\n";
        s = (String)s + "    Num Host Bus Adapters: " + this.hostBusAdapter.length + "\n";
        s = (String)s + "    Numer of Samples     : " + this.numSamples + "\n";
        s = (String)s + "    Memory Size          : " + this.memorySize + "\n";
        s = (String)s + "    System Up Time       : " + this.systemUpTime + "\n";
        s = (String)s + "    Memory Usage Avg     : " + this.memoryUsageAvg + "\n";
        s = (String)s + "    Memory Swap Out Avg  : " + this.memorySwapOutAvg + "\n";
        s = (String)s + "    Memory Swap In Avg   : " + this.memorySwapInAvg + "\n";
        s = (String)s + "    CPU Usage Avg        : " + this.cpuUsageAvg + "\n";
        s = (String)s + "    CPU Used Mhz Avg     : " + this.cpuUsageMhzAvg + "\n";
        s = (String)s + "    Memory Consumed Avg  : " + this.memoryConsumedAvg + "\n";
        s = (String)s + "    Memory Overhead Avg  : " + this.memoryOverheadAvg + "\n";
        s = (String)s + "    Memory Balloon       : " + this.memoryBalloon + "\n";
        s = (String)s + "    Memory Ballon Target : " + this.memoryBalloonTarget + "\n";
        s = (String)s + "    Avg Network Usage    : " + this.avgNetworkUsage + "\n";
        s = (String)s + "    Num Valid CPU Samples: " + this.numValidCpuUsageSamples + "\n";
        s = (String)s + "    CPU Hz               : " + this.cpuHz + "\n";
        s = (String)s + "    Number of CPU Cores  : " + this.numberOfCpuCores + "\n";
        s = (String)s + "    Number of CPU Threads: " + this.numberOfCpuThreads + "\n";
        s = (String)s + "    Product Full Name    : " + this.productFullName + "\n";
        s = (String)s + "    ESX Version          : " + this.esxVersion + "\n";
        s = (String)s + "    ESX Build            : " + this.esxBuild + "\n";
        s = (String)s + "    Effective CPU        : " + this.effectiveCpu + "\n";
        s = (String)s + "    Effective Memory     : " + this.effectiveMemory + "\n";
        s = (String)s + "    Storage System Mor   : " + this.storageSystemMor + "\n";
        return s;
    }

    public VMWareHost(Object managedObject) {
        this.managedObject = managedObject;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getManagedObject() {
        return this.managedObject;
    }

    public void setManagedObjectId(Object managedObject) {
        this.managedObject = managedObject;
    }

    public ArrayList<String> getConsoleVNicIpAddress() {
        return this.consoleVNicIpAddress;
    }

    public void setConsoleVNicIpAddress(ArrayList<String> consoleVNicIpAddress) {
        this.consoleVNicIpAddress = consoleVNicIpAddress;
    }

    public ArrayList<String> getVnicIPAddress() {
        return this.vnicIPAddress;
    }

    public void setVnicIPAddress(ArrayList<String> nicIPAddress) {
        this.vnicIPAddress = nicIPAddress;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public LinkedHashMap<Object, VMWareVirtualMachine> getAllVirtualMachines() {
        return this.virtualMachines;
    }

    public void setAllVirtualMachines(LinkedHashMap<Object, VMWareVirtualMachine> allVirtualMachines) {
        this.virtualMachines = allVirtualMachines;
    }

    public VMWareVirtualMachine getVirtualMachine(Object key) {
        return this.virtualMachines.get(key);
    }

    public void putVirtualMachine(Object key, VMWareVirtualMachine virtualMachine) {
        this.virtualMachines.put(key, virtualMachine);
    }

    public VMWareDatastore getDatastore(Object key) {
        return this.dataStores.get(key);
    }

    public void putDataStore(Object key, VMWareDatastore dataStore) {
        this.dataStores.put(key, dataStore);
    }

    public LinkedHashMap<Object, VMWareDatastore> getAllDataStores() {
        return this.dataStores;
    }

    public void setAllDataStores(LinkedHashMap<Object, VMWareDatastore> allDataStores) {
        this.dataStores = allDataStores;
    }

    public Map<String, Integer> getAvailablePerfCounters() {
        return this.availablePerfCounters;
    }

    public void setAvailablePerfCounters(Map<String, Integer> availablePerfCounters) {
        this.availablePerfCounters = availablePerfCounters;
    }

    public int getSamplePeriod() {
        return this.samplePeriod;
    }

    public void setSamplePeriod(int samplePeriod) {
        this.samplePeriod = samplePeriod;
    }

    public Object[] getAllScsiLUNs() {
        return this.scsiLUNArray;
    }

    public Object getScsiLUN(int i) {
        return this.scsiLUNArray[i];
    }

    public void setAllScsiLUNs(Object[] scsiLUNArray) {
        this.scsiLUNArray = scsiLUNArray;
    }

    public Object[] getHostFileSystemMountInfo() {
        return this.hostFileSystemMountInfo;
    }

    public void setHostFileSystemMountInfo(Object[] hostFileSystemMountInfo) {
        this.hostFileSystemMountInfo = hostFileSystemMountInfo;
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public void setNumSamples(int numSamples) {
        this.numSamples = numSamples;
    }

    public long getMemorySize() {
        return this.memorySize;
    }

    public void setMemorySize(long memorySize) {
        this.memorySize = memorySize;
    }

    public VMWareLUN getLunStats(String conanicalName) {
        if (this.lunStats != null) {
            return this.lunStats.get(conanicalName);
        }
        return null;
    }

    public void setLunStats(HashMap<String, VMWareLUN> lunStats) {
        this.lunStats = lunStats;
    }

    public long getSystemUpTime() {
        return this.systemUpTime;
    }

    public void setSystemUpTime(long systemUpTime) {
        this.systemUpTime = systemUpTime;
    }

    public float getMemoryUsageAvg() {
        return this.memoryUsageAvg;
    }

    public void setMemoryUsageAvg(float memoryUsageAvg) {
        this.memoryUsageAvg = memoryUsageAvg;
    }

    public long getMemorySwapOutAvg() {
        return this.memorySwapOutAvg;
    }

    public void setMemorySwapOutAvg(long memorySwapOutAvg) {
        this.memorySwapOutAvg = memorySwapOutAvg;
    }

    public long getMemorySwapInAvg() {
        return this.memorySwapInAvg;
    }

    public void setMemorySwapInAvg(long memorySwapInAvg) {
        this.memorySwapInAvg = memorySwapInAvg;
    }

    public float getCpuUsageAvg() {
        return this.cpuUsageAvg;
    }

    public void setCpuUsageAvg(float cpuUsageAvg) {
        this.cpuUsageAvg = cpuUsageAvg;
    }

    public float getCpuUsageMhzAvg() {
        return this.cpuUsageMhzAvg;
    }

    public void setCpuUsageMhzAvg(float cpuUsageMhzAvg) {
        this.cpuUsageMhzAvg = cpuUsageMhzAvg;
    }

    public float getMemoryConsumedAvg() {
        return this.memoryConsumedAvg;
    }

    public void setMemoryConsumedAvg(float memoryConsumedAvg) {
        this.memoryConsumedAvg = memoryConsumedAvg;
    }

    public float getMemoryOverheadAvg() {
        return this.memoryOverheadAvg;
    }

    public void setMemoryOverheadAvg(float memoryOverheadAvg) {
        this.memoryOverheadAvg = memoryOverheadAvg;
    }

    public float getMemoryBalloonAvg() {
        return this.memoryBalloon;
    }

    public void setMemoryBalloonAvg(float memoryVmMemCtlAvg) {
        this.memoryBalloon = memoryVmMemCtlAvg;
    }

    public float getMemoryBalloonTargetAvg() {
        return this.memoryBalloonTarget;
    }

    public void setMemoryBalloonTargetAvg(float memoryVmMemCtlTargetAvg) {
        this.memoryBalloonTarget = memoryVmMemCtlTargetAvg;
    }

    public Float getAvgNetworkUsage() {
        return Float.valueOf(this.avgNetworkUsage);
    }

    public void setAvgNetworkUsage(Float avgNetworkUsage) {
        this.avgNetworkUsage = avgNetworkUsage.floatValue();
    }

    public int getNumValidCpuUsageSamples() {
        return this.numValidCpuUsageSamples;
    }

    public void setNumValidCpuUsageSamples(int numValidCpuUsageSamples) {
        this.numValidCpuUsageSamples = numValidCpuUsageSamples;
    }

    public long getCpuHz() {
        return this.cpuHz;
    }

    public void setCpuHz(long cpuHz) {
        this.cpuHz = cpuHz;
    }

    public int getNumberOfCpuCores() {
        return this.numberOfCpuCores;
    }

    public void setNumberOfCpuCores(int numberOfCpuCores) {
        this.numberOfCpuCores = numberOfCpuCores;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public Object[] getHostBusAdapter() {
        return this.hostBusAdapter;
    }

    public void setHostBusAdapter(Object[] hostBusAdapter) {
        this.hostBusAdapter = hostBusAdapter;
    }

    public int getNumberOfCpuThreads() {
        return this.numberOfCpuThreads;
    }

    public void setNumberOfCpuThreads(int numberOfCpuThreads) {
        this.numberOfCpuThreads = numberOfCpuThreads;
    }

    public VMWareResourcePool getRootResourcePool() {
        return this.rootResourcePool;
    }

    public void setRootResourcePool(VMWareResourcePool resourcePool) {
        this.rootResourcePool = resourcePool;
    }

    public VMWarePhysicalNic getPhysicalNic(String key) {
        return this.physicalNics.get(key);
    }

    public void putPhysicalNic(String key, VMWarePhysicalNic physicalNic) {
        this.physicalNics.put(key, physicalNic);
    }

    public LinkedHashMap<String, VMWarePhysicalNic> getAllPhysicalNics() {
        return this.physicalNics;
    }

    public void setAllPhysicalNics(LinkedHashMap<String, VMWarePhysicalNic> physicalNics) {
        this.physicalNics = physicalNics;
    }

    public VMWarePhysicalNic getPhysicalNicStats(String key) {
        return this.physicalNicStats.get(key);
    }

    public void putPhysicalNicStats(String key, VMWarePhysicalNic physicalNicStats) {
        this.physicalNicStats.put(key, physicalNicStats);
    }

    public HashMap<String, VMWarePhysicalNic> getAllPhysicalNicStats() {
        return this.physicalNicStats;
    }

    public void setAllPhysicalNicStats(HashMap<String, VMWarePhysicalNic> physicalNicStats) {
        this.physicalNicStats = physicalNicStats;
    }

    public String getProductFullName() {
        return this.productFullName;
    }

    public void setProductFullName(String productFullName) {
        this.productFullName = productFullName;
    }

    public String getEsxVersion() {
        return this.esxVersion;
    }

    public void setEsxVersion(String esxVersion) {
        this.esxVersion = esxVersion;
    }

    public String getEsxBuild() {
        return this.esxBuild;
    }

    public void setEsxBuild(String esxBuild) {
        this.esxBuild = esxBuild;
    }

    public String getPowerState() {
        return this.powerState;
    }

    public void setPowerState(String powerState) {
        this.powerState = powerState;
    }

    public String getConnectionState() {
        return this.connectionState;
    }

    public void setConnectionState(String connectionState) {
        this.connectionState = connectionState;
    }

    public Object getStorageSystemMor() {
        return this.storageSystemMor;
    }

    public void setStorageSystemMor(Object storageSystemMor) {
        this.storageSystemMor = storageSystemMor;
    }

    public Long getEffectiveCpu() {
        return this.effectiveCpu;
    }

    public void setEffectiveCpu(Long effectiveCpu) {
        this.effectiveCpu = effectiveCpu;
    }

    public Long getEffectiveMemory() {
        return this.effectiveMemory;
    }

    public void setEffectiveMemory(Long effectiveMemory) {
        this.effectiveMemory = effectiveMemory;
    }

    public Boolean getMaintenanceMode() {
        return this.maintenanceMode;
    }

    public void setMaintenanceMode(Boolean maintenanceMode) {
        this.maintenanceMode = maintenanceMode;
    }
}

