/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.collectors.vmware.exceptions;

import com.netapp.collectors.vmware.exceptions.CommunicationStateReason;
import com.netapp.collectors.vmware.logger.LogsManager;
import org.slf4j.Logger;

public class VMWareConnectionException
extends RuntimeException {
    private static final transient Logger logger = LogsManager.getLogger(VMWareConnectionException.class);
    private static final long serialVersionUID = 1L;
    private CommunicationStateReason communicationStateReason;

    public VMWareConnectionException(String msg) {
        super(msg);
        this.communicationStateReason = CommunicationStateReason.OTHER;
        logger.error(msg);
    }

    public VMWareConnectionException(Exception e) {
        super(e);
        this.communicationStateReason = CommunicationStateReason.OTHER;
    }

    public VMWareConnectionException(String msg, Exception e) {
        super(msg, e);
        this.communicationStateReason = CommunicationStateReason.OTHER;
        logger.error(msg, (Throwable)e);
    }

    public VMWareConnectionException(CommunicationStateReason communicationStateReason, String msg) {
        super(msg);
        this.communicationStateReason = communicationStateReason;
    }

    private VMWareConnectionException(CommunicationStateReason communicationStateReason, Throwable t) {
        super(t);
        this.communicationStateReason = communicationStateReason;
        logger.error(t.getLocalizedMessage(), t);
    }

    public VMWareConnectionException(CommunicationStateReason communicationStateReason, Throwable t, String msg) {
        super(msg, t);
        this.communicationStateReason = communicationStateReason;
    }

    public CommunicationStateReason getCommunicationStateReason() {
        return this.communicationStateReason;
    }

    public void setCommunicationStateReason(CommunicationStateReason communicationStateReason) {
        this.communicationStateReason = communicationStateReason;
    }
}

