/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.collectors.vmware.util;

import com.netapp.collectors.vmware.IVMWareContext;
import com.netapp.collectors.vmware.builders.PropertySpecBuilder;
import com.netapp.collectors.vmware.builders.SelectionSpecBuilder;
import com.netapp.collectors.vmware.builders.TraversalSpecBuilder;
import com.netapp.collectors.vmware.logger.LogsManager;
import com.netapp.collectors.vmware.util.PropertyFileUtil;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ObjectSpec;
import com.vmware.vim25.PerfMetricId;
import com.vmware.vim25.PerfQuerySpec;
import com.vmware.vim25.PropertySpec;
import com.vmware.vim25.SelectionSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.XMLGregorianCalendar;
import org.slf4j.Logger;

public class SpecBuilderUtil {
    private static final Logger LOG = LogsManager.getLogger(SpecBuilderUtil.class);

    public static List<SelectionSpec> buildFullTraversal() {
        TraversalSpecBuilder rpToRp = new TraversalSpecBuilder().type("ResourcePool").path("resourcePool").selectSet(new SelectionSpec[0]).name("rpToRp");
        TraversalSpecBuilder rpToVm = new TraversalSpecBuilder().type("ResourcePool").path("vm").selectSet(new SelectionSpecBuilder().name("rpToRp"), new SelectionSpecBuilder().name("rpToVm")).name("rpToVm");
        TraversalSpecBuilder crToRp = new TraversalSpecBuilder().type("ComputeResource").path("resourcePool").selectSet(new SelectionSpecBuilder().name("rpToRp"), new SelectionSpecBuilder().name("rpToVm")).name("crToRp");
        TraversalSpecBuilder crToH = new TraversalSpecBuilder().type("ComputeResource").path("host").selectSet(new SelectionSpec[0]).name("crToH");
        TraversalSpecBuilder dcToHf = new TraversalSpecBuilder().type("Datacenter").path("hostFolder").selectSet(new SelectionSpecBuilder().name("visitFolders")).name("dcToHf");
        TraversalSpecBuilder dcToVmf = new TraversalSpecBuilder().type("Datacenter").path("vmFolder").selectSet(new SelectionSpecBuilder().name("visitFolders")).name("dcToVmf");
        TraversalSpecBuilder dcToDsf = new TraversalSpecBuilder().type("Datacenter").path("datastore").selectSet(new SelectionSpecBuilder().name("visitFolders")).name("dcToDsf");
        TraversalSpecBuilder hToVm = new TraversalSpecBuilder().type("HostSystem").path("vm").skip(Boolean.FALSE).selectSet(new SelectionSpecBuilder().name("visitFolders")).name("hToVm");
        TraversalSpecBuilder visitFolders = new TraversalSpecBuilder().type("Folder").path("childEntity").skip(Boolean.FALSE).selectSet(new SelectionSpecBuilder().name("visitFolders"), new SelectionSpecBuilder().name("dcToHf"), new SelectionSpecBuilder().name("dcToVmf"), new SelectionSpecBuilder().name("dcToDsf"), new SelectionSpecBuilder().name("crToH"), new SelectionSpecBuilder().name("crToRp"), new SelectionSpecBuilder().name("hToVm"), new SelectionSpecBuilder().name("rpToVm")).name("visitFolders");
        ArrayList<SelectionSpec> selectionSpecList = new ArrayList<SelectionSpec>();
        selectionSpecList.add(rpToRp);
        selectionSpecList.add(rpToVm);
        selectionSpecList.add(crToRp);
        selectionSpecList.add(crToH);
        selectionSpecList.add(dcToHf);
        selectionSpecList.add(dcToVmf);
        selectionSpecList.add(dcToDsf);
        selectionSpecList.add(hToVm);
        selectionSpecList.add(visitFolders);
        return selectionSpecList;
    }

    public static List<PropertySpec> buildPropertySetForVm() {
        ArrayList<PropertySpec> vmPropertySpec = new ArrayList<PropertySpec>();
        PropertySpecBuilder pSpec = new PropertySpecBuilder().type("VirtualMachine").addToPathSet(PropertyFileUtil.returnPropertiesForVm());
        vmPropertySpec.add(pSpec);
        return vmPropertySpec;
    }

    public static List<ObjectSpec> buildObjectSetForVm(ManagedObjectReference containerViewReference) {
        ArrayList<ObjectSpec> objectSpecList = new ArrayList<ObjectSpec>();
        ObjectSpec vmObjectSpec = new ObjectSpec();
        vmObjectSpec.getSelectSet().addAll(SpecBuilderUtil.buildSelectionSpecForDS(true));
        vmObjectSpec.setObj(containerViewReference);
        vmObjectSpec.setSkip(Boolean.TRUE);
        objectSpecList.add(vmObjectSpec);
        return objectSpecList;
    }

    private static List<SelectionSpec> buildSelectionSpecForVm(boolean skipInventoryGraph) {
        ArrayList<SelectionSpec> selectionSpecList = new ArrayList<SelectionSpec>();
        TraversalSpecBuilder traversalSpec = new TraversalSpecBuilder().type("ContainerView").path("view").skip(Boolean.FALSE).name("traverseEntities");
        selectionSpecList.add(traversalSpec);
        if (skipInventoryGraph) {
            return selectionSpecList;
        }
        selectionSpecList.addAll(SpecBuilderUtil.buildSelectionSpecForVmWithInventory());
        return selectionSpecList;
    }

    private static List<SelectionSpec> buildSelectionSpecForVmWithInventory() {
        ArrayList<SelectionSpec> selectionSpecList = new ArrayList<SelectionSpec>();
        selectionSpecList.add(new TraversalSpecBuilder().type("VirtualMachine").path("resourcePool").skip(Boolean.FALSE));
        selectionSpecList.add(new TraversalSpecBuilder().type("VirtualMachine").path("network").skip(Boolean.FALSE));
        return selectionSpecList;
    }

    public static List<PropertySpec> buildPropertySetForHost() {
        ArrayList<PropertySpec> hostPropertySpec = new ArrayList<PropertySpec>();
        PropertySpecBuilder pSpec = new PropertySpecBuilder().type("HostSystem").addToPathSet(PropertyFileUtil.returnPropertiesForHosts());
        hostPropertySpec.add(pSpec);
        return hostPropertySpec;
    }

    public static List<ObjectSpec> buildObjectSetForHost(ManagedObjectReference containerViewReference) {
        ArrayList<ObjectSpec> objectSpecList = new ArrayList<ObjectSpec>();
        ObjectSpec hostObjectSpec = new ObjectSpec();
        hostObjectSpec.getSelectSet().addAll(SpecBuilderUtil.buildSelectionSpecForVm(true));
        hostObjectSpec.setObj(containerViewReference);
        hostObjectSpec.setSkip(Boolean.TRUE);
        objectSpecList.add(hostObjectSpec);
        return objectSpecList;
    }

    public static List<PropertySpec> buildPropertySetForDS() {
        ArrayList<PropertySpec> dsPropertySpec = new ArrayList<PropertySpec>();
        PropertySpecBuilder pSpec = new PropertySpecBuilder().type("Datastore").addToPathSet(PropertyFileUtil.returnPropertiesForDataStore());
        dsPropertySpec.add(pSpec);
        return dsPropertySpec;
    }

    public static List<ObjectSpec> buildObjectSetForDS(ManagedObjectReference containerViewReference) {
        ArrayList<ObjectSpec> objectSpecList = new ArrayList<ObjectSpec>();
        ObjectSpec vmObjectSpec = new ObjectSpec();
        vmObjectSpec.getSelectSet().addAll(SpecBuilderUtil.buildSelectionSpecForDS(true));
        vmObjectSpec.setObj(containerViewReference);
        vmObjectSpec.setSkip(Boolean.TRUE);
        objectSpecList.add(vmObjectSpec);
        return objectSpecList;
    }

    private static List<SelectionSpec> buildSelectionSpecForHost(boolean skipInventoryGraph) {
        ArrayList<SelectionSpec> selectionSpecList = new ArrayList<SelectionSpec>();
        TraversalSpecBuilder traversalSpec = new TraversalSpecBuilder().type("ContainerView").path("view").skip(Boolean.FALSE).name("traverseEntities");
        selectionSpecList.add(traversalSpec);
        if (skipInventoryGraph) {
            return selectionSpecList;
        }
        selectionSpecList.addAll(SpecBuilderUtil.buildSelectionSpecForHostWithInventory());
        return selectionSpecList;
    }

    private static List<SelectionSpec> buildSelectionSpecForDS(boolean skipInventoryGraph) {
        ArrayList<SelectionSpec> selectionSpecList = new ArrayList<SelectionSpec>();
        TraversalSpecBuilder traversalSpec = new TraversalSpecBuilder().type("ContainerView").path("view").skip(Boolean.FALSE).name("traverseEntities");
        selectionSpecList.add(traversalSpec);
        if (skipInventoryGraph) {
            return selectionSpecList;
        }
        selectionSpecList.addAll(SpecBuilderUtil.buildSelectionSpecForDSWithInventory());
        return selectionSpecList;
    }

    private static List<SelectionSpec> buildSelectionSpecForDSWithInventory() {
        ArrayList<SelectionSpec> selectionSpecList = new ArrayList<SelectionSpec>();
        selectionSpecList.add(new TraversalSpecBuilder().type("Datastore").path("name").skip(Boolean.FALSE));
        selectionSpecList.add(new TraversalSpecBuilder().type("Datastore").path("summary.accessible").skip(Boolean.FALSE));
        selectionSpecList.add(new TraversalSpecBuilder().type("Datastore").path("name").skip(Boolean.FALSE));
        selectionSpecList.add(new TraversalSpecBuilder().type("Datastore").path("summary.accessible").skip(Boolean.FALSE));
        selectionSpecList.add(new TraversalSpecBuilder().type("Datastore").path("summary.capacity").skip(Boolean.FALSE));
        selectionSpecList.add(new TraversalSpecBuilder().type("Datastore").path("summary.freespace").skip(Boolean.FALSE));
        selectionSpecList.add(new TraversalSpecBuilder().type("Datastore").path("summary.multipleHostAccess").skip(Boolean.FALSE));
        return selectionSpecList;
    }

    private static List<SelectionSpec> buildSelectionSpecForHostWithInventory() {
        ArrayList<SelectionSpec> selectionSpecList = new ArrayList<SelectionSpec>();
        selectionSpecList.add(new TraversalSpecBuilder().type("HostSystem").path("resourcePool").skip(Boolean.FALSE));
        selectionSpecList.add(new TraversalSpecBuilder().type("HostSystem").path("network").skip(Boolean.FALSE));
        return selectionSpecList;
    }

    public static PerfQuerySpec buildPerfQuerySpec(ManagedObjectReference managedObject, IVMWareContext vmWareContext, String instance, List<Integer> counters) throws DatatypeConfigurationException {
        XMLGregorianCalendar sampleStartTime = vmWareContext.getSampleStartTime();
        XMLGregorianCalendar sampleEndTime = vmWareContext.getSampleEndTime();
        LOG.trace("Building specs to collect the samples from start {} end {}", (Object)sampleStartTime.toString(), (Object)sampleEndTime.toString());
        return SpecBuilderUtil.buildPerfQuerySpec(managedObject, sampleStartTime, sampleEndTime, instance, counters);
    }

    public static PerfQuerySpec buildPerfQuerySpec(ManagedObjectReference managedObject, XMLGregorianCalendar startTime, XMLGregorianCalendar endTime, String instance, List<Integer> counters) throws DatatypeConfigurationException {
        PerfQuerySpec perfQuerySpec = new PerfQuerySpec();
        perfQuerySpec.setEntity(managedObject);
        perfQuerySpec.setMaxSample(1);
        perfQuerySpec.setFormat("csv");
        perfQuerySpec.setStartTime(startTime);
        perfQuerySpec.setEndTime(endTime);
        perfQuerySpec.setIntervalId(300);
        perfQuerySpec.getMetricId().addAll(SpecBuilderUtil.buildMetricId(instance, counters));
        return perfQuerySpec;
    }

    public static List<PerfMetricId> buildMetricId(String instance, List<Integer> counters) {
        ArrayList<PerfMetricId> perfMetricIds = new ArrayList<PerfMetricId>();
        for (Integer counter : counters) {
            PerfMetricId perfMetricId = new PerfMetricId();
            perfMetricId.setInstance(instance);
            perfMetricId.setCounterId(counter);
            perfMetricIds.add(perfMetricId);
        }
        return perfMetricIds;
    }

    public static List<PropertySpec> buildPerfCounterSpec(ManagedObjectReference perfManager) {
        PropertySpecBuilder propertySpec = new PropertySpecBuilder().addToPathSet(Arrays.asList("perfCounter")).all(false).type(perfManager.getType());
        return Arrays.asList(propertySpec);
    }

    public static List<PropertySpec> buildPerfHistoricalIntervalSpec(ManagedObjectReference perfManager) {
        PropertySpecBuilder propertySpec = new PropertySpecBuilder().addToPathSet(Arrays.asList("historicalInterval")).all(false).type(perfManager.getType());
        return Arrays.asList(propertySpec);
    }

    public static List<Integer> buildCountersFromProperties(List<String> properties, Map<String, Integer> metricsCounterMap) {
        ArrayList<Integer> counters = new ArrayList<Integer>();
        for (String prop : properties) {
            counters.add(metricsCounterMap.get(prop));
        }
        return counters;
    }
}

