/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.collectors.vmware.util;

import com.netapp.collectors.vmware.IVMWareContext;
import com.netapp.collectors.vmware.VMWare25Dao;
import com.netapp.collectors.vmware.builders.PropertySpecBuilder;
import com.netapp.collectors.vmware.exceptions.VMWareConfigurationException;
import com.netapp.collectors.vmware.exceptions.VMWareServiceException;
import com.netapp.collectors.vmware.logger.LogsManager;
import com.netapp.collectors.vmware.util.ContextUtil;
import com.netapp.collectors.vmware.util.PropertyFileUtil;
import com.netapp.collectors.vmware.util.SpecBuilderUtil;
import com.vmware.vim25.AboutInfo;
import com.vmware.vim25.ArrayOfOptionValue;
import com.vmware.vim25.DynamicProperty;
import com.vmware.vim25.InvalidNameFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ObjectContent;
import com.vmware.vim25.ObjectSpec;
import com.vmware.vim25.OptionValue;
import com.vmware.vim25.PerfEntityMetricBase;
import com.vmware.vim25.PerfQuerySpec;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.PropertySpec;
import com.vmware.vim25.RetrieveOptions;
import com.vmware.vim25.RetrieveResult;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.SelectionSpec;
import com.vmware.vim25.ServiceContent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.DatatypeConfigurationException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;

public class VMWareDataFetcher {
    private static final Logger LOG = LogsManager.getLogger(VMWareDataFetcher.class);

    public static RetrieveResult retrieveAllVmDetails(IVMWareContext vmWareContext) {
        ManagedObjectReference propertyCollector = (ManagedObjectReference)vmWareContext.getPropertyCollector();
        ManagedObjectReference containerViewReference = VMWareDataFetcher.createContainerView(vmWareContext, "VirtualMachine");
        PropertyFilterSpec filterSpec = new PropertyFilterSpec();
        filterSpec.getObjectSet().addAll(SpecBuilderUtil.buildObjectSetForVm(containerViewReference));
        filterSpec.getPropSet().addAll(SpecBuilderUtil.buildPropertySetForVm());
        ArrayList<PropertyFilterSpec> propertyFilterSpecList = new ArrayList<PropertyFilterSpec>();
        propertyFilterSpecList.add(filterSpec);
        RetrieveOptions ro = new RetrieveOptions();
        try {
            return ContextUtil.getVimPortService(vmWareContext).retrievePropertiesEx(propertyCollector, propertyFilterSpecList, ro);
        }
        catch (InvalidPropertyFaultMsg invalidPropertyFaultMsg) {
            throw new RuntimeException("Error while fetching data - invalid property " + invalidPropertyFaultMsg.getMessage());
        }
        catch (RuntimeFaultFaultMsg runtimeFaultFaultMsg) {
            throw new RuntimeException("Error while fetching data - server error" + runtimeFaultFaultMsg.getMessage());
        }
    }

    public static AboutInfo retrieveAboutInfo(IVMWareContext vmWareContext) {
        AboutInfo aboutInfo = ((ServiceContent)vmWareContext.getServiceContent()).getAbout();
        return aboutInfo;
    }

    public static RetrieveResult retrieveManagedObjectsAndProperties(ManagedObjectReference mor, List<PropertySpec> pSpec, List<SelectionSpec> tSpec, boolean skipRoot, IVMWareContext context, Integer maxRecords, String nextToken) throws VMWareServiceException {
        ArrayList<ObjectSpec> obSpecList = new ArrayList<ObjectSpec>();
        ObjectSpec objectSpec = new ObjectSpec();
        objectSpec.setObj(mor);
        objectSpec.setSkip(skipRoot);
        objectSpec.getSelectSet().addAll(tSpec);
        obSpecList.add(objectSpec);
        return VMWareDataFetcher.retrieveManagedObjectsAndProperties(obSpecList, pSpec, skipRoot, context, maxRecords, nextToken);
    }

    private static RetrieveResult retrieveManagedObjectsAndProperties(List<ObjectSpec> obSpec, List<PropertySpec> pSpec, boolean skipRoot, IVMWareContext context, Integer maxRecords, String nextToken) throws VMWareServiceException {
        PropertyFilterSpec fSpec = new PropertyFilterSpec();
        fSpec.getObjectSet().addAll(obSpec);
        fSpec.getPropSet().addAll(pSpec);
        ArrayList<PropertyFilterSpec> fSpecList = new ArrayList<PropertyFilterSpec>();
        fSpecList.add(fSpec);
        RetrieveOptions retrieveOptions = new RetrieveOptions();
        if (maxRecords != null) {
            retrieveOptions.setMaxObjects(maxRecords);
        }
        try {
            if (nextToken == null) {
                return ContextUtil.getVimPortService(context).retrievePropertiesEx((ManagedObjectReference)context.getPropertyCollector(), fSpecList, retrieveOptions);
            }
            return ContextUtil.getVimPortService(context).continueRetrievePropertiesEx((ManagedObjectReference)context.getPropertyCollector(), nextToken);
        }
        catch (InvalidPropertyFaultMsg | RuntimeFaultFaultMsg exception) {
            String errMessage = String.format("Error while retrieving data from VCenter %s", context.getvCenterHostNameOrIP());
            LOG.error(errMessage, (Throwable)exception);
            throw new VMWareServiceException(errMessage);
        }
    }

    public static List<OptionValue> retrieveServiceContentSettings(IVMWareContext vmWare25Context) throws VMWareServiceException {
        ManagedObjectReference optionManager = ((ServiceContent)vmWare25Context.getServiceContent()).getSetting();
        if (optionManager != null) {
            ArrayList<PropertySpec> pSpec = new ArrayList<PropertySpec>();
            PropertySpecBuilder serviceContentPropSet = new PropertySpecBuilder().all(Boolean.FALSE).addToPathSet(Arrays.asList("setting")).type(optionManager.getType());
            pSpec.add(serviceContentPropSet);
            ArrayList<ObjectSpec> oSpec = new ArrayList<ObjectSpec>();
            ObjectSpec serviceContentObjectSpec = new ObjectSpec();
            serviceContentObjectSpec.setObj(optionManager);
            oSpec.add(serviceContentObjectSpec);
            RetrieveResult retrieveResult = null;
            try {
                retrieveResult = VMWareDataFetcher.retrieveManagedObjectsAndProperties(oSpec, pSpec, false, vmWare25Context, null, null);
            }
            catch (VMWareServiceException serviceEX) {
                String errMessage = String.format("Error while retreiving ServiceContent settings for VCenter %s", vmWare25Context.getvCenterHostNameOrIP());
                LOG.error(errMessage);
                throw serviceEX;
            }
            for (ObjectContent objectContent : retrieveResult.getObjects()) {
                List<DynamicProperty> propSet = objectContent.getPropSet();
                if (propSet == null) continue;
                for (DynamicProperty dynamicProperty : propSet) {
                    if (!dynamicProperty.getName().equals("setting")) continue;
                    ArrayOfOptionValue vals = (ArrayOfOptionValue)dynamicProperty.getVal();
                    return vals.getOptionValue();
                }
            }
        }
        return null;
    }

    private static ManagedObjectReference createContainerView(IVMWareContext vmWareContext, String objectType) {
        ManagedObjectReference viewManagerReference = ContextUtil.getViewManagerReference(vmWareContext);
        ArrayList<String> typeList = new ArrayList<String>();
        typeList.add(objectType);
        try {
            return ContextUtil.getVimPortService(vmWareContext).createContainerView(viewManagerReference, ContextUtil.getRootFolder(vmWareContext), typeList, true);
        }
        catch (RuntimeFaultFaultMsg runtimeFaultFaultMsg) {
            throw new RuntimeException("Error while creating the container view" + runtimeFaultFaultMsg.getMessage());
        }
    }

    public static Map<String, Map<?, ?>> retrieveAvailablePerfMetricsMaps(IVMWareContext context) {
        VMWare25Dao vmWare25Dao = new VMWare25Dao();
        Map<String, Map<?, ?>> availablePerfMetricMaps = vmWare25Dao.retrieveAvailablePerfMetricMaps(context);
        if (MapUtils.isEmpty(availablePerfMetricMaps)) {
            LOG.error("vCenter perf counters are not available");
            throw new VMWareServiceException("vCenter perf counters are not available");
        }
        return availablePerfMetricMaps;
    }

    public static List<PerfEntityMetricBase> retrievePerfData(String objectType, Map<String, List<String>> moidInstanceMap, IVMWareContext context, List<Integer> counters, int batchSize) throws DatatypeConfigurationException, VMWareConfigurationException, VMWareServiceException {
        LOG.info("Fetching the stats for {} number of {} from  startTime {} and endTime {}", new Object[]{moidInstanceMap.keySet().size(), objectType, context.getSampleStartTime().toString(), context.getSampleEndTime().toString()});
        context.setStartTime(System.currentTimeMillis());
        ArrayList<PerfQuerySpec> perfQuerySpecs = new ArrayList<PerfQuerySpec>();
        ArrayList<PerfEntityMetricBase> retrievedStats = new ArrayList<PerfEntityMetricBase>();
        for (String moid : moidInstanceMap.keySet()) {
            ManagedObjectReference managedObjectReference = new ManagedObjectReference();
            managedObjectReference.setType(objectType);
            managedObjectReference.setValue(moid);
            for (String instance : moidInstanceMap.get(moid)) {
                LOG.trace("Fetching data for moid {} and instance {} for vcenter {}", new Object[]{moid, instance, context.getVcURL()});
                PerfQuerySpec perfQuerySpec = SpecBuilderUtil.buildPerfQuerySpec(managedObjectReference, context, instance, counters);
                perfQuerySpecs.add(perfQuerySpec);
            }
        }
        if (CollectionUtils.isEmpty(perfQuerySpecs)) {
            LOG.warn("No query specs found. Skipping stat fetch request");
            context.setEndTime(System.currentTimeMillis());
            return retrievedStats;
        }
        Integer vcenterMaxRecords = null;
        try {
            List<OptionValue> vcenterProperties = ContextUtil.getVimPortService(context).queryOptions((ManagedObjectReference)context.getOptionManager(), PropertyFileUtil.returnMaxQuerySettings());
            for (OptionValue optionValue : vcenterProperties) {
                if (!optionValue.getKey().equals(PropertyFileUtil.returnMaxQuerySettings())) continue;
                vcenterMaxRecords = Integer.valueOf(String.valueOf(optionValue.getValue()));
            }
        }
        catch (InvalidNameFaultMsg | NumberFormatException ex) {
            LOG.debug("{} setting is not available from VCenter, using provided batch size {}", (Object)PropertyFileUtil.returnMaxQuerySettings(), (Object)batchSize);
        }
        catch (RuntimeFaultFaultMsg ex) {
            LOG.debug("Error while fetching the maxQueryMetrics from vcenter");
        }
        if (vcenterMaxRecords != null) {
            LOG.debug("Retrieved {} from VCenter : {}", (Object)PropertyFileUtil.returnMaxQuerySettings(), vcenterMaxRecords);
            batchSize = vcenterMaxRecords;
        }
        if (batchSize == 0) {
            LOG.error("Batch size from vcenter is not available or it has been set to zero and user given batch size cannot be zero");
            throw new VMWareConfigurationException("Batch size from vcenter is not available or set to zero and user given batch size cannot be zero");
        }
        if (batchSize == -1) {
            batchSize = perfQuerySpecs.size();
        }
        int totalNumber = perfQuerySpecs.size();
        int noIter = totalNumber / batchSize;
        int remainder = totalNumber % batchSize;
        int startIndex = 0;
        int endIndex = batchSize;
        for (int count = 0; count < noIter; ++count) {
            List<PerfQuerySpec> sublist = perfQuerySpecs.subList(startIndex, endIndex);
            LOG.debug("Retrieving stats for {} objects in {} iteration", (Object)sublist.size(), (Object)noIter);
            retrievedStats.addAll(VMWareDataFetcher.retrievePerfData(context, sublist));
            startIndex += batchSize;
            endIndex += batchSize;
        }
        if (remainder != 0) {
            endIndex = endIndex - batchSize + remainder;
            List<PerfQuerySpec> sublist = perfQuerySpecs.subList(startIndex, endIndex);
            LOG.debug("Retrieving stats for {} objects in last iteration", (Object)sublist.size(), (Object)noIter);
            retrievedStats.addAll(VMWareDataFetcher.retrievePerfData(context, sublist));
        }
        context.setEndTime(System.currentTimeMillis());
        return retrievedStats;
    }

    public static List<PerfEntityMetricBase> retrievePerfData(IVMWareContext context, List<PerfQuerySpec> listOfQuerySpecs) throws VMWareServiceException {
        try {
            List<PerfEntityMetricBase> batchStats = ContextUtil.getVimPortService(context).queryPerf((ManagedObjectReference)context.getPerformanceManager(), listOfQuerySpecs);
            return batchStats;
        }
        catch (RuntimeFaultFaultMsg runtimeFaultFaultMsg) {
            String errMessage = String.format("Error while retrieving performance stats from VCenter %s", context.getvCenterHostNameOrIP());
            LOG.error(errMessage, (Throwable)runtimeFaultFaultMsg);
            throw new VMWareServiceException(errMessage);
        }
    }
}

