/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import javax.ws.rs.core.NewCookie;
import javax.ws.rs.ext.RuntimeDelegate;
import org.apache.cxf.common.util.StringUtils;

public class NewCookieHeaderProvider
implements RuntimeDelegate.HeaderDelegate<NewCookie> {
    private static final String VERSION = "Version";
    private static final String PATH = "Path";
    private static final String DOMAIN = "Domain";
    private static final String MAX_AGE = "Max-Age";
    private static final String COMMENT = "Comment";
    private static final String SECURE = "Secure";
    private static final String EXPIRES = "Expires";

    public NewCookie fromString(String c) {
        String[] tokens;
        if (c == null) {
            throw new IllegalArgumentException("SetCookie value can not be null");
        }
        String name = null;
        String value = null;
        String path = null;
        String domain = null;
        String comment = null;
        int maxAge = -1;
        boolean isSecure = false;
        for (String token : tokens = StringUtils.split(c, ";")) {
            int i;
            String theToken = token.trim();
            if (theToken.startsWith(VERSION)) continue;
            if (theToken.startsWith(MAX_AGE)) {
                maxAge = Integer.parseInt(theToken.substring(MAX_AGE.length() + 1));
                continue;
            }
            if (theToken.startsWith(PATH)) {
                path = theToken.substring(PATH.length() + 1);
                continue;
            }
            if (theToken.startsWith(DOMAIN)) {
                domain = theToken.substring(DOMAIN.length() + 1);
                continue;
            }
            if (theToken.startsWith(COMMENT)) {
                comment = theToken.substring(COMMENT.length() + 1);
                continue;
            }
            if (theToken.startsWith(SECURE)) {
                isSecure = true;
                continue;
            }
            if (theToken.startsWith(EXPIRES) || (i = theToken.indexOf(61)) == -1) continue;
            name = theToken.substring(0, i);
            value = i == theToken.length() + 1 ? "" : theToken.substring(i + 1);
        }
        if (name == null || value == null) {
            throw new IllegalArgumentException("Set-Cookie is malformed : " + c);
        }
        return new NewCookie(name, value, path, domain, comment, maxAge, isSecure);
    }

    public String toString(NewCookie value) {
        StringBuilder sb = new StringBuilder();
        sb.append(value.getName()).append('=').append(value.getValue());
        if (value.getComment() != null) {
            sb.append(';').append(COMMENT).append('=').append(value.getComment());
        }
        if (value.getDomain() != null) {
            sb.append(';').append(DOMAIN).append('=').append(value.getDomain());
        }
        if (value.getMaxAge() != -1) {
            sb.append(';').append(MAX_AGE).append('=').append(value.getMaxAge());
        }
        if (value.getPath() != null) {
            sb.append(';').append(PATH).append('=').append(value.getPath());
        }
        if (value.isSecure()) {
            sb.append(';').append(SECURE);
        }
        sb.append(';').append(VERSION).append('=').append(value.getVersion());
        return sb.toString();
    }
}

