/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.Response;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.http.HTTPBinding;
import javax.xml.ws.http.HTTPException;
import javax.xml.ws.soap.SOAPBinding;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.saaj.SAAJFactoryResolver;
import org.apache.cxf.binding.soap.saaj.SAAJUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxws.EndpointReferenceBuilder;
import org.apache.cxf.jaxws.JaxwsClientCallback;
import org.apache.cxf.jaxws.JaxwsResponseCallback;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.apache.cxf.service.invoker.MethodDispatcher;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.w3c.dom.Node;

public class JaxWsClientProxy
extends ClientProxy
implements BindingProvider {
    public static final String THREAD_LOCAL_REQUEST_CONTEXT = "thread.local.request.context";
    private static final Logger LOG = LogUtils.getL7dLogger(JaxWsClientProxy.class);
    private Binding binding;
    private EndpointReferenceBuilder builder;

    public JaxWsClientProxy(Client c, Binding b) {
        super(c);
        this.binding = b;
        this.setupEndpointAddressContext(this.getClient().getEndpoint());
        this.builder = new EndpointReferenceBuilder((JaxWsEndpointImpl)this.getClient().getEndpoint());
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.binding = null;
        this.builder = null;
    }

    private void setupEndpointAddressContext(Endpoint endpoint) {
        if (null != endpoint && null != endpoint.getEndpointInfo().getAddress()) {
            this.getRequestContext().put("javax.xml.ws.service.endpoint.address", endpoint.getEndpointInfo().getAddress());
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        BindingOperationInfo oi;
        if (this.client == null) {
            throw new IllegalStateException("The client has been closed.");
        }
        Endpoint endpoint = this.getClient().getEndpoint();
        String address = endpoint.getEndpointInfo().getAddress();
        MethodDispatcher dispatcher = (MethodDispatcher)endpoint.getService().get(MethodDispatcher.class.getName());
        Object[] params = args;
        if (null == params) {
            params = new Object[]{};
        }
        if ((oi = dispatcher.getBindingOperation(method, endpoint)) == null) {
            if (method.getDeclaringClass().equals(BindingProvider.class) || method.getDeclaringClass().equals(Object.class) || method.getDeclaringClass().equals(Closeable.class)) {
                try {
                    return method.invoke((Object)this, params);
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }
            Message msg = new Message("NO_BINDING_OPERATION_INFO", LOG, method.getName());
            throw new WebServiceException(msg.toString());
        }
        this.client.getRequestContext().put(Method.class.getName(), method);
        boolean isAsync = this.isAsync(method);
        Object result = null;
        try {
            result = isAsync ? this.invokeAsync(method, oi, params) : this.invokeSync(method, oi, params);
        }
        catch (WebServiceException wex) {
            throw wex;
        }
        catch (Exception ex) {
            for (Class<?> excls : method.getExceptionTypes()) {
                if (!excls.isInstance(ex)) continue;
                throw ex;
            }
            if (ex instanceof Fault && ex.getCause() instanceof IOException) {
                throw new WebServiceException(ex.getMessage(), ex.getCause());
            }
            if (this.getBinding() instanceof HTTPBinding) {
                HTTPException exception = new HTTPException(500);
                exception.initCause((Throwable)ex);
                throw exception;
            }
            if (this.getBinding() instanceof SOAPBinding) {
                SOAPFault soapFault = JaxWsClientProxy.createSoapFault((SOAPBinding)this.getBinding(), ex);
                if (soapFault == null) {
                    throw new WebServiceException((Throwable)ex);
                }
                SOAPFaultException exception = new SOAPFaultException(soapFault);
                if (ex instanceof Fault && ex.getCause() != null) {
                    exception.initCause(ex.getCause());
                } else {
                    exception.initCause((Throwable)ex);
                }
                throw exception;
            }
            throw new WebServiceException((Throwable)ex);
        }
        finally {
            if (this.addressChanged(address)) {
                this.setupEndpointAddressContext(this.getClient().getEndpoint());
            }
        }
        Map<String, Object> respContext = this.client.getResponseContext();
        Map scopes = CastUtils.cast((Map)respContext.get(WrappedMessageContext.SCOPES));
        if (scopes != null) {
            for (Map.Entry scope : scopes.entrySet()) {
                if (scope.getValue() != MessageContext.Scope.HANDLER) continue;
                respContext.remove(scope.getKey());
            }
        }
        return this.adjustObject(result);
    }

    boolean isAsync(Method m) {
        return m.getName().endsWith("Async") && (Future.class.equals(m.getReturnType()) || Response.class.equals(m.getReturnType()));
    }

    static SOAPFault createSoapFault(SOAPBinding binding, Exception ex) throws SOAPException {
        SOAPFault soapFault;
        try {
            soapFault = binding.getSOAPFactory().createFault();
        }
        catch (Throwable t) {
            try {
                soapFault = binding.getMessageFactory().createMessage().getSOAPPart().getEnvelope().getBody().addFault();
            }
            catch (Throwable t2) {
                return null;
            }
        }
        if (ex instanceof SoapFault) {
            if (!soapFault.getNamespaceURI().equals(((SoapFault)ex).getFaultCode().getNamespaceURI()) && "http://schemas.xmlsoap.org/soap/envelope/".equals(((SoapFault)ex).getFaultCode().getNamespaceURI())) {
                try {
                    soapFault = SAAJFactoryResolver.createSOAPFactory(null).createFault();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            soapFault.setFaultString(((SoapFault)ex).getReason());
            SAAJUtils.setFaultCode(soapFault, ((SoapFault)ex).getFaultCode());
            String role = ((SoapFault)ex).getRole();
            if (role != null) {
                soapFault.setFaultActor(role);
            }
            if (((SoapFault)ex).getSubCodes() != null && !"http://schemas.xmlsoap.org/soap/envelope/".equals(soapFault.getNamespaceURI())) {
                for (QName fsc : ((SoapFault)ex).getSubCodes()) {
                    soapFault.appendFaultSubcode(fsc);
                }
            }
            if (((SoapFault)ex).hasDetails()) {
                Node nd = soapFault.getOwnerDocument().importNode(((SoapFault)ex).getDetail(), true);
                nd = nd.getFirstChild();
                soapFault.addDetail();
                while (nd != null) {
                    Node next = nd.getNextSibling();
                    soapFault.getDetail().appendChild(nd);
                    nd = next;
                }
            }
        } else {
            String msg = ex.getMessage();
            if (msg != null) {
                soapFault.setFaultString(msg);
            }
        }
        return soapFault;
    }

    private boolean addressChanged(String address) {
        return address != null && this.getClient().getEndpoint().getEndpointInfo() != null && !address.equals(this.getClient().getEndpoint().getEndpointInfo().getAddress());
    }

    private Object invokeAsync(Method method, BindingOperationInfo oi, Object[] params) throws Exception {
        AsyncHandler handler;
        this.client.setExecutor(this.getClient().getEndpoint().getExecutor());
        if (params.length > 0 && params[params.length - 1] instanceof AsyncHandler) {
            handler = (AsyncHandler)params[params.length - 1];
            Object[] newParams = new Object[params.length - 1];
            for (int i = 0; i < newParams.length; ++i) {
                newParams[i] = params[i];
            }
            params = newParams;
        } else {
            handler = null;
        }
        JaxwsClientCallback callback = new JaxwsClientCallback(handler, this);
        JaxwsResponseCallback ret = new JaxwsResponseCallback(callback);
        this.client.invoke(callback, oi, params);
        return ret;
    }

    @Override
    public Map<String, Object> getRequestContext() {
        if (this.client == null) {
            throw new IllegalStateException("The client has been closed.");
        }
        return new WrappedMessageContext(this.getClient().getRequestContext(), null, MessageContext.Scope.APPLICATION);
    }

    @Override
    public Map<String, Object> getResponseContext() {
        if (this.client == null) {
            throw new IllegalStateException("The client has been closed.");
        }
        return new WrappedMessageContext(this.getClient().getResponseContext(), null, MessageContext.Scope.APPLICATION);
    }

    public Binding getBinding() {
        if (this.client == null) {
            throw new IllegalStateException("The client has been closed.");
        }
        return this.binding;
    }

    public EndpointReference getEndpointReference() {
        if (this.client == null) {
            throw new IllegalStateException("The client has been closed.");
        }
        return this.builder.getEndpointReference();
    }

    public <T extends EndpointReference> T getEndpointReference(Class<T> clazz) {
        if (this.client == null) {
            throw new IllegalStateException("The client has been closed.");
        }
        return this.builder.getEndpointReference(clazz);
    }
}

