/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.grants;

import java.util.Collections;
import java.util.List;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenRegistration;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.OAuthError;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.provider.AccessTokenGrantHandler;
import org.apache.cxf.rs.security.oauth2.provider.OAuthDataProvider;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;

public abstract class AbstractGrantHandler
implements AccessTokenGrantHandler {
    private String supportedGrant;
    private OAuthDataProvider dataProvider;
    private boolean partialMatchScopeValidation;
    private boolean canSupportPublicClients;

    protected AbstractGrantHandler(String grant) {
        this.supportedGrant = grant;
    }

    public void setDataProvider(OAuthDataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    public OAuthDataProvider getDataProvider() {
        return this.dataProvider;
    }

    @Override
    public List<String> getSupportedGrantTypes() {
        return Collections.singletonList(this.supportedGrant);
    }

    protected void checkIfGrantSupported(Client client) {
        if (!OAuthUtils.isGrantSupportedForClient(client, this.canSupportPublicClients, "authorization_code")) {
            throw new OAuthServiceException("unauthorized_client");
        }
    }

    protected ServerAccessToken doCreateAccessToken(Client client, UserSubject subject, List<String> requestedScope) {
        if (!OAuthUtils.validateScopes(requestedScope, client.getRegisteredScopes(), this.partialMatchScopeValidation)) {
            throw new OAuthServiceException(new OAuthError("invalid_scope"));
        }
        ServerAccessToken token = this.dataProvider.getPreauthorizedToken(client, requestedScope, subject, this.supportedGrant);
        if (token != null) {
            return token;
        }
        AccessTokenRegistration reg = new AccessTokenRegistration();
        reg.setClient(client);
        reg.setGrantType(this.supportedGrant);
        reg.setSubject(subject);
        reg.setRequestedScope(requestedScope);
        return this.dataProvider.createAccessToken(reg);
    }

    public void setPartialMatchScopeValidation(boolean partialMatchScopeValidation) {
        this.partialMatchScopeValidation = partialMatchScopeValidation;
    }

    public void setCanSupportPublicClients(boolean support) {
        this.canSupportPublicClients = support;
    }

    public boolean isCanSupportPublicClients() {
        return this.canSupportPublicClients;
    }
}

