/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.axx.cosine;

import com.blackducksoftware.sdk.fault.ErrorCode;
import com.blackducksoftware.sdk.fault.SdkFault;
import com.blackducksoftware.sdk.protex.client.util.ProtexServerProxy;
import com.blackducksoftware.sdk.protex.common.ComponentKey;
import com.blackducksoftware.sdk.protex.common.GetBehavior;
import com.blackducksoftware.sdk.protex.component.Component;
import com.blackducksoftware.sdk.protex.component.ComponentApi;
import com.blackducksoftware.sdk.protex.license.LicenseApi;
import com.blackducksoftware.sdk.protex.license.LicenseInfo;
import com.blackducksoftware.sdk.protex.policy.externalid.ExternalIdApi;
import com.blackducksoftware.sdk.protex.policy.externalid.ProtexObjectKey;
import com.blackducksoftware.sdk.protex.policy.externalid.ProtexObjectType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.hash.HashCode;
import com.jamesmurty.utils.XMLBuilder2;
import com.netapp.axx.cosine.BinaryJarInventoryFileVisitor;
import com.netapp.axx.cosine.RetrievedComponentInfo;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.apache.tools.ant.Task;

public class CosineBuildReportTask
extends Task {
    private static final long CONNECTION_TIMEOUT = 600000L;
    private static final Path NULL_PATH = new File("").toPath();
    private static final Predicate<Path> IN_MODULE_TARGET = new Predicate<Path>(){

        @Override
        public boolean apply(@Nonnull Path path) {
            return "modules".equals(path.getName(0).toString()) && "target".equals(path.getName(2).toString());
        }
    };
    private static final Predicate<Path> IN_MODULE_LIB = new Predicate<Path>(){

        @Override
        public boolean apply(@Nonnull Path path) {
            return "modules".equals(path.getName(0).toString()) && "lib".equals(path.getName(2).toString());
        }
    };
    private static final Predicate<Path> IN_MODULE_ARTIFACT = new Predicate<Path>(){

        @Override
        public boolean apply(@Nonnull Path path) {
            return "modules".equals(path.getName(0).toString()) && "target".equals(path.getName(2).toString()) && "artifacts".equals(path.getName(3).toString());
        }
    };
    private static final Predicate<Path> IN_TOOLS_RETRIEVED_OR_SYNC = new Predicate<Path>(){

        @Override
        public boolean apply(@Nonnull Path path) {
            return "tools".equals(path.getName(0).toString()) && path.getName(1).toString().matches("^(retrieved|sync)$");
        }
    };
    private static final Path IVY_GRAPES_RELATIVE_PATH = new File("ivy/grapes").toPath();
    private static final Predicate<Path> IN_IVY_GRAPES = new Predicate<Path>(){

        @Override
        public boolean apply(@Nonnull Path path) {
            return path.startsWith(IVY_GRAPES_RELATIVE_PATH.toString());
        }
    };
    private final Predicate<Path> inIvyCachePredicate = new Predicate<Path>(){

        @Override
        public boolean apply(@Nonnull Path path) {
            return path.startsWith(CosineBuildReportTask.this.ivyCacheRelativePath.toString());
        }
    };
    private String blackduckServerUri = "http://protex-test01.eng.netapp.com/";
    private String blackduckUser = "axxbuild@netapp.com";
    private String blackduckPassword = "axxbuildprotex";
    private String blackduckNamespace = "nexus";
    private Path buildRoot;
    private Path ivyCacheDirectory;
    private File output;
    private Path ivyCacheRelativePath = new File("ivy/cache").toPath();
    @VisibleForTesting
    BinaryJarInventoryFileVisitor<Path> visitor = new BinaryJarInventoryFileVisitor();
    ProtexServerProxy protexServer;
    ComponentApi componentApi;
    ExternalIdApi externalIdApi;
    LicenseApi licenseApi;

    public void setBlackduckServerUri(String blackduckServerUri) {
        this.blackduckServerUri = blackduckServerUri;
    }

    public void setBlackduckUser(String blackduckUser) {
        this.blackduckUser = blackduckUser;
    }

    public void setBlackduckPassword(String blackduckPassword) {
        this.blackduckPassword = blackduckPassword;
    }

    public void setBlackduckNamespace(String blackduckNamespace) {
        this.blackduckNamespace = blackduckNamespace;
    }

    public void setBuildRoot(String buildRoot) {
        this.buildRoot = new File(buildRoot).toPath();
        this.visitor.setBuildRoot(this.buildRoot);
    }

    public void setIvyCacheDirectory(String ivyCacheDirectory) {
        this.ivyCacheDirectory = new File(ivyCacheDirectory).toPath();
    }

    public void setOutput(File output) {
        this.output = output;
    }

    @Override
    public void execute() {
        Preconditions.checkNotNull(this.buildRoot);
        Preconditions.checkNotNull(this.output);
        if (this.ivyCacheDirectory != null) {
            this.ivyCacheRelativePath = this.buildRoot.relativize(this.ivyCacheDirectory);
        }
        try {
            Files.walkFileTree(this.buildRoot, this.visitor);
        }
        catch (IOException e) {
            Throwables.propagate(e);
        }
        this.protexServer = new ProtexServerProxy(this.blackduckServerUri, this.blackduckUser, this.blackduckPassword, 600000L);
        this.componentApi = this.protexServer.getComponentApi();
        this.externalIdApi = this.protexServer.getExternalIdApi();
        this.licenseApi = this.protexServer.getLicenseApi();
        List<RetrievedComponentInfo> buildComponents = this.createGavRecords(this.visitor.md5ToFilePathsMap);
        this.printXmlReport(buildComponents, this.output);
    }

    private List<RetrievedComponentInfo> createGavRecords(Multimap<HashCode, Path> md5ToFilePathsMap) {
        ArrayList<RetrievedComponentInfo> gavComponents = Lists.newArrayList();
        HashSet<HashCode> keys = new HashSet<HashCode>(md5ToFilePathsMap.keySet());
        for (HashCode md5 : keys) {
            RetrievedComponentInfo retrievedComponentInfo;
            String md5string = md5.toString();
            Collection<Path> paths = md5ToFilePathsMap.get(md5);
            Path nexusRetrievedItemPath = NULL_PATH;
            String[] gavJarPathParts = new String[]{};
            Path ivyCachePath = Iterables.find(paths, this.inIvyCachePredicate, NULL_PATH);
            Path ivyGrapesPath = Iterables.find(paths, IN_IVY_GRAPES, NULL_PATH);
            if (!ivyCachePath.equals(NULL_PATH)) {
                nexusRetrievedItemPath = ivyCachePath;
                gavJarPathParts = this.ivyCacheRelativePath.relativize(nexusRetrievedItemPath).toString().split("/");
            } else if (!ivyGrapesPath.equals(NULL_PATH)) {
                nexusRetrievedItemPath = ivyGrapesPath;
                gavJarPathParts = IVY_GRAPES_RELATIVE_PATH.relativize(nexusRetrievedItemPath).toString().split("/");
            }
            if (!nexusRetrievedItemPath.equals(NULL_PATH)) {
                retrievedComponentInfo = new RetrievedComponentInfo(gavJarPathParts[0] + ':' + gavJarPathParts[1] + ':' + gavJarPathParts[2]);
                retrievedComponentInfo.setRetrievedCacheDirectory(nexusRetrievedItemPath.getParent().toString());
                retrievedComponentInfo.setRetrievedBinaryArtifact(gavJarPathParts[3]);
                String sourceJar = gavJarPathParts[3].replace(".jar", "-sources.jar");
                if (new File(nexusRetrievedItemPath.getParent().toString(), sourceJar).exists()) {
                    retrievedComponentInfo.setRetrievedSourceArtifact(sourceJar);
                }
                try {
                    this.populateBlackDuckInfo(retrievedComponentInfo);
                }
                catch (SdkFault e) {}
            } else {
                retrievedComponentInfo = new RetrievedComponentInfo();
                Path projectArtifactPath = Iterables.find(paths, IN_MODULE_ARTIFACT, NULL_PATH);
                if (!nexusRetrievedItemPath.equals(NULL_PATH)) {
                    retrievedComponentInfo.setRetrievedBinaryArtifact(projectArtifactPath.getFileName().toString());
                } else {
                    retrievedComponentInfo.setRetrievedBinaryArtifact(Iterables.get(paths, 0).getFileName().toString());
                }
            }
            retrievedComponentInfo.setMd5Sum(md5string);
            retrievedComponentInfo.setBuildTreeOccurences(paths);
            this.determineUsage(paths, retrievedComponentInfo);
            gavComponents.add(retrievedComponentInfo);
        }
        return gavComponents;
    }

    private void determineUsage(Collection<Path> paths, RetrievedComponentInfo retrievedComponentInfo) {
        if (Iterables.find(paths, IN_MODULE_ARTIFACT, NULL_PATH) != NULL_PATH) {
            retrievedComponentInfo.setUsage(RetrievedComponentInfo.RetrievedComponentUsage.PROJECT_GENERATED);
        } else if (Iterables.find(paths, IN_MODULE_TARGET, NULL_PATH) != NULL_PATH) {
            retrievedComponentInfo.setUsage(RetrievedComponentInfo.RetrievedComponentUsage.SHIPPING);
        } else if (Iterables.find(paths, IN_MODULE_LIB, NULL_PATH) != NULL_PATH) {
            retrievedComponentInfo.setUsage(RetrievedComponentInfo.RetrievedComponentUsage.COMPILED_AGAINST);
        } else if (Iterables.find(paths, IN_TOOLS_RETRIEVED_OR_SYNC, NULL_PATH) != NULL_PATH) {
            retrievedComponentInfo.setUsage(RetrievedComponentInfo.RetrievedComponentUsage.TOOL);
        } else {
            retrievedComponentInfo.setUsage(RetrievedComponentInfo.RetrievedComponentUsage.UNKNOWN);
        }
    }

    private void populateBlackDuckInfo(RetrievedComponentInfo retrievedComponentInfo) throws SdkFault {
        Component componentToUse;
        String gav = retrievedComponentInfo.getGav();
        String componentId = this.getComponentForGav(this.blackduckNamespace, gav);
        if (componentId == null) {
            return;
        }
        ComponentKey componentKey = new ComponentKey();
        componentKey.setComponentId(componentId);
        List components = this.componentApi.getComponentVersions(componentId);
        Component component = componentToUse = components.isEmpty() ? null : (Component)components.get(0);
        if (componentToUse == null) {
            return;
        }
        String version = gav.split(":")[2];
        String versionToUse = "";
        String versionIdToUse = "";
        for (Component component2 : components) {
            if (!version.equals(component2.getVersionName())) continue;
            componentToUse = component2;
            versionToUse = component2.getVersionName();
            versionIdToUse = component2.getComponentKey().getVersionId();
            break;
        }
        retrievedComponentInfo.setKbComponentId(componentToUse.getComponentKey().getComponentId());
        retrievedComponentInfo.setKbComponentName(componentToUse.getComponentName());
        retrievedComponentInfo.setKbComponentVersion(versionToUse);
        retrievedComponentInfo.setKbComponentVersionId(versionIdToUse);
        retrievedComponentInfo.setKbComponentPrimaryLicense(this.licenseApi.getLicenseById(componentToUse.getPrimaryLicenseId()));
        List<String> licenseIds = Lists.transform(componentToUse.getLicenses(), new Function<LicenseInfo, String>(){

            @Override
            public String apply(LicenseInfo input) {
                return input.getLicenseId();
            }
        });
        retrievedComponentInfo.setKbComponentLicenses(this.licenseApi.getLicensesById(licenseIds, GetBehavior.CONTINUE_IF_NOT_FOUND));
    }

    final String getGaForGav(String gav) {
        if (gav.indexOf(58) == gav.lastIndexOf(58)) {
            return gav;
        }
        return gav.substring(0, gav.lastIndexOf(58));
    }

    final String getComponentForGav(String namespace, String gav) {
        try {
            String ga = this.getGaForGav(gav);
            ProtexObjectKey key = this.externalIdApi.getObjectIdByExternalId(namespace, ga, ProtexObjectType.COMPONENT);
            return key.getObjectId();
        }
        catch (SdkFault fault) {
            if (ErrorCode.EXTERNAL_ID_MAPPING_NOT_FOUND.equals((Object)fault.getFaultInfo().getErrorCode())) {
                return null;
            }
            this.log(fault.getFaultInfo().getErrorCode() + " " + fault.getFaultInfo().getMessage());
            return null;
        }
    }

    private void printXmlReport(List<RetrievedComponentInfo> buildComponents, File outputFile) {
        XMLBuilder2 builder = XMLBuilder2.create("buildComponents");
        for (RetrievedComponentInfo buildComponent : buildComponents) {
            buildComponent.append(builder);
        }
        Properties outputProperties = new Properties();
        outputProperties.put("method", "xml");
        outputProperties.put("indent", "yes");
        outputProperties.put("{http://xml.apache.org/xslt}indent-amount", "2");
        outputProperties.put("omit-xml-declaration", "no");
        try {
            PrintWriter writer = new PrintWriter(outputFile, Charsets.UTF_8.name());
            builder.toWriter(writer, outputProperties);
        }
        catch (IOException e) {
            Throwables.propagate(e);
        }
    }
}

