/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.axx.cosine;

import com.blackducksoftware.sdk.protex.license.GlobalLicense;
import com.blackducksoftware.sdk.protex.license.PermittedOrRequired;
import com.google.common.collect.Lists;
import com.jamesmurty.utils.XMLBuilder2;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;

class RetrievedComponentInfo {
    private String gav = "";
    private String md5Sum = "";
    private String retrievedCacheDirectory = "";
    private String retrievedBinaryArtifact = "";
    private String retrievedSourceArtifact = "";
    private Collection<Path> buildTreeOccurences = Lists.newArrayList();
    private RetrievedComponentUsage usage;
    private String kbComponentId = "";
    private String kbComponentName = "";
    private String kbComponentVersion = "";
    private String kbComponentVersionId = "";
    private GlobalLicense kbComponentPrimaryLicense;
    private List<GlobalLicense> kbComponentLicenses = Lists.newArrayList();

    RetrievedComponentInfo() {
        this.gav = "";
    }

    RetrievedComponentInfo(String gav) {
        this.gav = gav;
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_INFERRED"})
    public void append(XMLBuilder2 builder) {
        XMLBuilder2 componentRoot = builder.element("component");
        boolean componentRequiresSourcePublish = false;
        componentRoot.element("gav").text(this.gav).up().element("md5").text(this.md5Sum).up().element("cacheDirectory").text(this.retrievedCacheDirectory).up().element("binaryArtifact").text(this.retrievedBinaryArtifact).up().element("sourceArtifact").text(this.retrievedSourceArtifact).up().element("usage").text(this.usage.toString()).up().element("kbComponentId").text(this.kbComponentId).up().element("kbComponentName").text(this.kbComponentName).up().element("kbComponentVersion").text(this.kbComponentVersion).up().element("kbComponentVersionId").text(this.kbComponentVersionId).up();
        if (this.kbComponentPrimaryLicense != null) {
            componentRoot.element("primaryLicense").text(this.kbComponentPrimaryLicense.getName()).up().element("primaryLicenseApproval").text(this.kbComponentPrimaryLicense.getApprovalState().name()).up();
            componentRequiresSourcePublish = componentRequiresSourcePublish || PermittedOrRequired.REQUIRED.equals((Object)this.kbComponentPrimaryLicense.getAttributes().getSourceCodeDistribution());
        }
        for (Path path : this.buildTreeOccurences) {
            componentRoot.element("buildTreePath").text(path.toString());
        }
        for (GlobalLicense license : this.kbComponentLicenses) {
            componentRoot.element("alternateLicense").element("license").text(license.getName()).up().element("licenseApproval").text(license.getApprovalState().name()).up();
            componentRequiresSourcePublish = componentRequiresSourcePublish || PermittedOrRequired.REQUIRED.equals((Object)license.getAttributes().getSourceCodeDistribution());
        }
        componentRequiresSourcePublish = componentRequiresSourcePublish && RetrievedComponentUsage.SHIPPING.equals((Object)this.usage);
        componentRoot.element("sourcePublishRequired").text(Boolean.toString(componentRequiresSourcePublish));
    }

    public String getGav() {
        return this.gav;
    }

    public String getMd5Sum() {
        return this.md5Sum;
    }

    public void setMd5Sum(String md5Sum) {
        this.md5Sum = md5Sum;
    }

    public String getRetrievedCacheDirectory() {
        return this.retrievedCacheDirectory;
    }

    public void setRetrievedCacheDirectory(String retrievedCacheDirectory) {
        this.retrievedCacheDirectory = retrievedCacheDirectory;
    }

    public String getRetrievedBinaryArtifact() {
        return this.retrievedBinaryArtifact;
    }

    public void setRetrievedBinaryArtifact(String retrievedBinaryArtifact) {
        this.retrievedBinaryArtifact = retrievedBinaryArtifact;
    }

    public String getRetrievedSourceArtifact() {
        return this.retrievedSourceArtifact;
    }

    public void setRetrievedSourceArtifact(String retrievedSourceArtifact) {
        this.retrievedSourceArtifact = retrievedSourceArtifact;
    }

    public RetrievedComponentUsage getUsage() {
        return this.usage;
    }

    public void setUsage(RetrievedComponentUsage usage) {
        this.usage = usage;
    }

    public Collection<Path> getBuildTreeOccurences() {
        return this.buildTreeOccurences;
    }

    public void setBuildTreeOccurences(Collection<Path> buildTreeOccurences) {
        this.buildTreeOccurences = buildTreeOccurences;
    }

    public String getKbComponentId() {
        return this.kbComponentId;
    }

    public void setKbComponentId(String kbComponentId) {
        this.kbComponentId = kbComponentId;
    }

    public String getKbComponentName() {
        return this.kbComponentName;
    }

    public void setKbComponentName(String kbComponentName) {
        this.kbComponentName = kbComponentName;
    }

    public String getKbComponentVersion() {
        return this.kbComponentVersion;
    }

    public void setKbComponentVersion(String kbComponentVersion) {
        this.kbComponentVersion = kbComponentVersion;
    }

    public String getKbComponentVersionId() {
        return this.kbComponentVersionId;
    }

    public void setKbComponentVersionId(String kbComponentVersionId) {
        this.kbComponentVersionId = kbComponentVersionId;
    }

    public GlobalLicense getKbComponentPrimaryLicense() {
        return this.kbComponentPrimaryLicense;
    }

    public void setKbComponentPrimaryLicense(GlobalLicense kbComponentPrimaryLicense) {
        this.kbComponentPrimaryLicense = kbComponentPrimaryLicense;
    }

    public List<GlobalLicense> getKbComponentLicenses() {
        return this.kbComponentLicenses;
    }

    public void setKbComponentLicenses(List<GlobalLicense> kbComponentLicenses) {
        this.kbComponentLicenses = kbComponentLicenses;
    }

    static enum RetrievedComponentUsage {
        PROJECT_GENERATED("ProjectGenerated"),
        SHIPPING("Shipping"),
        COMPILED_AGAINST("RequiredForCompile"),
        TOOL("BuildTool"),
        UNKNOWN("Unknown");

        private final String usage;

        private RetrievedComponentUsage(String usage) {
            this.usage = usage;
        }

        public String toString() {
            return this.usage;
        }
    }
}

